/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.views.ServerView;
import org.jboss.tools.modeshape.ui.UiUtils;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.Status;

public final class Utils {
    public static int convertSeverity(Status.Severity severity) {
        if (severity == Status.Severity.OK) {
            return 0;
        }
        if (severity == Status.Severity.ERROR) {
            return 4;
        }
        if (severity == Status.Severity.WARNING) {
            return 2;
        }
        if (severity == Status.Severity.INFO) {
            return 1;
        }
        return 8;
    }

    public static Status.Severity convertSeverity(int severity) {
        if (severity == 0) {
            return Status.Severity.OK;
        }
        if (severity == 4) {
            return Status.Severity.ERROR;
        }
        if (severity == 2) {
            return Status.Severity.WARNING;
        }
        if (severity == 1) {
            return Status.Severity.INFO;
        }
        return Status.Severity.UNKNOWN;
    }

    public static IStatus convert(org.modeshape.web.jcr.rest.client.Status status) {
        CheckArg.isNotNull((Object)status, (String)"status");
        return new Status(Utils.convertSeverity(status.getSeverity()), "org.jboss.tools.modeshape.rest", status.getMessage(), status.getException());
    }

    public static Image getImage(org.modeshape.web.jcr.rest.client.Status status) {
        CheckArg.isNotNull((Object)status, (String)"status");
        String imageId = null;
        if (status.isError()) {
            imageId = "IMG_OBJS_ERROR_TSK";
        } else if (status.isInfo()) {
            imageId = "IMG_OBJS_INFO_TSK";
        } else if (status.isWarning()) {
            imageId = "IMG_OBJS_WARN_TSK";
        }
        if (imageId != null) {
            return Activator.getDefault().getSharedImage(imageId);
        }
        return null;
    }

    public static ImageDescriptor getOverlayImage(org.modeshape.web.jcr.rest.client.Status status) {
        CheckArg.isNotNull((Object)status, (String)"status");
        String imageId = null;
        if (status.isError()) {
            imageId = "icons/views/error_overlay.gif";
        }
        if (imageId != null) {
            return Activator.getDefault().getImageDescriptor(imageId);
        }
        return null;
    }

    public static TreeViewer getServerViewer() {
        IViewPart serverView = UiUtils.getView((String)"org.jboss.tools.modeshape.rest.views.serverView");
        return serverView == null ? null : ((ServerView)serverView).getViewer();
    }

    public static org.modeshape.web.jcr.rest.client.Status isPasswordValid(String password) {
        return org.modeshape.web.jcr.rest.client.Status.OK_STATUS;
    }

    public static org.modeshape.web.jcr.rest.client.Status isServerValid(String url, String user, String password) {
        org.modeshape.web.jcr.rest.client.Status status = Utils.isUrlValid(url);
        if (!status.isError() && !(status = Utils.isUserValid(user)).isError()) {
            status = Utils.isPasswordValid(password);
        }
        return status;
    }

    public static org.modeshape.web.jcr.rest.client.Status isUrlValid(String url) {
        if (url == null || url.length() == 0) {
            return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, RestClientI18n.serverEmptyUrlMsg, null);
        }
        try {
            URL testUrl = new URL(url);
            String host = testUrl.getHost();
            if (host == null || "".equals(host)) {
                return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, RestClientI18n.serverInvalidUrlHostMsg, null);
            }
            int port = testUrl.getPort();
            if (port == -1) {
                return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, RestClientI18n.serverInvalidUrlPortMsg, null);
            }
        }
        catch (Exception e) {
            return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.serverInvalidUrlMsg, (Object)url), (Throwable)e);
        }
        return org.modeshape.web.jcr.rest.client.Status.OK_STATUS;
    }

    public static org.modeshape.web.jcr.rest.client.Status isUserValid(String user) {
        if (user == null || user.length() == 0) {
            return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, RestClientI18n.serverEmptyUserMsg, null);
        }
        return org.modeshape.web.jcr.rest.client.Status.OK_STATUS;
    }
}

