/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.metamodels.wsdl.Definitions;
import org.teiid.designer.metamodels.wsdl.Operation;
import org.teiid.designer.metamodels.wsdl.PortType;
import org.teiid.designer.metamodels.wsdl.Service;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.DefaultTreeViewerController;
import org.teiid.designer.ui.common.widget.ITreeViewerController;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceResource;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;

public class SelectWsdlOperationsPage
extends AbstractWizardPage
implements Listener,
FileUtils.Constants,
CoreStringUtil.Constants,
IInternalUiConstants.Images {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(SelectWsdlOperationsPage.class);
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    private TreeViewer treeViewer;
    private Tree tree;
    boolean treeExpanded = false;
    private CheckboxTreeController controller;
    private Button selectAllButton;
    private Button deselectAllButton;
    IWebServiceModelBuilder importBuilder;
    private List wsdlDefinitions = null;
    HashMap definitionsLabelMap = new HashMap();
    private boolean initializing = false;

    public SelectWsdlOperationsPage(IWebServiceModelBuilder builder) {
        super(SelectWsdlOperationsPage.class.getSimpleName(), SelectWsdlOperationsPage.getString("title"));
        this.importBuilder = builder;
        this.setImageDescriptor(WebServiceUiUtil.getImageDescriptor("icons/full/wizban/WebService.gif"));
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (event.widget == this.selectAllButton) {
                this.setAllNodesSelected(true);
            }
            if (event.widget == this.deselectAllButton) {
                this.setAllNodesSelected(false);
            }
            if (validate) {
                this.setPageStatus();
            }
        }
    }

    public void createControl(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        pnlMain.setLayout((Layout)layout);
        this.setControl((Control)pnlMain);
        SashForm splitter = new SashForm(pnlMain, 512);
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        splitter.setLayoutData((Object)gid);
        this.createCheckboxTreeComposite((Composite)splitter, SelectWsdlOperationsPage.getString("checkboxTreeGroup.title"));
        this.restoreState();
    }

    private void createCheckboxTreeComposite(Composite parent, String title) {
        Composite checkBoxTreeComposite = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        checkBoxTreeComposite.setLayout((Layout)layout);
        Group group = WidgetFactory.createGroup((Composite)checkBoxTreeComposite, (String)title, (int)1808, (int)1, (int)2);
        this.controller = new CheckboxTreeController();
        this.treeViewer = WidgetFactory.createTreeViewer((Composite)group, (int)36, (int)1808, (ITreeViewerController)this.controller);
        this.tree = this.treeViewer.getTree();
        this.tree.addListener(13, (Listener)this);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new CheckboxTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CheckboxTreeLabelProvider());
        this.treeViewer.setInput(null);
        Composite buttonComposite = WidgetFactory.createPanel((Composite)group, (int)0, (int)1040);
        layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        this.selectAllButton = WidgetFactory.createButton((Composite)buttonComposite, (String)SelectWsdlOperationsPage.getString("selectAllButton.text"), (int)768);
        this.selectAllButton.setToolTipText(SelectWsdlOperationsPage.getString("selectAllButton.tipText"));
        this.deselectAllButton = WidgetFactory.createButton((Composite)buttonComposite, (String)SelectWsdlOperationsPage.getString("deselectAllButton.text"), (int)768);
        this.deselectAllButton.setToolTipText(SelectWsdlOperationsPage.getString("deselectAllButton.tipText"));
        this.selectAllButton.addListener(13, (Listener)this);
        this.deselectAllButton.addListener(13, (Listener)this);
    }

    public void dispose() {
        this.saveState();
    }

    private static String getString(String theKey) {
        return IInternalUiConstants.UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    private void restoreState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            try {
                int x = settings.getInt(DIALOG_X);
                int y = settings.getInt(DIALOG_Y);
                int width = settings.getInt(DIALOG_WIDTH);
                int height = settings.getInt(DIALOG_HEIGHT);
                shell.setBounds(x, y, width, height);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    void setPageStatus() {
        WizardUtil.setPageComplete((WizardPage)this);
        this.getContainer().updateButtons();
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.definitionsLabelMap.clear();
            this.wsdlDefinitions = this.getInputFromBuilder();
            this.treeViewer.setInput((Object)this.wsdlDefinitions);
            this.importBuilder.setSelectedOperations(new ArrayList());
            this.treeViewer.expandToLevel(3);
            this.setAllNodesSelected(true);
            this.setPageStatus();
        }
        super.setVisible(isVisible);
    }

    private List getInputFromBuilder() {
        ArrayList<EObject> allRoots = new ArrayList<EObject>();
        Collection resources = this.importBuilder.getWSDLResources();
        for (IWebServiceResource wsr : resources) {
            Resource emfResource = this.importBuilder.getEmfResource(wsr);
            if (emfResource == null) continue;
            EList roots = emfResource.getContents();
            for (EObject root : roots) {
                if (!(root instanceof Definitions)) continue;
                allRoots.add(root);
                this.definitionsLabelMap.put(root, "Definitions: " + emfResource.getURI());
            }
        }
        return allRoots;
    }

    private void setAllNodesSelected(boolean bSelected) {
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            this.setAllSelected(items[i], bSelected);
            ++i;
        }
    }

    private void setAllSelected(TreeItem item, boolean checked) {
        WidgetUtil.setChecked((TreeItem)item, (boolean)checked, (boolean)false, (ITreeViewerController)this.controller);
        TreeItem[] children = item.getItems();
        int ndx = 0;
        while (ndx < children.length) {
            this.setAllSelected(children[ndx], checked);
            ++ndx;
        }
    }

    boolean hasValidOperation(Object object) {
        boolean hasValid = false;
        if (object instanceof Definitions) {
            EList services = ((Definitions)object).getServices();
            Iterator iter = services.iterator();
            while (iter.hasNext()) {
                if (!this.hasValidOperation(iter.next())) continue;
                hasValid = true;
                break;
            }
        } else if (object instanceof Service) {
            EList ports = ((Service)object).getPorts();
            Iterator iter = ports.iterator();
            while (iter.hasNext()) {
                if (!this.hasValidOperation(iter.next())) continue;
                hasValid = true;
                break;
            }
        } else if (object instanceof PortType) {
            EList operations = ((PortType)object).getOperations();
            Iterator iter = operations.iterator();
            while (iter.hasNext()) {
                if (!this.hasValidOperation(iter.next())) continue;
                hasValid = true;
                break;
            }
        } else if (object instanceof Operation) {
            hasValid = true;
        }
        return hasValid;
    }

    class CheckboxTreeContentProvider
    implements ITreeContentProvider {
        CheckboxTreeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object node) {
            if (node instanceof Collection) {
                return ((Collection)node).toArray();
            }
            if (node instanceof Definitions) {
                return ((Definitions)node).getPortTypes().toArray();
            }
            if (node instanceof PortType) {
                return ((PortType)node).getOperations().toArray();
            }
            return EMPTY_STRING_ARRAY;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object node) {
            if (node instanceof Definitions) {
                return null;
            }
            if (node instanceof PortType) {
                return ((PortType)node).eContainer();
            }
            if (node instanceof Operation) {
                return ((Operation)node).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object node) {
            if (node instanceof Collection) {
                return !((Collection)node).isEmpty();
            }
            if (node instanceof Definitions) {
                return !((Definitions)node).getPortTypes().isEmpty();
            }
            if (node instanceof PortType) {
                return !((PortType)node).getOperations().isEmpty();
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CheckboxTreeController
    extends DefaultTreeViewerController {
        CheckboxTreeController() {
        }

        public void checkedStateToggled(TreeItem item) {
        }

        public boolean isItemCheckable(TreeItem item) {
            Object node = item.getData();
            if (node instanceof Service || node instanceof PortType || node instanceof Operation) {
                return SelectWsdlOperationsPage.this.hasValidOperation(node);
            }
            return false;
        }

        public void update(TreeItem item, boolean selected) {
            Object dataObj = item.getData();
            if (dataObj != null) {
                boolean checked;
                boolean bl = checked = !WidgetUtil.isUnchecked((TreeItem)item);
                if (this.isItemCheckable(item)) {
                    item.setChecked(checked);
                }
                item.setGrayed(WidgetUtil.isPartiallyChecked((TreeItem)item));
                if (selected) {
                    this.updateChildren(item, checked);
                    TreeItem parent = item.getParentItem();
                    while (parent != null) {
                        int state = 4;
                        TreeItem[] children = parent.getItems();
                        int ndx = children.length;
                        while (--ndx >= 0) {
                            TreeItem child = children[ndx];
                            if (WidgetUtil.isPartiallyChecked((TreeItem)child)) {
                                state = 4;
                                break;
                            }
                            int childState = WidgetUtil.getCheckedState((TreeItem)child);
                            if (state == 4) {
                                state = childState;
                                continue;
                            }
                            if (state == childState) continue;
                            state = 4;
                            break;
                        }
                        if (state != WidgetUtil.getCheckedState((TreeItem)parent)) {
                            WidgetUtil.setCheckedState((TreeItem)parent, (int)state, (boolean)false, (ITreeViewerController)this);
                        }
                        parent = parent.getParentItem();
                    }
                }
                if (dataObj instanceof Operation && SelectWsdlOperationsPage.this.hasValidOperation(dataObj)) {
                    this.updateCheckedOperations((Operation)dataObj, checked);
                }
                if (!this.isItemCheckable(item)) {
                    item.setGrayed(true);
                    item.setChecked(false);
                } else {
                    item.setGrayed(false);
                }
            }
        }

        private void updateCheckedOperations(Operation operation, boolean checked) {
            Collection selectedOperations = SelectWsdlOperationsPage.this.importBuilder.getSelectedOperations();
            if (checked && !selectedOperations.contains(operation)) {
                selectedOperations.add(operation);
                SelectWsdlOperationsPage.this.importBuilder.setSelectedOperations(selectedOperations);
                SelectWsdlOperationsPage.this.setPageStatus();
            } else if (!checked && selectedOperations.contains(operation)) {
                selectedOperations.remove(operation);
                SelectWsdlOperationsPage.this.importBuilder.setSelectedOperations(selectedOperations);
                SelectWsdlOperationsPage.this.setPageStatus();
            }
        }

        private void updateChildren(TreeItem item, boolean checked) {
            TreeItem[] children = item.getItems();
            int ndx = children.length;
            while (--ndx >= 0) {
                TreeItem child = children[ndx];
                if (child.getData() == null) continue;
                this.updateChildren(child, checked);
                WidgetUtil.setChecked((TreeItem)child, (boolean)checked, (boolean)false, (ITreeViewerController)this);
            }
        }

        public void itemExpanded(TreeExpansionEvent event) {
            if (SelectWsdlOperationsPage.this.treeExpanded) {
                super.itemExpanded(event);
            } else if (((TreeViewer)event.getTreeViewer()).getTree().getSelection().length > 0) {
                TreeItem item = ((TreeViewer)event.getTreeViewer()).getTree().getSelection()[0];
                if (item.getData() != null) {
                    this.updateChildren(item, false);
                }
                SelectWsdlOperationsPage.this.treeExpanded = true;
            }
        }

        public void itemCollapsed(TreeExpansionEvent event) {
            super.itemCollapsed(event);
        }
    }

    class CheckboxTreeLabelProvider
    extends LabelProvider {
        private final Image SERVICE_ICON_IMG = WebServiceUiPlugin.getDefault().getImage("icons/full/obj16/service_obj.gif");
        private final Image PORT_ICON_IMG = WebServiceUiPlugin.getDefault().getImage("icons/full/obj16/port_obj.gif");
        private final Image OPERATION_ICON_IMG = WebServiceUiPlugin.getDefault().getImage("icons/full/obj16/operation_obj.gif");
        final WorkbenchLabelProvider workbenchProvider = new WorkbenchLabelProvider();

        CheckboxTreeLabelProvider() {
        }

        public Image getImage(Object node) {
            if (node instanceof Definitions) {
                return this.SERVICE_ICON_IMG;
            }
            if (node instanceof PortType) {
                return this.PORT_ICON_IMG;
            }
            if (node instanceof Operation) {
                return this.OPERATION_ICON_IMG;
            }
            return null;
        }

        public String getText(Object node) {
            if (node instanceof Definitions) {
                String theText = (String)SelectWsdlOperationsPage.this.definitionsLabelMap.get(node);
                if (theText == null) {
                    theText = "Definitions";
                }
                return theText;
            }
            if (node instanceof PortType) {
                return ((PortType)node).getName();
            }
            if (node instanceof Operation) {
                return ((Operation)node).getName();
            }
            return "unknownElement";
        }
    }
}

