/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceXsdResource;
import org.teiid.designer.webservice.NonResolvableXSDSchema;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;
import org.teiid.designer.webservice.ui.wizard.SchemaLocationEditor;

public class SchemaLocationPage
extends AbstractWizardPage
implements IInternalUiConstants,
IInternalUiConstants.HelpContexts,
IInternalUiConstants.Images {
    static final String PREFIX = I18nUtil.getPropertyPrefix(SchemaLocationPage.class);
    private static final String[] TBL_HDRS;
    static final int ERROR_COLUMN;
    static final int NAMESPACE_COLUMN;
    static final int SOURCE_FILE_COLUMN;
    static final int TARGET_PATH_COLUMN;
    private IWebServiceModelBuilder builder;
    private IAction showEditorAction;
    private SchemaLocationEditor editor;
    private CLabel lblStatusMsg;
    private TableViewer viewer;
    private ViewForm viewForm;

    static {
        ERROR_COLUMN = 0;
        NAMESPACE_COLUMN = 1;
        SOURCE_FILE_COLUMN = 2;
        TARGET_PATH_COLUMN = 3;
        TBL_HDRS = new String[4];
        SchemaLocationPage.TBL_HDRS[SchemaLocationPage.ERROR_COLUMN] = "";
        SchemaLocationPage.TBL_HDRS[SchemaLocationPage.NAMESPACE_COLUMN] = SchemaLocationPage.getString("table.column.namespace");
        SchemaLocationPage.TBL_HDRS[SchemaLocationPage.SOURCE_FILE_COLUMN] = SchemaLocationPage.getString("table.column.sourceFile");
        SchemaLocationPage.TBL_HDRS[SchemaLocationPage.TARGET_PATH_COLUMN] = SchemaLocationPage.getString("table.column.targetPath");
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    public SchemaLocationPage(IWebServiceModelBuilder theBuilder) {
        super(SchemaLocationPage.class.getSimpleName(), SchemaLocationPage.getString("title"));
        this.builder = theBuilder;
        this.setImageDescriptor(WebServiceUiUtil.getImageDescriptor("icons/full/wizban/WebService.gif"));
    }

    public void createControl(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        this.setControl((Control)pnlMain);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, "org.teiid.designer.webservice.ui.schemaLocationPage");
        this.viewForm = WidgetFactory.createViewForm((Composite)pnlMain, (int)2048, (int)1808, (int)1);
        this.viewForm.setTopLeft((Control)WidgetFactory.createLabel((Composite)this.viewForm, (String)SchemaLocationPage.getString("label.viewForm")));
        this.createTablePanelContents(this.viewForm);
        this.createTableActions(WidgetFactory.createViewFormToolBar((ViewForm)this.viewForm));
        this.editor = new SchemaLocationEditor(pnlMain, this.builder);
        this.editor.setLayoutData(new GridData(768));
        this.editor.addListener(new Listener(){

            public void handleEvent(Event theEvent) {
                SchemaLocationPage.this.processEditorEvent(theEvent);
            }
        });
    }

    private void createTableActions(IToolBarManager theToolBarMgr) {
        this.showEditorAction = new Action("", 8){

            public void run() {
                SchemaLocationPage.this.showEditor(!SchemaLocationPage.this.getEditor().isVisible());
            }
        };
        this.showEditorAction.setImageDescriptor(WebServiceUiUtil.getImageDescriptor("icons/full/cview16/schemaEditor.gif"));
        this.showEditorAction.setToolTipText(SchemaLocationPage.getString("button.showEditor.tip"));
        this.showEditorAction.setChecked(true);
        theToolBarMgr.add(this.showEditorAction);
        theToolBarMgr.update(true);
    }

    private void createTablePanelContents(ViewForm theViewForm) {
        Composite pnl = WidgetFactory.createPanel((Composite)theViewForm, (int)0, (int)1808);
        theViewForm.setContent((Control)pnl);
        int style = 68356;
        Table tbl = new Table(pnl, style);
        tbl.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = tbl.getItemHeight() * 8;
        gd.widthHint = 450;
        tbl.setLayoutData((Object)gd);
        this.viewer = new TableViewer(tbl);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                SchemaLocationPage.this.handleRowSelected();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent theEvent) {
                SchemaLocationPage.this.handleDoubleClick();
            }
        });
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        int i = 0;
        while (i < TBL_HDRS.length) {
            TableColumn col = new TableColumn(tbl, 16384);
            col.setText(TBL_HDRS[i]);
            col.pack();
            if (i == ERROR_COLUMN) {
                col.setResizable(false);
                col.setImage(WebServiceUiUtil.getImage("icons/full/cview16/problem_indicator.gif"));
            }
            ++i;
        }
        this.lblStatusMsg = WidgetFactory.createLabel((Composite)pnl, (int)256);
    }

    IWebServiceModelBuilder getBuilder() {
        return this.builder;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("WebServiceModel");
            settings = temp == null ? settings.addNewSection("WebServiceModel") : temp;
        }
        return settings;
    }

    SchemaLocationEditor getEditor() {
        return this.editor;
    }

    void handleDoubleClick() {
        if (!this.getEditor().isVisible()) {
            this.showEditor(true);
        }
    }

    void handleRowSelected() {
        this.handleUnsavedEditor();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        boolean doEdit = !selection.isEmpty();
        this.editor.setEnabled(doEdit);
        if (doEdit) {
            this.editor.setInput(selection.toList());
        } else {
            this.editor.clear();
        }
        this.updateStatusLabel();
        this.updatePageStatus();
    }

    void handleUnsavedEditor() {
        if (this.editor.isDirty() && this.editor.canSave()) {
            String msg = null;
            List editorInput = this.editor.getInput();
            if (editorInput.size() == 1) {
                IWebServiceXsdResource xsd = (IWebServiceXsdResource)editorInput.get(0);
                msg = UTIL.getString(String.valueOf(PREFIX) + "dialog.dirtyEditor.oneFile.msg", new Object[]{xsd.getTargetNamespace()});
            } else {
                msg = SchemaLocationPage.getString("dialog.dirtyEditor.multipleFiles.msg");
            }
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)SchemaLocationPage.getString("dialog.dirtyEditor.title"), (String)msg)) {
                this.editor.save();
            }
        }
    }

    private void packTableColumns() {
        Table tbl = this.viewer.getTable();
        int i = 0;
        while (i < TBL_HDRS.length) {
            tbl.getColumn(i).pack();
            ++i;
        }
    }

    void processEditorEvent(Event theEvent) {
        if (theEvent.type == 3) {
            this.showEditor(false);
        } else {
            List editorInput = this.editor.getInput();
            int size = editorInput.size();
            int i = 0;
            while (i < size) {
                this.viewer.refresh(editorInput.get(0), true);
                ++i;
            }
            this.packTableColumns();
            this.updatePageStatus();
            this.updateStatusLabel();
        }
    }

    public void setVisible(boolean theShowFlag) {
        this.handleRowSelected();
        if (theShowFlag) {
            this.editor.setDialogSettings(this.getDialogSettings());
            this.viewer.setInput((Object)this);
            this.packTableColumns();
            this.viewer.getControl().setFocus();
        } else {
            this.editor.clear();
        }
        super.setVisible(theShowFlag);
    }

    void showEditor(boolean theShowFlag) {
        this.showEditorAction.setChecked(theShowFlag);
        this.editor.setVisible(theShowFlag);
        this.editor.getParent().layout(true);
    }

    private void updatePageStatus() {
        boolean enable = true;
        int severity = 0;
        String msgId = null;
        Collection xsdResources = null;
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Get XSD Destinations", (Object)this);
        boolean succeeded = false;
        try {
            xsdResources = this.builder.getXsdDestinations();
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        if (xsdResources == null || xsdResources.isEmpty()) {
            msgId = "page.msg.noXsdResources";
            enable = false;
        } else {
            for (IWebServiceXsdResource xsd : xsdResources) {
                IStatus status = xsd.isValid();
                if (status.getSeverity() > severity && (severity = status.getSeverity()) == 4) break;
            }
            switch (severity) {
                case 4: {
                    msgId = "page.msg.error";
                    break;
                }
                case 2: {
                    msgId = "page.msg.warning";
                    break;
                }
                case 1: {
                    msgId = "page.msg.info";
                    break;
                }
                default: {
                    msgId = "page.msg.ok";
                }
            }
        }
        this.viewer.getControl().setEnabled(enable);
        String msg = SchemaLocationPage.getString(msgId);
        if (severity == 4) {
            this.setMessage(msg, 4);
            this.setPageComplete(false);
        } else {
            this.setMessage(msg, severity);
            this.setPageComplete(true);
        }
    }

    private void updateStatusLabel() {
        IWebServiceXsdResource xsd;
        IStatus status;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Image image = null;
        String text = "";
        if (selection.size() == 1 && !(status = (xsd = (IWebServiceXsdResource)selection.getFirstElement()).isValid()).isOK()) {
            image = WebServiceUiUtil.getStatusImage(status);
            text = status.getMessage();
        }
        this.lblStatusMsg.setImage(image);
        this.lblStatusMsg.setText(text);
    }

    String getUrlValue(String schemaLocation) {
        Object location = null;
        Map urlMap = this.getBuilder().getUrlMap();
        String substringLocation = schemaLocation.substring(1);
        if (urlMap != null) {
            location = urlMap.get(substringLocation);
        }
        return location == null ? schemaLocation : location.toString();
    }

    String formatLocation(String schemaLocation) {
        String location = schemaLocation;
        if (location.indexOf("file:/") > -1) {
            location = location.substring(6);
        }
        return location;
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            Collection xsdResources = SchemaLocationPage.this.getBuilder().getXsdDestinations();
            return xsdResources == null ? Collections.EMPTY_LIST.toArray() : xsdResources.toArray();
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object theElement, int theColumnIndex) {
            Image result = null;
            if (theElement instanceof IWebServiceXsdResource) {
                if (theColumnIndex == ERROR_COLUMN) {
                    IStatus status = ((IWebServiceXsdResource)theElement).isValid();
                    result = WebServiceUiUtil.getStatusImage(status);
                }
            } else {
                CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownObjectType", new Object[]{theElement.getClass().getName()}));
            }
            return result;
        }

        public String getColumnText(Object theElement, int theIndex) {
            String result = null;
            if (theElement instanceof IWebServiceXsdResource) {
                IWebServiceXsdResource xsd = (IWebServiceXsdResource)theElement;
                if (theIndex == ERROR_COLUMN) {
                    result = "";
                } else if (theIndex == NAMESPACE_COLUMN) {
                    result = xsd.getTargetNamespace();
                } else if (theIndex == SOURCE_FILE_COLUMN) {
                    String schemaLoc;
                    NonResolvableXSDSchema nrSchema;
                    String schemaLoc2;
                    result = xsd.getSchema() instanceof NonResolvableXSDSchema ? ((schemaLoc2 = (nrSchema = (NonResolvableXSDSchema)xsd.getSchema()).getSchemaLocation()) != null ? SchemaLocationPage.this.formatLocation(schemaLoc2) : (nrSchema.getUri() != null ? nrSchema.getUri().toString() : null)) : ((schemaLoc = xsd.getSchema().getSchemaLocation()) != null ? SchemaLocationPage.this.formatLocation(schemaLoc) : SchemaLocationPage.this.getUrlValue(xsd.getOriginalPath()));
                } else if (theIndex == TARGET_PATH_COLUMN) {
                    result = xsd.getDestinationPath().makeRelative().toOSString();
                } else {
                    CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownTableColumn", new Object[]{Integer.toString(theIndex)}));
                }
            } else {
                CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownObjectType", new Object[]{theElement.getClass().getName()}));
            }
            return result;
        }
    }
}

