/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.table.TableViewerSorter;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.AbstractTableLabelProvider;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;

public class ImportWsdlValidationPage
extends AbstractWizardPage
implements FileUtils.Constants,
IInternalUiConstants,
IInternalUiConstants.HelpContexts,
IInternalUiConstants.Images {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ImportWsdlValidationPage.class);
    private static final int SEVERITY_COLUMN = 0;
    private static final int MESSAGE_COLUMN = 1;
    private static final int OBJECT_COLUMN = 2;
    private static final int LINE_NUMBER_COLUMN = 3;
    private static final String MESSAGE_HEADER = ImportWsdlValidationPage.getString("messageHeader");
    private static final String OBJECT_HEADER = ImportWsdlValidationPage.getString("objectHeader");
    private static final String LINE_NUMBER_HEADER = ImportWsdlValidationPage.getString("lineNumber");
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    protected IWebServiceModelBuilder builder;
    private IAction viewWsdlAction;
    private TableViewer viewer;
    List wsdlValidationMessages = new LinkedList();
    private boolean wsdlsHaveErrors = false;

    public ImportWsdlValidationPage(IWebServiceModelBuilder theBuilder) {
        super(ImportWsdlValidationPage.class.getSimpleName(), ImportWsdlValidationPage.getString("title"));
        this.builder = theBuilder;
        this.setImageDescriptor(WebServiceUiUtil.getImageDescriptor("icons/full/wizban/WebService.gif"));
    }

    public void createControl(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        pnlMain.setLayout((Layout)layout);
        this.setControl((Control)pnlMain);
        this.createTablePanel(pnlMain);
        this.nameModified();
    }

    public boolean canFlipToNextPage() {
        return !this.wsdlsHaveErrors && super.canFlipToNextPage();
    }

    private void createTableActions(IToolBarManager theToolBarMgr) {
        this.viewWsdlAction = new Action(ImportWsdlValidationPage.getString("action.viewWsdlFile"), 1){

            public void run() {
                ImportWsdlValidationPage.this.handleViewWsdlFile();
            }
        };
        this.viewWsdlAction.setImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor("IMG_OBJ_FILE"));
        this.viewWsdlAction.setToolTipText(ImportWsdlValidationPage.getString("action.viewWsdlFile.tip"));
        this.viewWsdlAction.setEnabled(false);
        theToolBarMgr.add(this.viewWsdlAction);
        theToolBarMgr.update(true);
    }

    protected void createTableContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.add(this.viewWsdlAction);
        Control table = this.viewer.getControl();
        table.setMenu(mgr.createContextMenu(table));
    }

    private void createTablePanel(Composite theParent) {
        ViewForm viewForm = WidgetFactory.createViewForm((Composite)theParent, (int)2048, (int)1808, (int)1);
        viewForm.setTopLeft((Control)WidgetFactory.createLabel((Composite)viewForm, (String)ImportWsdlValidationPage.getString("WSDL_Validation_Panel")));
        Composite pnl = WidgetFactory.createPanel((Composite)viewForm, (int)0, (int)1808);
        viewForm.setContent((Control)pnl);
        this.viewer = WidgetFactory.createTableViewer((Composite)pnl, (int)65536);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        WidgetFactory.createTableColumn((Table)table);
        WidgetFactory.createTableColumn((Table)table, (String)MESSAGE_HEADER);
        WidgetFactory.createTableColumn((Table)table, (String)OBJECT_HEADER);
        WidgetFactory.createTableColumn((Table)table, (String)LINE_NUMBER_HEADER);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ImportWsdlValidationPage.this.wsdlValidationMessages.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new AbstractTableLabelProvider(){

            public Image getColumnImage(Object element, int column) {
                if (column == 0) {
                    return ImportWsdlValidationPage.this.getStatusImage(((IValidationMessage)element).getSeverity());
                }
                return null;
            }

            public String getColumnText(Object element, int column) {
                IValidationMessage message = (IValidationMessage)element;
                switch (column) {
                    case 1: {
                        String messageString = message.getMessage();
                        return messageString == null ? "" : messageString;
                    }
                    case 2: {
                        String target = (String)ImportWsdlValidationPage.this.builder.getUrlMap().get(message.getURI().substring(message.getURI().lastIndexOf(47) + 1));
                        if (target == null) {
                            target = message.getURI();
                        }
                        return target == null ? "" : target;
                    }
                    case 3: {
                        String lineNumber = String.valueOf(message.getLine());
                        return lineNumber == null ? "" : lineNumber;
                    }
                }
                return "";
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        this.viewer.setSorter((ViewerSorter)new TableViewerSorter(this.viewer, 0, 0){

            protected int compareColumn(TableViewer viewer, Object object1, Object object2, int column) {
                if (column == 0) {
                    return ((IValidationMessage)object2).getSeverity() - ((IValidationMessage)object1).getSeverity();
                }
                return super.compareColumn(viewer, object1, object2, column);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                ImportWsdlValidationPage.this.handleTableSelectionChanged();
            }
        });
        this.viewer.setInput((Object)this);
        WidgetUtil.pack((Table)table);
        this.createTableActions(WidgetFactory.createViewFormToolBar((ViewForm)viewForm));
        this.createTableContextMenu();
    }

    void nameModified() {
        this.validatePage();
    }

    public void dispose() {
        this.saveState();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("WebServiceModel");
            settings = temp == null ? settings.addNewSection("WebServiceModel") : temp;
        }
        return settings;
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.viewWsdlAction.setEnabled(selection.size() == 1);
    }

    void handleViewWsdlFile() {
        WebServiceUiUtil.viewFile(this.getShell(), this.viewer.getSelection());
    }

    private void restoreState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            try {
                int x = settings.getInt(DIALOG_X);
                int y = settings.getInt(DIALOG_Y);
                int width = settings.getInt(DIALOG_WIDTH);
                int height = settings.getInt(DIALOG_HEIGHT);
                shell.setBounds(x, y, width, height);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    public void setVisible(boolean theShowFlag) {
        if (theShowFlag) {
            if (this.viewer.getInput() == null) {
                this.restoreState();
            }
            this.setPageComplete(true);
            this.viewer.setInput((Object)this);
        }
        super.setVisible(theShowFlag);
        this.validatePage();
    }

    public boolean hasValidationMessages() {
        return this.wsdlValidationMessages.size() > 0;
    }

    public boolean hasValidationErrors() {
        this.wsdlsHaveErrors = false;
        ListIterator messageIter = this.wsdlValidationMessages.listIterator();
        while (messageIter.hasNext()) {
            IValidationMessage message = (IValidationMessage)messageIter.next();
            if (message.getSeverity() != 0) continue;
            this.wsdlsHaveErrors = true;
        }
        return this.wsdlsHaveErrors;
    }

    public void setValidationMessages(Map wsdlValidationMessageMap) {
        for (IValidationReport report : wsdlValidationMessageMap.values()) {
            IValidationMessage[] messages = report.getValidationMessages();
            int i = 0;
            while (i < messages.length) {
                if (!this.wsdlValidationMessages.contains(messages[i])) {
                    boolean alreadyExists = false;
                    int j = 0;
                    while (j < this.wsdlValidationMessages.size()) {
                        IValidationMessage currentWsdlMessage = (IValidationMessage)this.wsdlValidationMessages.get(j);
                        if (currentWsdlMessage.getMessage().equals(messages[i].getMessage()) && currentWsdlMessage.getLine() == messages[i].getLine()) {
                            alreadyExists = true;
                            break;
                        }
                        ++j;
                    }
                    if (!alreadyExists) {
                        this.wsdlValidationMessages.add(messages[i]);
                    }
                }
                ++i;
            }
        }
    }

    public void clearValidationMessages() {
        this.wsdlValidationMessages.clear();
    }

    private void validatePage() {
        if (this.hasValidationErrors()) {
            WizardUtil.setPageComplete((WizardPage)this, (String)ImportWsdlValidationPage.getString("One_or_more_selected_WSDL_files_have_errors"), (int)3);
        } else if (this.hasValidationMessages()) {
            WizardUtil.setPageComplete((WizardPage)this, (String)ImportWsdlValidationPage.getString("One_or_more_selected_WSDL_files_have_warnings"), (int)2);
        }
    }

    Image getStatusImage(int severity) {
        switch (severity) {
            case 0: {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            case 1: {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
        }
        return null;
    }
}

