/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.editor;

import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.proc.IAssignmentStatement;
import org.teiid.designer.query.sql.proc.IDeclareStatement;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.AbstractTableLabelProvider;
import org.teiid.designer.ui.common.widget.DefaultContentProvider;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;
import org.teiid.designer.webservice.ui.editor.OperationObjectEditorPage;
import org.teiid.designer.webservice.util.WebServiceUtil;

public class InputVariableSection
implements IInternalUiConstants {
    private static final String I18N_PFX = I18nUtil.getPropertyPrefix(InputVariableSection.class);
    private static final String VARS_TITLE = UTIL.getString(String.valueOf(I18N_PFX) + "variablesTitle", new Object[0]);
    OperationObjectEditorPage editor;
    private Composite client;
    TableViewer varViewer;
    private Section parentSection;
    IAction deleteVariablesAction;
    IAction renameVariableAction;
    Shell renameEditor;

    public InputVariableSection(Composite parent, String description, OperationObjectEditorPage editor) {
        this.editor = editor;
        FormToolkit toolkit = WebServiceUiPlugin.getDefault().getFormToolkit(parent.getDisplay());
        this.parentSection = toolkit.createSection(parent, 384);
        this.parentSection.setText(VARS_TITLE);
        this.parentSection.setDescription(description);
        this.parentSection.getDescriptionControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                event.gc.setForeground(event.display.getSystemColor(15));
                event.gc.drawLine(0, event.height - 1, event.width - 1, event.height - 1);
            }
        });
        this.client = WidgetFactory.createPanel((Composite)this.parentSection, (int)0);
        this.parentSection.setClient((Control)this.client);
        toolkit.paintBordersFor(this.client);
        this.client.setBackground(this.parentSection.getBackground());
        GridLayout layout = (GridLayout)this.client.getLayout();
        layout.verticalSpacing = 1;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.varViewer.addSelectionChangedListener(listener);
    }

    public void create() {
        this.createActionControls(this.client);
        this.varViewer = WidgetFactory.createTableViewer((Composite)this.client, (int)1073742594);
        Table table = this.varViewer.getTable();
        this.varViewer.setContentProvider((IContentProvider)new DefaultContentProvider());
        this.varViewer.setLabelProvider((IBaseLabelProvider)new AbstractTableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                IDeclareStatement declaration = (IDeclareStatement)((Map.Entry)element).getKey();
                return String.valueOf(declaration.getVariable().getShortName()) + " : " + declaration.getVariableType();
            }
        });
        table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent event) {
                InputVariableSection.this.updateToolTip(event);
            }

            public void mouseHover(MouseEvent event) {
                InputVariableSection.this.updateToolTip(event);
            }
        });
        this.varViewer.setInput((Object)this.editor.getDeclarationsToAssignments());
        table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                InputVariableSection.this.editor.setAllowsExternalEdits(true);
            }

            public void focusGained(FocusEvent fe) {
                InputVariableSection.this.editor.setAllowsExternalEdits(false);
            }
        });
    }

    protected void createActionControls(Composite parent) {
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.varViewer.getSelection();
    }

    public void refresh() {
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                InputVariableSection.this.varViewer.refresh();
            }
        }, (boolean)true);
    }

    public void select(Map.Entry entry) {
        WidgetUtil.select((Object)entry, (Viewer)this.varViewer);
    }

    public void clearSelection() {
        this.varViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            Color fgdColor = Display.getDefault().getSystemColor(21);
            this.client.setForeground(fgdColor);
            this.parentSection.setForeground(fgdColor);
            this.parentSection.setTitleBarForeground(fgdColor);
        } else {
            Color fgdColor = Display.getDefault().getSystemColor(18);
            this.client.setForeground(fgdColor);
            this.parentSection.setForeground(fgdColor);
            this.parentSection.setTitleBarForeground(fgdColor);
        }
    }

    void updateToolTip(MouseEvent event) {
        Table table = this.varViewer.getTable();
        TableItem item = table.getItem(new Point(event.x, event.y));
        if (item == null) {
            table.setToolTipText(null);
        } else {
            Map.Entry entry = (Map.Entry)item.getData();
            table.setToolTipText(WebServiceUtil.getXpath((IAssignmentStatement)((IAssignmentStatement)entry.getValue())));
        }
    }
}

