/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalViewProcedure;
import org.teiid.designer.transformation.model.RelationalViewModelFactory;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.ScrollableTitleAreaDialog;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;

public class GenerateRestVirtualProceduresAction
extends SortableSelectionAction
implements IInternalUiConstants {
    private static final char SQL_ESCAPE_CHAR = '\"';
    private static final String DEFAULT_REST_XML_GROUPTAG = "elems";
    private static final String DEFAULT_REST_XML_ELEMENTTAG = "elem";
    private static final String RESTPROC_SUFFIX = GenerateRestVirtualProceduresAction.getString("restProcSuffix");
    private static final String VIEW_XML_TAG_LABEL = GenerateRestVirtualProceduresAction.getString("viewXmlTagLabel");
    private static final String COLUMN_XML_TAG_LABEL = GenerateRestVirtualProceduresAction.getString("columnXmlTagLabel");
    final ViewerFilter virtualModelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            doSelect = ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            ModelerCore.Util.log((Throwable)e);
                        }
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                        }
                        if (theModel != null && ModelIdentifier.isRelationalViewModel((ModelResource)theModel)) {
                            doSelect = true;
                        }
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            }
            return doSelect;
        }
    };

    private static final String getString(String key) {
        return UTIL.getString("generateRestVirtualProceduresAction." + key, new Object[0]);
    }

    public GenerateRestVirtualProceduresAction() {
        this.setImageDescriptor(WebServiceUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-view-procedure.png"));
        this.setToolTipText(GenerateRestVirtualProceduresAction.getString("tooltip"));
    }

    public boolean isApplicable(ISelection selection) {
        return this.isValidSelection(selection);
    }

    protected boolean isValidSelection(ISelection selection) {
        if (SelectionUtilities.isEmptySelection((ISelection)selection) || SelectionUtilities.isMultiSelection((ISelection)selection)) {
            return false;
        }
        if (!SelectionUtilities.isAllIResourceObjects((ISelection)selection)) {
            return false;
        }
        ModelResource modelResource = this.getModelResource(selection);
        if (modelResource != null) {
            try {
                return (ModelIdentifier.isRelationalSourceModel((ModelResource)modelResource) || ModelIdentifier.isRelationalViewModel((ModelResource)modelResource)) && this.hasTable(modelResource);
            }
            catch (ModelWorkspaceException err) {
                UTIL.log((Throwable)err);
            }
            catch (ModelerCoreException err) {
                UTIL.log((Throwable)err);
            }
        }
        return false;
    }

    private ModelResource getModelResource(ISelection selection) {
        Object obj = SelectionUtilities.getSelectedObject((ISelection)selection);
        if (obj instanceof IFile) {
            return ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)obj));
        }
        return null;
    }

    private boolean hasTable(ModelResource mr) throws ModelWorkspaceException, ModelerCoreException {
        TableFinder visitor = new TableFinder();
        ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor, 1);
        processor.walk(mr, 2);
        return visitor.hasTable();
    }

    public void run() {
        SelectViewsAndTablesDialog dialog;
        IWorkbenchWindow iww = WebServiceUiPlugin.getDefault().getCurrentWorkbenchWindow();
        ModelResource modelResource = this.getModelResource(this.getSelection());
        if (modelResource != null && (dialog = new SelectViewsAndTablesDialog(iww.getShell(), modelResource)).open() == 0) {
            EObject[] selectedViewsAndTables = dialog.getCheckedObjects();
            String viewXmlTag = dialog.getViewXmlTag();
            String columnXmlTag = dialog.getColumnXmlTag();
            String restMethod = dialog.getRestMethodValue();
            IContainer folder = dialog.getViewModelFolder();
            String modelName = dialog.getViewModelName();
            if (!modelName.toUpperCase().endsWith(".xmi".toUpperCase())) {
                modelName = String.valueOf(modelName) + ".xmi";
            }
            if (selectedViewsAndTables.length > 0) {
                this.generateRestProcedures(modelName, folder, selectedViewsAndTables, viewXmlTag, columnXmlTag, restMethod);
            }
        }
    }

    private Set<String> getAllSQLReservedWords() {
        IQueryService service = ModelerCore.getTeiidQueryService();
        return service.getReservedWords();
    }

    /*
     * WARNING - void declaration
     */
    private void generateRestProcedures(String modelName, IContainer folder, EObject[] viewsAndTables, String viewXmlTag, String columnXmlTag, String restMethod) {
        String[] columnNames = null;
        Set<String> reservedWords = this.getAllSQLReservedWords();
        ArrayList<RelationalViewProcedure> viewProcedures = new ArrayList<RelationalViewProcedure>();
        EObject[] eObjectArray = viewsAndTables;
        int n = viewsAndTables.length;
        int n2 = 0;
        while (n2 < n) {
            EObject eObj = eObjectArray[n2];
            Collection<Object> pkColumns = new ArrayList();
            if (eObj instanceof BaseTable) {
                columnNames = this.getColumnNames((Table)((BaseTable)eObj));
                pkColumns = this.getPKColumns((BaseTable)eObj);
            }
            String viewName = this.getName(eObj);
            String procName = String.valueOf(viewName) + RESTPROC_SUFFIX;
            if (columnNames.length > 0) {
                void var20_20;
                String colStr = GenerateRestVirtualProceduresAction.getColumnsString(columnNames, reservedWords);
                RelationalViewProcedure viewProcedure = new RelationalViewProcedure(procName);
                HashMap<String, String> paramToColumnMap = new HashMap<String, String>();
                if (!pkColumns.isEmpty()) {
                    for (Column column : pkColumns) {
                        String colName = this.getName((EObject)column);
                        String paramName = "pk_" + colName + "_in";
                        String dTypeName = this.getName(column.getType());
                        RelationalParameter param = new RelationalParameter(paramName);
                        param.setDatatype(dTypeName);
                        param.setDirection("IN");
                        paramToColumnMap.put(colName, paramName);
                        viewProcedure.addParameter(param);
                    }
                }
                String string = viewName;
                if (!paramToColumnMap.isEmpty()) {
                    int count = 0;
                    int mapSize = paramToColumnMap.values().size();
                    StringBuilder sb = new StringBuilder();
                    sb.append(viewName).append("/");
                    for (String paramName : paramToColumnMap.values()) {
                        sb.append("{").append(paramName).append("}");
                        if (++count >= mapSize) continue;
                        sb.append("/");
                    }
                    String string2 = sb.toString();
                }
                viewProcedure.setRestEnabled(true);
                viewProcedure.setRestUri((String)var20_20);
                String generatedSql = this.getRestProcedureDdl(procName, viewXmlTag, columnXmlTag, colStr, viewName, viewName, reservedWords, paramToColumnMap);
                viewProcedure.setTransformationSQL(generatedSql);
                viewProcedure.setRestMethod(restMethod);
                viewProcedures.add(viewProcedure);
            }
            ++n2;
        }
        if (!viewProcedures.isEmpty()) {
            this.createViewProceduresInTxn(modelName, folder, viewProcedures);
        }
    }

    private void createViewProceduresInTxn(String modelName, IContainer folder, Collection<RelationalViewProcedure> viewProcedures) {
        block18: {
            IPath modelPath = folder.getFullPath().append(String.valueOf(modelName) + ".xmi");
            ModelResource modelResource = null;
            if (modelPath.toFile().exists()) {
                ModelWorkspaceItem item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1);
                try {
                    IResource iRes = item.getCorrespondingResource();
                    modelResource = ModelUtilities.getModelResource((Object)iRes);
                }
                catch (ModelWorkspaceException e) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.createRelationalViewProcedureExceptionMessage, (String)e.getMessage());
                    Status status = new Status(4, "org.teiid.designer.webservice.ui", Messages.createRelationalViewProcedureExceptionMessage);
                    UTIL.log((IStatus)status);
                }
            } else {
                try {
                    RelationalViewModelFactory factory = new RelationalViewModelFactory();
                    modelResource = factory.createRelationalViewModel(folder, modelName);
                    modelResource.save((IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (ModelWorkspaceException e) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.createRelationalViewProcedureExceptionMessage, (String)e.getMessage());
                    Status status = new Status(4, "org.teiid.designer.webservice.ui", Messages.createRelationalViewProcedureExceptionMessage);
                    UTIL.log((IStatus)status);
                }
            }
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)Messages.createRelationalViewProcedureTitle, (Object)this);
            boolean succeeded = false;
            try {
                try {
                    ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)modelResource.getCorrespondingResource()), (boolean)true);
                    if (editor != null) {
                        boolean isDirty = editor.isDirty();
                        RelationalViewModelFactory factory = new RelationalViewModelFactory();
                        RelationalModel relModel = new RelationalModel("dummy");
                        for (RelationalViewProcedure viewProcedure : viewProcedures) {
                            relModel.addChild((RelationalReference)viewProcedure);
                        }
                        factory.build(modelResource, relModel, (IProgressMonitor)new NullProgressMonitor());
                        if (!isDirty && editor.isDirty()) {
                            editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                        succeeded = true;
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.createRelationalViewProcedureExceptionMessage, (String)e.getMessage());
                    Status status = new Status(4, "org.teiid.designer.webservice.ui", Messages.createRelationalViewProcedureExceptionMessage, (Throwable)e);
                    UTIL.log((IStatus)status);
                    if (!requiredStart) break block18;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block18;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private String[] getColumnNames(Table eObj) {
        ArrayList<String> names = new ArrayList<String>();
        for (Object col : eObj.getColumns()) {
            names.add(this.getName((EObject)col));
        }
        return names.toArray(new String[names.size()]);
    }

    private Collection<Column> getPKColumns(BaseTable table) {
        ArrayList<Column> pkColumns = new ArrayList<Column>();
        if (table.getPrimaryKey() != null) {
            PrimaryKey pk = table.getPrimaryKey();
            for (Object colRef : pk.getColumns()) {
                pkColumns.add((Column)colRef);
            }
        }
        return pkColumns;
    }

    private static String getColumnsString(String[] colList, Set<String> reservedWords) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = colList;
        int n = colList.length;
        int n2 = 0;
        while (n2 < n) {
            String colName = stringArray[n2];
            if (!sb.toString().isEmpty()) {
                sb.append(",");
            }
            sb.append(GenerateRestVirtualProceduresAction.escapeSQLName(colName, reservedWords));
            ++n2;
        }
        return sb.toString();
    }

    private String getName(EObject eObj) {
        return ModelerCore.getModelEditor().getName(eObj);
    }

    private String getRestProcedureDdl(String procName, String xmlTagGroup, String xmlTagIndiv, String colNamesString, String viewName, String resturi, Set<String> reservedWords, Map<String, String> paramToColumnMap) {
        String fullParamName;
        String paramName;
        int mapSize;
        int count;
        StringBuilder sb = new StringBuilder();
        sb.append("BEGIN \n");
        sb.append(" SELECT XMLELEMENT(NAME ");
        sb.append(xmlTagGroup);
        if (!paramToColumnMap.isEmpty()) {
            count = 0;
            mapSize = paramToColumnMap.values().size();
            sb.append(", XMLATTRIBUTES (");
            for (String col : paramToColumnMap.keySet()) {
                paramName = paramToColumnMap.get(col);
                fullParamName = String.valueOf(procName) + "." + paramName;
                sb.append(fullParamName).append(" as ").append(paramName);
                if (++count >= mapSize) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        sb.append(", XMLAGG(XMLELEMENT(NAME ");
        sb.append(xmlTagIndiv);
        sb.append(", XMLFOREST(");
        sb.append(colNamesString);
        sb.append(")))) AS xml_out \n");
        sb.append(" FROM ");
        sb.append(GenerateRestVirtualProceduresAction.escapeSQLName(viewName, reservedWords));
        if (!paramToColumnMap.isEmpty()) {
            count = 0;
            mapSize = paramToColumnMap.values().size();
            sb.append(" WHERE ");
            for (String col : paramToColumnMap.keySet()) {
                paramName = paramToColumnMap.get(col);
                fullParamName = String.valueOf(procName) + "." + paramName;
                sb.append(fullParamName).append(" = ").append(col);
                if (++count >= mapSize) continue;
                sb.append(" AND ");
            }
        }
        sb.append(";\n");
        sb.append(" END;");
        return sb.toString();
    }

    public static String escapeSQLName(String part, Set<String> reservedWords) {
        if (GenerateRestVirtualProceduresAction.isReservedWord(part, reservedWords)) {
            return String.valueOf('\"') + part + '\"';
        }
        boolean escape = true;
        char start = part.charAt(0);
        if (start == '#' || start == '@' || GenerateRestVirtualProceduresAction.isLetter(start)) {
            escape = false;
            int i = 1;
            while (!escape && i < part.length()) {
                char c = part.charAt(i);
                escape = !GenerateRestVirtualProceduresAction.isLetterOrDigit(c) && c != '_';
                ++i;
            }
        }
        if (escape) {
            return String.valueOf('\"') + part + '\"';
        }
        return part;
    }

    public static boolean isReservedWord(String string, Set<String> reservedWords) {
        return reservedWords.contains(string.toUpperCase());
    }

    public static boolean isLetter(char c) {
        return GenerateRestVirtualProceduresAction.isBasicLatinLetter(c) || Character.isLetter(c);
    }

    public static boolean isLetterOrDigit(char c) {
        return GenerateRestVirtualProceduresAction.isBasicLatinLetter(c) || GenerateRestVirtualProceduresAction.isBasicLatinDigit(c) || Character.isLetterOrDigit(c);
    }

    private static boolean isBasicLatinLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isBasicLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static boolean valuesAreEqual(String thisValue, String thatValue) {
        if (GenerateRestVirtualProceduresAction.isEmpty(thisValue) && GenerateRestVirtualProceduresAction.isEmpty(thatValue)) {
            return true;
        }
        return GenerateRestVirtualProceduresAction.equals(thisValue, thatValue);
    }

    public static boolean equals(String thisString, String thatString) {
        if (thisString == null) {
            return thatString == null;
        }
        return thisString.equals(thatString);
    }

    class SelectViewsAndTablesDialog
    extends ScrollableTitleAreaDialog {
        private final String TITLE;
        private final String INITIAL_MSG;
        private ModelResource modelResource;
        private CheckboxTableViewer tableViewer;
        private Text viewXmlTag;
        private Text columnXmlTag;
        private Button selectAllButton;
        private Button deselectAllButton;
        Collection<EObject> selectedTablesAndViews;
        EObject[] allTablesAndViews;
        EObject[] tablesAndViews;
        String viewXmlTagValue;
        String columnXmlTagValue;
        private Text viewModelContainerText;
        private IContainer viewModelFolder;
        String viewModelName;
        private Text viewModelFileText;
        private String restMethodValue;

        public SelectViewsAndTablesDialog(Shell shell, ModelResource resource) {
            super(shell);
            this.TITLE = UTIL.getString("SelectViewsAndTablesDialog.title", new Object[0]);
            this.INITIAL_MSG = UTIL.getString("SelectViewsAndTablesDialog.originalMessage", new Object[0]);
            this.selectedTablesAndViews = new ArrayList<EObject>();
            this.restMethodValue = "GET";
            this.modelResource = resource;
            this.allTablesAndViews = this.getTables(this.modelResource);
            if (ModelIdentifier.isRelationalViewModel((ModelResource)resource)) {
                this.viewModelFolder = resource.getResource().getParent();
                this.viewModelName = resource.getResource().getFullPath().removeFileExtension().lastSegment();
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle(this.TITLE);
            this.setMessage(this.INITIAL_MSG);
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayoutFactory.swtDefaults().margins(5, 5).applyTo(composite);
            composite.setLayoutData((Object)new GridData(1808));
            Group viewGroup = WidgetFactory.createGroup((Composite)composite, (String)GenerateRestVirtualProceduresAction.getString("viewModelDefinitionGroup"), (int)0, (int)2, (int)3);
            GridData gd_vg = new GridData(768);
            gd_vg.horizontalSpan = 2;
            viewGroup.setLayoutData((Object)gd_vg);
            Label locationLabel = new Label((Composite)viewGroup, 0);
            locationLabel.setText(GenerateRestVirtualProceduresAction.getString("location"));
            this.viewModelContainerText = new Text((Composite)viewGroup, 2052);
            if (this.viewModelFolder != null) {
                this.viewModelContainerText.setText(this.viewModelFolder.getName());
            }
            GridData gridData = new GridData(768);
            this.viewModelContainerText.setLayoutData((Object)gridData);
            this.viewModelContainerText.setBackground(Display.getCurrent().getSystemColor(19));
            this.viewModelContainerText.setEditable(false);
            Button browseButton = new Button((Composite)viewGroup, 8);
            gridData = new GridData();
            browseButton.setLayoutData((Object)gridData);
            browseButton.setText(GenerateRestVirtualProceduresAction.getString("browse"));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectViewsAndTablesDialog.this.handleViewModelLocationBrowse();
                }
            });
            Label fileLabel = new Label((Composite)viewGroup, 0);
            fileLabel.setText(GenerateRestVirtualProceduresAction.getString("name"));
            this.viewModelFileText = new Text((Composite)viewGroup, 2052);
            if (!StringUtilities.isEmpty((String)this.viewModelName)) {
                this.viewModelFileText.setText(this.viewModelName);
            }
            gridData = new GridData(768);
            this.viewModelFileText.setLayoutData((Object)gridData);
            this.viewModelFileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectViewsAndTablesDialog.this.handleViewModelTextChanged();
                }
            });
            browseButton = new Button((Composite)viewGroup, 8);
            gridData = new GridData();
            browseButton.setLayoutData((Object)gridData);
            browseButton.setText(GenerateRestVirtualProceduresAction.getString("browse"));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectViewsAndTablesDialog.this.handleViewModelBrowse();
                }
            });
            Group optionsGroup = WidgetFactory.createGroup((Composite)composite, (String)"Options");
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)optionsGroup);
            optionsGroup.setLayoutData((Object)new GridData(768));
            Label restMethodLabel = new Label((Composite)optionsGroup, 0);
            restMethodLabel.setText(GenerateRestVirtualProceduresAction.getString("restMethodLabel"));
            Label restMethodValueLabel = new Label((Composite)optionsGroup, 0);
            restMethodValueLabel.setText("GET");
            Label label1 = new Label((Composite)optionsGroup, 0);
            label1.setText(VIEW_XML_TAG_LABEL);
            this.viewXmlTag = new Text((Composite)optionsGroup, 2048);
            this.viewXmlTagValue = GenerateRestVirtualProceduresAction.DEFAULT_REST_XML_GROUPTAG;
            this.viewXmlTag.setText(this.viewXmlTagValue);
            this.viewXmlTag.setEditable(true);
            this.viewXmlTag.setLayoutData((Object)new GridData(768));
            this.viewXmlTag.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    SelectViewsAndTablesDialog.this.viewXmlTagValue = SelectViewsAndTablesDialog.this.viewXmlTag.getText();
                    if (SelectViewsAndTablesDialog.this.viewXmlTagValue == null) {
                        SelectViewsAndTablesDialog.this.viewXmlTagValue = "";
                    }
                    SelectViewsAndTablesDialog.this.validate();
                }
            });
            Label label2 = new Label((Composite)optionsGroup, 0);
            label2.setText(COLUMN_XML_TAG_LABEL);
            this.columnXmlTag = new Text((Composite)optionsGroup, 2048);
            this.columnXmlTagValue = GenerateRestVirtualProceduresAction.DEFAULT_REST_XML_ELEMENTTAG;
            this.columnXmlTag.setText(this.columnXmlTagValue);
            this.columnXmlTag.setEditable(true);
            this.columnXmlTag.setLayoutData((Object)new GridData(768));
            this.columnXmlTag.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    SelectViewsAndTablesDialog.this.columnXmlTagValue = SelectViewsAndTablesDialog.this.columnXmlTag.getText();
                    if (SelectViewsAndTablesDialog.this.columnXmlTagValue == null) {
                        SelectViewsAndTablesDialog.this.columnXmlTagValue = "";
                    }
                    SelectViewsAndTablesDialog.this.validate();
                }
            });
            Group sourceGroup = WidgetFactory.createGroup((Composite)composite, (String)GenerateRestVirtualProceduresAction.getString("selectTablesGroupLabel"), (int)0, (int)2, (int)1);
            gd_vg = new GridData(768);
            gd_vg.horizontalSpan = 2;
            sourceGroup.setLayoutData((Object)gd_vg);
            Composite buttonPanel = WidgetFactory.createPanel((Composite)sourceGroup, (int)0, (int)1, (int)1);
            GridLayoutFactory.fillDefaults().numColumns(5).margins(1, 1).applyTo(buttonPanel);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
            Label iconLabel = new Label(buttonPanel, 0);
            if (ModelIdentifier.isRelationalSourceModel((ModelResource)this.modelResource)) {
                iconLabel.setImage(WebServiceUiPlugin.getDefault().getImage("icons/full/obj16/relational-model.gif"));
            } else {
                iconLabel.setImage(WebServiceUiPlugin.getDefault().getImage("icons/full/obj16/view-model.gif"));
            }
            Label modelNameLabel = new Label(buttonPanel, 0);
            modelNameLabel.setText(this.modelResource.getItemName());
            GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)modelNameLabel);
            modelNameLabel.setForeground(Display.getCurrent().getSystemColor(10));
            this.selectAllButton = new Button(buttonPanel, 8);
            this.selectAllButton.setText(GenerateRestVirtualProceduresAction.getString("selectAllLabel"));
            GridDataFactory.fillDefaults().applyTo((Control)this.selectAllButton);
            this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectViewsAndTablesDialog.this.tableViewer.setAllChecked(true);
                    SelectViewsAndTablesDialog.this.selectAllButton.setEnabled(false);
                    SelectViewsAndTablesDialog.this.deselectAllButton.setEnabled(true);
                    SelectViewsAndTablesDialog.this.getButton(0).setEnabled(true);
                    SelectViewsAndTablesDialog.this.setErrorMessage(null);
                    SelectViewsAndTablesDialog.this.setMessage(GenerateRestVirtualProceduresAction.getString("msg.clickOkToGenerateProcedures"));
                    SelectViewsAndTablesDialog.this.updateCheckedObjects();
                }
            });
            this.deselectAllButton = new Button(buttonPanel, 8);
            this.deselectAllButton.setText(GenerateRestVirtualProceduresAction.getString("deselectAllLabel"));
            GridDataFactory.fillDefaults().applyTo((Control)this.deselectAllButton);
            this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectViewsAndTablesDialog.this.tableViewer.setAllChecked(false);
                    SelectViewsAndTablesDialog.this.deselectAllButton.setEnabled(false);
                    SelectViewsAndTablesDialog.this.selectAllButton.setEnabled(true);
                    SelectViewsAndTablesDialog.this.getButton(0).setEnabled(false);
                    SelectViewsAndTablesDialog.this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("msg.nothingSelected"));
                    SelectViewsAndTablesDialog.this.updateCheckedObjects();
                }
            });
            this.deselectAllButton.setEnabled(false);
            this.tableViewer = CheckboxTableViewer.newCheckList((Composite)sourceGroup, (int)2816);
            GridData gd = new GridData(1808);
            gd.heightHint = 100;
            this.tableViewer.getTable().setLayoutData((Object)gd);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public String getText(Object element) {
                    if (element instanceof EObject) {
                        return ModelerCore.getModelEditor().getName((EObject)element);
                    }
                    return "";
                }

                public Image getImage(Object element) {
                    if (ModelIdentifier.isRelationalSourceModel((ModelResource)SelectViewsAndTablesDialog.this.modelResource)) {
                        return WebServiceUiPlugin.getDefault().getImage("icons/full/obj16/relational-table.png");
                    }
                    return WebServiceUiPlugin.getDefault().getImage("icons/full/obj16/virtual-relational-table.png");
                }
            });
            this.tableViewer.add((Object[])this.allTablesAndViews);
            this.tableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    SelectViewsAndTablesDialog.this.updateCheckedObjects();
                    SelectViewsAndTablesDialog.this.validate();
                }
            });
            this.sizeScrolledPanel();
            return composite;
        }

        private void updateCheckedObjects() {
            ArrayList<EObject> results = new ArrayList<EObject>();
            Object[] objectArray = this.tableViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof EObject) {
                    results.add((EObject)obj);
                }
                ++n2;
            }
            this.tablesAndViews = results.toArray(new EObject[results.size()]);
        }

        void handleViewModelLocationBrowse() {
            IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
            if (folder != null) {
                this.viewModelContainerText.setText(folder.toString());
                this.viewModelFolder = folder;
            } else {
                this.viewModelContainerText.setText("");
            }
            this.validate();
        }

        void handleViewModelBrowse() {
            Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)GenerateRestVirtualProceduresAction.getString("selectViewModelTitle"), (String)GenerateRestVirtualProceduresAction.getString("selectViewModelMessage"), (boolean)false, null, (ViewerFilter)GenerateRestVirtualProceduresAction.this.virtualModelFilter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
            if (selections != null && selections.length == 1 && this.viewModelFileText != null && selections[0] instanceof IFile) {
                String modelName;
                IFile modelFile = (IFile)selections[0];
                this.viewModelFolder = modelFile.getParent();
                this.viewModelName = modelName = modelFile.getFullPath().removeFileExtension().lastSegment();
                this.viewModelFileText.setText(modelName);
                this.viewModelContainerText.setText(this.viewModelFolder.toString());
            }
            this.validate();
        }

        void handleViewModelTextChanged() {
            this.viewModelName = this.viewModelFileText.getText();
            this.validate();
        }

        private void validate() {
            int checkedItems;
            int maxItems = this.allTablesAndViews.length;
            int n = checkedItems = this.tablesAndViews == null ? 0 : this.tablesAndViews.length;
            if (this.viewModelFolder == null) {
                this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("viewFileLocationMustBeSpecified"));
                this.getButton(0).setEnabled(false);
                return;
            }
            if (StringUtilities.isEmpty((String)this.viewModelName)) {
                this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("viewFileNameMustBeSpecified"));
                this.getButton(0).setEnabled(false);
                return;
            }
            if (this.viewModelName.contains(" ")) {
                this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("viewModelNameCannotContainSpaces"));
                this.getButton(0).setEnabled(false);
                return;
            }
            this.deselectAllButton.setEnabled(checkedItems > 0);
            this.selectAllButton.setEnabled(checkedItems < maxItems);
            if (checkedItems == 0) {
                this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("msg.noViewsSelected"));
                this.getButton(0).setEnabled(false);
                return;
            }
            if (StringUtilities.isEmpty((String)this.viewXmlTagValue)) {
                this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("msg.viewXmlTagCannotBeEmpty"));
                this.getButton(0).setEnabled(false);
                return;
            }
            char firstChar = this.viewXmlTagValue.charAt(0);
            if (!Character.isLetter(firstChar)) {
                this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("msg.viewXmlTagConnotStartWithANumber"));
                this.getButton(0).setEnabled(false);
                return;
            }
            if (this.viewXmlTagValue.contains(" ")) {
                this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("msg.viewXmlTagConnotContainSpaces"));
                this.getButton(0).setEnabled(false);
                return;
            }
            if (StringUtilities.isEmpty((String)this.columnXmlTagValue)) {
                this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("msg.columnXmlTagCannotBeEmpty"));
                this.getButton(0).setEnabled(false);
                return;
            }
            firstChar = this.columnXmlTagValue.charAt(0);
            if (!Character.isLetter(firstChar)) {
                this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("msg.columnXmlTagConnotStartWithANumber"));
                this.getButton(0).setEnabled(false);
                return;
            }
            if (this.columnXmlTagValue.contains(" ")) {
                this.setErrorMessage(GenerateRestVirtualProceduresAction.getString("msg.columnXmlTagConnotContainSpaces"));
                this.getButton(0).setEnabled(false);
                return;
            }
            this.setErrorMessage(null);
            this.setMessage(GenerateRestVirtualProceduresAction.getString("msg.clickOkToGenerateProcedures"));
            this.getButton(0).setEnabled(true);
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
            super.getShell().setText(this.TITLE);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.getButton(0).setEnabled(false);
        }

        public EObject[] getCheckedObjects() {
            return this.tablesAndViews;
        }

        private EObject[] getTables(ModelResource mr) {
            TableFinder visitor = new TableFinder();
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor, 1);
            try {
                processor.walk(mr, 2);
            }
            catch (ModelerCoreException e) {
                e.printStackTrace();
            }
            return visitor.getTablesViews();
        }

        public String getViewXmlTag() {
            return this.viewXmlTagValue;
        }

        public String getColumnXmlTag() {
            return this.columnXmlTagValue;
        }

        public String getRestMethodValue() {
            return this.restMethodValue;
        }

        public IContainer getViewModelFolder() {
            return this.viewModelFolder;
        }

        public String getViewModelName() {
            return this.viewModelName;
        }
    }

    class TableFinder
    implements ModelVisitor {
        Collection<EObject> tables = new ArrayList<EObject>();
        boolean hasTableOrProcedure = false;

        TableFinder() {
        }

        public boolean visit(EObject object) throws ModelerCoreException {
            if (object instanceof Table) {
                this.tables.add(object);
                return false;
            }
            if (object instanceof Catalog) {
                return true;
            }
            return object instanceof Schema;
        }

        public boolean visit(Resource resource) throws ModelerCoreException {
            return true;
        }

        public boolean hasTable() {
            return !this.tables.isEmpty();
        }

        public EObject[] getTablesViews() {
            return this.tables.toArray(new EObject[this.tables.size()]);
        }
    }
}

