/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.function.aspects.validation.rules;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.CoreValidationRulesUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.function.FunctionPlugin;
import org.teiid.designer.metamodels.function.PushDownType;
import org.teiid.designer.metamodels.function.ReturnParameter;
import org.teiid.designer.metamodels.function.ScalarFunction;
import org.teiid.designer.metamodels.function.extension.FunctionModelExtensionConstants;

public class ScalarFunctionRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(ScalarFunction.class, (Object)eObject);
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        ScalarFunction sFunction = (ScalarFunction)eObject;
        this.validateName(sFunction, (ValidationResult)result);
        this.validateReturnParameter(sFunction.getReturnParameter(), (ValidationResult)result);
        String invocationClass = sFunction.getInvocationClass();
        if (CoreStringUtil.isEmpty((String)invocationClass) && !((Object)((Object)sFunction.getPushDown())).equals((Object)PushDownType.REQUIRED_LITERAL)) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, FunctionPlugin.Util.getString("ScalarFunctionRule.Invocation_class_must_be_specified_on_a_scalar_function._1", new Object[0]));
            result.addProblem((ValidationProblem)problem);
        } else {
            this.validateJavaIdentifier(invocationClass, FunctionPlugin.Util.getString("ScalarFunctionRule.Invocation_class_3", new Object[0]), true, (ValidationResult)result);
        }
        String invocationMethod = sFunction.getInvocationMethod();
        if (CoreStringUtil.isEmpty((String)invocationMethod) && !((Object)((Object)sFunction.getPushDown())).equals((Object)PushDownType.REQUIRED_LITERAL)) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, FunctionPlugin.Util.getString("ScalarFunctionRule.Invocation_method_must_be_specified_on_a_scalar_function._2", new Object[0]));
            result.addProblem((ValidationProblem)problem);
        } else {
            this.validateJavaIdentifier(invocationMethod, FunctionPlugin.Util.getString("ScalarFunctionRule.Invocation_Method_4", new Object[0]), false, (ValidationResult)result);
        }
        this.validateUdfJarPath(sFunction, (ValidationResult)result);
        String category = sFunction.getCategory();
        if (CoreStringUtil.isEmpty((String)category)) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, FunctionPlugin.Util.getString("ScalarFunctionRule.Category_can_not_be_null_or_empty", new Object[0]));
            result.addProblem((ValidationProblem)problem);
        } else {
            this.validateLength(category, FunctionPlugin.Util.getString("ScalarFunctionRule.Category_5", new Object[0]), (ValidationResult)result);
        }
        try {
            Annotation annotation = ModelerCore.getModelEditor().getAnnotation((EObject)sFunction, false);
            if (annotation != null) {
                this.validateLength(annotation.getDescription(), FunctionPlugin.Util.getString("ScalarFunctionRule.Description_1", new Object[0]), (ValidationResult)result);
            }
        }
        catch (ModelerCoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, FunctionPlugin.Util.getString("ScalarFunctionRule.Error_trying_to_lookup_model_annotation_for_the_function_{0}._2", (Object)sFunction.getName()));
        }
        context.addResult((ValidationResult)result);
    }

    private void validateName(ScalarFunction sFunction, ValidationResult result) {
        String name = sFunction.getName();
        char[] validChars = null;
        CoreValidationRulesUtil.validateStringNameChars((ValidationResult)result, (String)name, validChars);
    }

    private final void validateReturnParameter(ReturnParameter rParam, ValidationResult result) {
        if (rParam != null) {
            String paramType = rParam.getType();
            if (CoreStringUtil.isEmpty((String)paramType)) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, FunctionPlugin.Util.getString("ScalarFunctionRule.Type_should_be_specified_on_the_return_parameter_of_a_scalar_function._7", new Object[0]));
                result.addProblem((ValidationProblem)problem);
            }
            this.validateJavaIdentifier(paramType, FunctionPlugin.Util.getString("ScalarFunctionRule.Return_Parameter_8", new Object[0]), true, result);
        }
    }

    private final void validateJavaIdentifier(String identifier, String strName, boolean allowMultiple, ValidationResult result) {
        if (!CoreStringUtil.isEmpty((String)identifier)) {
            char firstChar = identifier.charAt(0);
            if (!Character.isJavaIdentifierStart(firstChar)) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(strName) + FunctionPlugin.Util.getString("ScalarFunctionRule._has_invalid_first_character___10", new Object[0]) + firstChar);
                result.addProblem((ValidationProblem)problem);
            }
            int i = 1;
            while (i < identifier.length()) {
                char ch = identifier.charAt(i);
                if (!(Character.isJavaIdentifierPart(ch) || allowMultiple && ch == '.')) {
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(strName) + FunctionPlugin.Util.getString("ScalarFunctionRule._has_invalid_character___11", new Object[0]) + firstChar);
                    result.addProblem((ValidationProblem)problem);
                }
                ++i;
            }
            if (identifier.charAt(identifier.length() - 1) == '.') {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(strName) + FunctionPlugin.Util.getString("ScalarFunctionRule._cannot_end_with_a___.___13", new Object[0]));
                result.addProblem((ValidationProblem)problem);
            }
        }
    }

    private final void validateLength(String string, String strName, ValidationResult result) {
        if (string != null && string.length() > 128) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(strName) + FunctionPlugin.Util.getString("ScalarFunctionRule._exceeds_maximum_length_of___9", new Object[0]) + 128);
            result.addProblem((ValidationProblem)problem);
        }
    }

    private final void validateUdfJarPath(ScalarFunction scalarFunc, ValidationResult result) {
        String udfJarPath = ScalarFunctionRule.getUdfJarPath(scalarFunc);
        if (udfJarPath != null) {
            if (CoreStringUtil.isEmpty((String)udfJarPath.trim())) {
                String message = FunctionPlugin.Util.getString("ScalarFunctionRule.udfJarPathNotSet", new Object[0]);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, message);
                result.addProblem((ValidationProblem)problem);
            } else {
                ModelResource resrc = ModelerCore.getModelWorkspace().findModelResource((EObject)scalarFunc);
                IProject project = resrc.getModelProject().getProject();
                IContainer libFolder = VdbHelper.getFolder((IProject)project, (String)VdbHelper.VdbFolders.UDF.getReadFolder());
                boolean found = VdbHelper.isFileInFolder((IContainer)libFolder, (String)udfJarPath);
                if (!found) {
                    String message = FunctionPlugin.Util.getString("ScalarFunctionRule.udfJarNotFound", (Object)udfJarPath);
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, message);
                    result.addProblem((ValidationProblem)problem);
                }
            }
        }
    }

    private static String getUdfJarPath(ScalarFunction scalarFunc) {
        String udfJarPath = null;
        ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(FunctionModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
        if (assistant != null) {
            try {
                udfJarPath = assistant.getPropertyValue((Object)scalarFunc, FunctionModelExtensionConstants.PropertyIds.UDF_JAR_PATH);
            }
            catch (Exception ex) {
                ModelerCore.Util.log(4, (Throwable)ex, FunctionPlugin.Util.getString("FunctionUtil.ErrorGettingJarPath", (Object)scalarFunc.getName()));
            }
        }
        return udfJarPath;
    }
}

