/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.xml;

import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.om.Item;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import org.teiid.core.designer.util.CoreArgCheck;

public class XPathHelper {
    public static String getSingleMatchAsString(Reader documentReader, String xpath) throws XPathException, IOException {
        Object o = XPathHelper.getSingleMatch(documentReader, xpath);
        if (o == null) {
            return null;
        }
        if (o instanceof Item) {
            return ((Item)o).getStringValue();
        }
        return o.toString();
    }

    public static Object getSingleMatch(Reader documentReader, String xpath) throws XPathException, IOException {
        CoreArgCheck.isNotNull(documentReader);
        CoreArgCheck.isNotNull(xpath);
        try {
            StreamSource s = new StreamSource(documentReader);
            XPathEvaluator eval = new XPathEvaluator();
            XPathExpression expr = eval.createExpression(xpath);
            Object object = expr.evaluateSingle((Source)s);
            return object;
        }
        finally {
            documentReader.close();
        }
    }

    public static void validateXpath(String xpath) throws XPathException {
        if (xpath == null) {
            return;
        }
        XPathEvaluator eval = new XPathEvaluator();
        eval.createExpression(xpath);
    }
}

