/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.wizard;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.wizard.NewClassWizard;
import org.jbpm.gd.jpdl.wizard.NewTypeWizardAdapter;

public class NewActionWizard
extends NewClassWizard
implements INewWizard {
    static String ACTION_HANDLER_CLASS = "org.jbpm.graph.def.ActionHandler";
    boolean openCreatedType = false;

    public NewActionWizard() {
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle("New jBPM Action");
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
    }

    public void addPages() {
        super.addPages();
        this.mainPage.setTitle("jBPM Action");
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.mainPage.createType(monitor);
        if (this.mainPage.getCreatedType() != null) {
            this.modifyJavaSource();
        }
    }

    public boolean performFinish() {
        boolean b = super.performFinish();
        if (b && this.openCreatedType) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        JavaUI.openInEditor((IJavaElement)NewActionWizard.this.mainPage.getCreatedType());
                    }
                    catch (CoreException e) {
                        Logger.logError(e);
                    }
                }
            });
        }
        return b;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IProject p = this.getProject(selection);
        this.adapter = new NewTypeWizardAdapter(p);
        this.adapter.addRawInterfaceName(ACTION_HANDLER_CLASS);
        IPackageFragment f = this.getPackageFragment(selection);
        if (f != null) {
            String name = "";
            IPackageFragment cf = f;
            while (cf != null) {
                name = name.length() == 0 ? cf.getElementName() : String.valueOf(cf.getElementName()) + "." + name;
                IPackageFragment iPackageFragment = cf = cf.getParent() instanceof IPackageFragment ? (IPackageFragment)cf.getParent() : null;
            }
            this.adapter.setRawPackageName(name);
        }
        this.adapter.setRawClassName("");
        this.openCreatedType = true;
    }

    IProject getProject(IStructuredSelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IProject) {
            return (IProject)o;
        }
        if (o instanceof IJavaElement) {
            IJavaElement e = (IJavaElement)o;
            return e.getJavaProject().getProject();
        }
        if (o instanceof IAdaptable) {
            IResource r = (IResource)((IAdaptable)o).getAdapter(IResource.class);
            return r != null ? r.getProject() : null;
        }
        return null;
    }

    IPackageFragment getPackageFragment(IStructuredSelection selection) {
        IFolder f;
        IJavaElement jp;
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IPackageFragment) {
            return (IPackageFragment)o;
        }
        if (o instanceof IFolder && (jp = JavaCore.create((IFolder)(f = (IFolder)o))) instanceof IPackageFragment) {
            return (IPackageFragment)jp;
        }
        return null;
    }

    void modifyJavaSource() {
        try {
            IType type = this.mainPage.getCreatedType();
            if (type == null) {
                return;
            }
            type.getElementName();
            type.getSuperclassTypeSignature();
            ICompilationUnit w = type.getCompilationUnit().getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IBuffer b = w.getBuffer();
            String s = b.getContents();
            String lineDelimiter = "\r\n";
            String IMPORT = "import " + ACTION_HANDLER_CLASS + ";";
            int i1 = s.indexOf(IMPORT);
            if (i1 >= 0) {
                if (i1 >= 0) {
                    String[] imports;
                    String content = "";
                    String[] stringArray = imports = new String[]{"import org.jbpm.graph.exe.ExecutionContext;"};
                    int n = imports.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String is = stringArray[n2];
                        if (s.indexOf(is) < 0) {
                            content = String.valueOf(content) + lineDelimiter + is;
                        }
                        ++n2;
                    }
                    if (content.length() > 0) {
                        b.replace(i1 + IMPORT.length(), 0, content);
                    }
                }
                s = b.getContents();
                int i = s.indexOf(123);
                int j = s.lastIndexOf(125);
                if (i > 0 && j > i) {
                    String tab = "\t";
                    String content = String.valueOf(lineDelimiter) + lineDelimiter + tab + "private static final long serialVersionUID = 1L;" + lineDelimiter + lineDelimiter + tab + "/**" + lineDelimiter + tab + "* The message member gets its value from the configuration in the" + lineDelimiter + tab + "* processdefinition. The value is injected directly by the engine." + lineDelimiter + tab + "*/" + lineDelimiter + tab + "String message;" + lineDelimiter + lineDelimiter + tab + "/**" + lineDelimiter + tab + "* A message process variable is assigned the value of the message" + lineDelimiter + tab + "* member. The process variable is created if it doesn't exist yet." + lineDelimiter + tab + "*/" + lineDelimiter + tab + "public void execute(ExecutionContext context) throws Exception {" + lineDelimiter + tab + tab + "//ADD CUSTOM ACTION CODE HERE" + lineDelimiter + tab + tab + "//context.getContextInstance().setVariable(\"message\", message);" + lineDelimiter + tab + "}" + lineDelimiter + lineDelimiter;
                    b.replace(i + 1, j - i - 1, content);
                    w.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (CoreException e) {
            Logger.logError(e);
        }
    }
}

