/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.net.URL;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.command.TimerCreateCommand;
import org.jbpm.gd.jpdl.command.TimerDeleteCommand;
import org.jbpm.gd.jpdl.model.TimerContainer;
import org.jbpm.gd.jpdl.properties.TimerContainerSection;

public class TimerContainerSectionActionBarContributor {
    private TimerContainerSection timersSection;
    private ActionContributionItem addTimerToolbarContributionItem;
    private ActionContributionItem removeToolbarContributionItem;
    private ActionContributionItem addTimerMenuContributionItem;
    private ActionContributionItem removeMenuContributionItem;
    private Separator toolbarSeparator;
    private Separator menuSeparator;
    private Menu root;

    public TimerContainerSectionActionBarContributor(TimerContainerSection timersSection) {
        this.setTimersSection(timersSection);
        this.createAddTimerContributions();
        this.createSeparatorContributions();
        this.createRemoveContributions();
    }

    private void createSeparatorContributions() {
        this.toolbarSeparator = new Separator();
        this.menuSeparator = new Separator();
    }

    private void setTimersSection(TimerContainerSection timersSection) {
        this.timersSection = timersSection;
    }

    public void activateContributions() {
        this.addAddTimerAction();
        this.addSeparators();
        this.addRemoveAction();
        this.getActionBars().updateActionBars();
    }

    private void addSeparators() {
        this.getActionBars().getToolBarManager().add((IContributionItem)this.toolbarSeparator);
        this.getActionBars().getMenuManager().add((IContributionItem)this.menuSeparator);
    }

    public void deactivateContributions() {
        this.removeAddTimerAction();
        this.removeSeparators();
        this.removeRemoveAction();
        this.getActionBars().updateActionBars();
    }

    private void removeSeparators() {
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.toolbarSeparator);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.menuSeparator);
    }

    public void setRemoveEnabled(boolean enabled) {
        this.removeMenuContributionItem.getAction().setEnabled(enabled);
        this.removeToolbarContributionItem.getAction().setEnabled(enabled);
    }

    private void addAddTimerAction() {
        this.getActionBars().getToolBarManager().add((IContributionItem)this.addTimerToolbarContributionItem);
        this.getActionBars().getMenuManager().add((IContributionItem)this.addTimerMenuContributionItem);
    }

    private void createAddTimerContributions() {
        this.addTimerToolbarContributionItem = new ActionContributionItem(this.createAddTimerAction());
        this.addTimerMenuContributionItem = new ActionContributionItem(this.createAddTimerAction());
    }

    private IAction createAddTimerAction() {
        Action action = new Action(){

            public void run() {
                TimerContainerSectionActionBarContributor.this.addNewTimer();
            }
        };
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_timer_enabled.gif")));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_timer_disabled.gif")));
        action.setToolTipText("Add a timer");
        action.setText("New Timer");
        return action;
    }

    private void addRemoveAction() {
        this.getActionBars().getToolBarManager().add((IContributionItem)this.removeToolbarContributionItem);
        this.getActionBars().getMenuManager().add((IContributionItem)this.removeMenuContributionItem);
    }

    private void createRemoveContributions() {
        this.removeToolbarContributionItem = new ActionContributionItem(this.createRemoveAction());
        this.removeMenuContributionItem = new ActionContributionItem(this.createRemoveAction());
    }

    private IAction createRemoveAction() {
        Action action = new Action(){

            public void run() {
                TimerContainerSectionActionBarContributor.this.removeSelectedObject();
            }
        };
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/delete_enabled.gif")));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/delete_disabled.gif")));
        action.setToolTipText("Remove the selection");
        action.setText("Delete");
        action.setEnabled(false);
        return action;
    }

    private void addNewTimer() {
        TimerContainer target = this.timersSection.getTimerContainer();
        TimerCreateCommand command = new TimerCreateCommand(target.getFactory());
        command.setTimerContainer(target);
        this.getCommandStack().execute((Command)command);
    }

    private void removeSelectedObject() {
        TimerDeleteCommand command = new TimerDeleteCommand();
        command.setTimerContainer(this.timersSection.getTimerContainer());
        command.setTimer(this.timersSection.getSelectedTimer());
        this.getCommandStack().execute((Command)command);
    }

    private CommandStack getCommandStack() {
        return this.timersSection.getCommandStack();
    }

    private void removeAddTimerAction() {
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.addTimerToolbarContributionItem);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.addTimerMenuContributionItem);
    }

    private void removeRemoveAction() {
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.removeToolbarContributionItem);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.removeMenuContributionItem);
    }

    private IActionBars getActionBars() {
        return this.timersSection.getTabbedPropertySheetPage().getSite().getActionBars();
    }

    public void createPopupMenu(Composite composite) {
        this.root = new Menu((Control)composite);
        composite.setMenu(this.root);
        this.root.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                TimerContainerSectionActionBarContributor.this.disposePopupMenu();
                TimerContainerSectionActionBarContributor.this.createPopupMenu();
            }
        });
    }

    private void disposePopupMenu() {
        MenuItem[] menuItems = this.root.getItems();
        int i = 0;
        while (i < menuItems.length) {
            menuItems[i].dispose();
            ++i;
        }
    }

    private void createPopupMenu() {
        this.createAddTimerMenuItem();
        new MenuItem(this.root, 2);
        this.createRemoveMenuItem();
    }

    private String getDeleteImagePath() {
        String imagePath = this.timersSection.getSelectedTimer() != null ? "/icons/full/obj16/delete_enabled.gif" : "/icons/full/obj16/delete_disabled.gif";
        return imagePath;
    }

    private void createAddTimerMenuItem() {
        MenuItem addTimerItem = new MenuItem(this.root, 8);
        addTimerItem.setText("New Timer");
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_timer_enabled.gif"));
        addTimerItem.setImage(SharedImages.INSTANCE.getImage(descriptor));
        addTimerItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimerContainerSectionActionBarContributor.this.addNewTimer();
            }
        });
    }

    private void createRemoveMenuItem() {
        MenuItem removeItem = new MenuItem(this.root, 8);
        removeItem.setText("Delete");
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry(this.getDeleteImagePath()));
        removeItem.setImage(SharedImages.INSTANCE.getImage(descriptor));
        removeItem.setEnabled(this.timersSection.getSelectedTimer() != null);
        removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimerContainerSectionActionBarContributor.this.removeSelectedObject();
            }
        });
    }
}

