/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.function.ScalarFunction;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.roles.Crud;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.roles.ui.Messages;
import org.teiid.designer.roles.ui.RolesUiPlugin;
import org.teiid.designer.roles.ui.wizard.PermissionHandler;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DataRolesModelTreeProvider
implements ITreeContentProvider,
ITableLabelProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private ITreeContentProvider modelProvider = ModelUtilities.getModelContentProvider();
    private static final char DELIM = '.';
    private static final char B_SLASH = '/';
    private static final Image CHECKED_BOX = RolesUiPlugin.getInstance().getAnImage("icons/full/cview16/checked_box.png");
    private static final Image UNCHECKED_BOX = RolesUiPlugin.getInstance().getAnImage("icons/full/cview16/unchecked_box.png");
    private static final Image GRAY_CHECKED_BOX = RolesUiPlugin.getInstance().getAnImage("icons/full/cview16/gray_checked_box.png");
    private static final Image GRAY_UNCHECKED_BOX = RolesUiPlugin.getInstance().getAnImage("icons/full/cview16/gray_unchecked_box.png");
    private static final Image GRAY_STATUS_BOX = RolesUiPlugin.getInstance().getAnImage("icons/full/cview16/grey-ball-16x16.png");
    private static final Image WHITE_STATUS_BOX = RolesUiPlugin.getInstance().getAnImage("icons/full/cview16/empty-ball-16x16.png");
    private static final Image BLUE_STATUS_BOX = RolesUiPlugin.getInstance().getAnImage("icons/full/cview16/blue-ball-16x16.png");
    private static final int CHECKED = 0;
    private static final int UNCHECKED = 1;
    private static final int GRAY_CHECKED = 2;
    private static final int GRAY_UNCHECKED = 3;
    private PermissionHandler handler = new PermissionHandler(this);
    private Resource[] resources;

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    private Image getCheckBoxImage(Object element, int columnIndex, Boolean value, boolean isParentValue, boolean hasDifferentChildValue) {
        int imageType = 0;
        if (isParentValue) {
            if (value == Boolean.FALSE) {
                imageType = 3;
            }
            if (hasDifferentChildValue) {
                imageType = 2;
            }
        }
        if (value == Boolean.FALSE) {
            imageType = 1;
        }
        if (hasDifferentChildValue) {
            imageType = 2;
        }
        switch (imageType) {
            case 0: {
                return CHECKED_BOX;
            }
            case 1: {
                return UNCHECKED_BOX;
            }
            case 2: {
                return GRAY_CHECKED_BOX;
            }
            case 3: {
                return GRAY_UNCHECKED_BOX;
            }
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = NO_CHILDREN;
        if (parentElement instanceof EObject) {
            children = this.getFilteredModelContents(this.modelProvider.getChildren(parentElement));
        } else if (parentElement instanceof Resource) {
            children = this.getFilteredModelContents((List<EObject>)((Resource)parentElement).getContents());
        }
        return children;
    }

    public boolean hasChildren(Object parentElement) {
        return this.getChildren(parentElement).length > 0;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        if (columnIndex == 1) {
            return this.getSecurityStatusImage(element);
        }
        Crud.Type crudType = Crud.getCrudType((int)columnIndex);
        boolean supportsUpdate = this.handler.supportsUpdates(element, crudType);
        if (!supportsUpdate) {
            return GRAY_UNCHECKED_BOX;
        }
        Permission perm = this.handler.getPermission(element);
        boolean isParent = false;
        if (perm == null || perm.getCRUDValue(crudType) == null) {
            perm = this.handler.getExistingPermission(element, crudType);
            isParent = true;
        }
        if (perm != null) {
            Boolean booleanValue = perm.getCRUDValue(crudType);
            isParent = perm.isPrimary();
            boolean hasDifferentChildValue = false;
            if (isParent || this.hasChildren(element)) {
                hasDifferentChildValue = this.handler.hasChildWithDifferentCrudValue(perm, element, crudType);
            }
            return this.getCheckBoxImage(element, columnIndex, booleanValue, isParent, hasDifferentChildValue);
        }
        return GRAY_UNCHECKED_BOX;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.resources == null) {
            EList allVdbResources = ((ContainerImpl)inputElement).getResources();
            ArrayList<Resource> filteredResources = new ArrayList<Resource>();
            for (Resource res : allVdbResources) {
                if (res.getURI().toFileString().toUpperCase().endsWith(".XSD")) continue;
                filteredResources.add(res);
            }
            this.resources = filteredResources.toArray(new Resource[0]);
        }
        this.reInitializePermissions();
        return this.resources;
    }

    private Object[] getFilteredModelContents(List<EObject> eObjs) {
        ArrayList<EObject> relObjects = new ArrayList<EObject>();
        for (EObject eObj : eObjs) {
            if (!(eObj instanceof Table) && !(eObj instanceof View) && !(eObj instanceof Procedure) && !(eObj instanceof ProcedureResult) && !(eObj instanceof Schema) && !(eObj instanceof Catalog) && !(eObj instanceof Column) && !(eObj instanceof ProcedureParameter) && !(eObj instanceof Interface) && !(eObj instanceof Operation) && !(eObj instanceof XmlDocument) && !(eObj instanceof ScalarFunction)) continue;
            relObjects.add(eObj);
        }
        return relObjects.toArray();
    }

    private Object[] getFilteredModelContents(Object[] eObjs) {
        ArrayList<EObject> relObjects = new ArrayList<EObject>();
        Object[] objectArray = eObjs;
        int n = eObjs.length;
        int n2 = 0;
        while (n2 < n) {
            Object eObj = objectArray[n2];
            if (eObj instanceof Table || eObj instanceof View || eObj instanceof Procedure || eObj instanceof ProcedureResult || eObj instanceof Schema || eObj instanceof Catalog || eObj instanceof Column || eObj instanceof ProcedureParameter || eObj instanceof Interface || eObj instanceof Operation || eObj instanceof XmlDocument) {
                relObjects.add((EObject)eObj);
            }
            ++n2;
        }
        return relObjects.toArray();
    }

    private Image getImage(Object element) {
        if (element instanceof EObject) {
            return ModelUtilities.getEMFLabelProvider().getImage(element);
        }
        if (element instanceof Resource) {
            try {
                EObject firstEObj = (EObject)((Resource)element).getContents().get(0);
                ModelAnnotation ma = ModelerCore.getModelEditor().getModelAnnotation(firstEObj);
                ModelType mType = ma.getModelType();
                if (ModelType.PHYSICAL_LITERAL == mType) {
                    return ModelIdentifier.getImage((int)0);
                }
                if (ModelIdentifier.isFunctionModelUri((String)ma.getPrimaryMetamodelUri())) {
                    return ModelIdentifier.getImage((int)2);
                }
                if (ModelIdentifier.isXmlViewModel((String)ma.getPrimaryMetamodelUri())) {
                    return ModelIdentifier.getImage((int)5);
                }
                if (ModelIdentifier.isWebServicesViewModel((String)ma.getPrimaryMetamodelUri())) {
                    return ModelIdentifier.getImage((int)6);
                }
                return ModelIdentifier.getImage((int)4);
            }
            catch (ModelerCoreException e) {
                RolesUiPlugin.UTIL.log(4, RolesUiPlugin.UTIL.getString("errorFindingImageForObject", new Object[]{element, e}));
            }
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ModelUtilities.getModelContentProvider().getParent(element);
        }
        if (element instanceof Resource) {
            return ((Resource)element).getResourceSet();
        }
        return null;
    }

    private Image getSecurityStatusImage(Object target) {
        Permission perm = this.handler.getPermission(target);
        if (perm != null) {
            if (this.allowsRowFilter(target) || this.allowsColumnMask(target)) {
                if (perm.getCondition() != null || perm.getMask() != null) {
                    return BLUE_STATUS_BOX;
                }
                return WHITE_STATUS_BOX;
            }
            return GRAY_STATUS_BOX;
        }
        if (this.allowsRowFilter(target) || this.allowsColumnMask(target)) {
            return WHITE_STATUS_BOX;
        }
        return GRAY_STATUS_BOX;
    }

    public String getTargetName(Object element) {
        String targetName = null;
        if (element instanceof Resource) {
            return this.getResourceName((Resource)element);
        }
        if (element instanceof EObject) {
            EObject eObj = (EObject)element;
            targetName = String.valueOf(this.getResourceName(eObj.eResource())) + '/' + ModelerCore.getModelEditor().getModelRelativePath(eObj);
        }
        if (targetName != null) {
            targetName = targetName.replace('/', '.');
        }
        return targetName;
    }

    public Object getPermissionTargetObject(Permission perm) {
        String targetName = perm.getTargetName();
        Resource[] resourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource res = resourceArray[n2];
            if (this.getTargetName(res).equals(targetName)) {
                return res;
            }
            Object[] objectArray = this.getChildren(res);
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object child = objectArray[n4];
                if (this.getTargetName(child).equals(targetName)) {
                    return child;
                }
                Object target = this.getTargetObjectInChildren(child, targetName);
                if (target != null) {
                    return target;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private String getResourceName(Resource res) {
        if (res.getURI().path().endsWith(".xmi")) {
            Path path = new Path(res.getURI().path());
            return path.removeFileExtension().lastSegment();
        }
        return res.getURI().path();
    }

    private Object getTargetObjectInChildren(Object parent, String targetName) {
        Object[] objectArray = this.getChildren(parent);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (this.getTargetName(child).equals(targetName)) {
                return child;
            }
            Object target = this.getTargetObjectInChildren(child, targetName);
            if (target != null) {
                return target;
            }
            ++n2;
        }
        return null;
    }

    private String getText(Object element) {
        if (element instanceof EObject) {
            ILabelProvider p = ModelUtilities.getEMFLabelProvider();
            return p.getText(element);
        }
        if (element instanceof Resource) {
            return ((Resource)element).getURI().lastSegment();
        }
        return "";
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    private void reInitializePermissions() {
        if (this.handler.hasPermissions()) {
            return;
        }
        Resource[] resourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource res = resourceArray[n2];
            String resPath = this.getTargetName(res);
            Permission perm = new Permission(resPath, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
            perm.setPrimary(true);
            this.handler.addPermission(res, perm);
            ++n2;
        }
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void togglePermission(Object element, Crud.Type crudType) {
        this.handler.toggleElementPermission(element, crudType);
    }

    public IStatus getToggleStatus(Object element, Crud.Type crudType) {
        return this.handler.getToggleStatus(element, crudType);
    }

    public void loadPermissions(Collection<Permission> permissions) {
        this.handler.loadPermissions(permissions);
    }

    public Collection<Permission> getPermissions() {
        return this.handler.getPermissions();
    }

    public List<Permission> getPermissionsWithRowBasedSecurity() {
        return this.handler.getPermissionsWithRowBasedSecurity();
    }

    public Permission getPermission(String targetName) {
        return this.handler.getPermission(targetName);
    }

    public Permission getPermission(Object element) {
        return this.handler.getPermission(element);
    }

    public List<Permission> getPermissionsWithColumnMasking() {
        return this.handler.getPermissionsWithColumnMasking();
    }

    public void removeRowBasedSecurity(Permission permission) {
        this.handler.removeRowBasedSecurity(permission);
    }

    public void setRowsBasedSecurity(String targetName, String condition, boolean constraint) {
        this.handler.setRowsBasedSecurity(targetName, condition, constraint);
    }

    public void removeColumnMask(Permission permission) {
        this.handler.removeColumnMask(permission);
    }

    public void removeColumnMask(String targetName) {
        this.handler.removeColumnMask(targetName);
    }

    public void setColumnMask(String targetName, String condition, String mask, int order) {
        this.handler.setColumnMask(targetName, condition, mask, order);
    }

    public List<String> getAllowedLanguages() {
        return this.handler.getAllowedLanguages();
    }

    public void addAllowedLanguage(String language) {
        this.handler.addAllowedLanguage(language);
    }

    public void removeAllowedLanguage(String language) {
        this.handler.removeAllowedLanguage(language);
    }

    public Permission createPermission(Object target) {
        String targetName = this.getTargetName(target);
        Permission perm = new Permission(targetName, new Crud(null, null, null, null, null, null));
        perm.setCanFilter(this.allowsRowFilter(target));
        perm.setCanMask(this.allowsColumnMask(target));
        this.handler.addPermission(target, perm);
        return perm;
    }

    public boolean allowsRowFilter(Object target) {
        return target instanceof Table || target instanceof View || target instanceof Procedure;
    }

    public boolean allowsColumnMask(Object target) {
        return target instanceof Column;
    }

    public boolean allowsCondition(Object target) {
        return this.allowsColumnMask(target) || this.allowsRowFilter(target);
    }

    public String getSecurityDialogMessage(Object target) {
        if (target instanceof Column) {
            return NLS.bind((String)Messages.setSecurityValuesFor_0_message, (Object)Messages.column);
        }
        if (target instanceof Table) {
            return NLS.bind((String)Messages.setSecurityValuesFor_0_message, (Object)Messages.table);
        }
        if (target instanceof View) {
            return NLS.bind((String)Messages.setSecurityValuesFor_0_message, (Object)Messages.view);
        }
        if (target instanceof Procedure) {
            return NLS.bind((String)Messages.setSecurityValuesFor_0_message, (Object)Messages.procedure);
        }
        return "";
    }

    public void handlePermissionChanged(Permission permission) {
        this.handler.handlePermissionChanged(permission);
    }
}

