/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.roles.Permission;

public class DataRoleResolver {
    private static final char DELIM = '.';
    private static final char B_SLASH = '/';
    private static final String DQUOTE_STR = "\"";
    private static final char DQUOTE_CHAR = '\"';
    private static final String SYS_TABLE_TARGET = "sys";
    private static final String PG_CATALOG_TARGET = "pg_catalog";
    private Container tempContainer;

    public DataRoleResolver(Container tempContainer) {
        this.tempContainer = tempContainer;
    }

    public DataRole resolveDataRole(DataRole originalDataRole) {
        DataRole changedRole = null;
        ArrayList<Permission> keepPerms = new ArrayList<Permission>();
        boolean changedPerms = false;
        for (Permission perm : originalDataRole.getPermissions()) {
            String targetName = perm.getTargetName();
            if (targetName.equals(SYS_TABLE_TARGET) || targetName.equals(PG_CATALOG_TARGET)) {
                keepPerms.add(perm);
                continue;
            }
            Path targetPath = new Path(this.getTargetNamePath(targetName));
            if (this.targetStillExists((IPath)targetPath)) {
                keepPerms.add(perm);
                continue;
            }
            changedPerms = true;
        }
        if (changedPerms) {
            changedRole = new DataRole(originalDataRole.getName());
            changedRole.setDescription(originalDataRole.getDescription());
            if (!originalDataRole.getRoleNames().isEmpty()) {
                changedRole.setRoleNames(originalDataRole.getRoleNames());
            }
            changedRole.setPermissions(keepPerms);
            changedRole.setAnyAuthenticated(originalDataRole.isAnyAuthenticated());
        }
        return changedRole;
    }

    private String getTargetNamePath(String dotPath) {
        if (dotPath.contains(DQUOTE_STR)) {
            StringBuilder sb = new StringBuilder();
            boolean betweenDQuotes = false;
            char[] cArray = dotPath.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char nextChar = cArray[n2];
                if (nextChar == '\"') {
                    betweenDQuotes = !betweenDQuotes;
                    sb.append(nextChar);
                } else if (nextChar == '.') {
                    if (!betweenDQuotes) {
                        sb.append('/');
                    } else {
                        sb.append(nextChar);
                    }
                } else {
                    sb.append(nextChar);
                }
                ++n2;
            }
            return sb.toString();
        }
        return dotPath.replace('.', '/');
    }

    private boolean targetStillExists(IPath path) {
        if (path.segmentCount() == 1) {
            return true;
        }
        Resource resource = null;
        for (Resource res : this.tempContainer.getResources()) {
            String modelName = res.getURI().lastSegment();
            if (!modelName.equalsIgnoreCase(String.valueOf(path.segment(0)) + ".xmi")) continue;
            resource = res;
            break;
        }
        EObject obj = null;
        if (resource != null) {
            Path fragmentPath = new Path("");
            int nSegs = path.segmentCount();
            int i = 1;
            while (i < nSegs) {
                fragmentPath = fragmentPath.append(path.segment(i));
                ++i;
            }
            obj = ModelerCore.getModelEditor().findObjectByPath(resource, (IPath)fragmentPath);
        }
        return obj != null;
    }
}

