/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.ui;

import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.teiid.designer.modelgenerator.salesforce.ui.ConnectionProfileWizard;
import org.teiid.designer.modelgenerator.salesforce.ui.ModelGeneratorSalesforceUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class SalesForceProfileDetailsWizardPage
extends ConnectionProfileDetailsPage
implements Listener,
ModelGeneratorSalesforceUiConstants {
    private static final String DEFAULT_URL = UTIL.getString("Common.URL.Default.Label", new Object[0]);
    private Composite scrolled;
    private Label profileLabel;
    private CLabel profileText;
    private Label descriptionLabel;
    private CLabel descriptionText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Button urlCheckBox;
    private Text urlText;
    private boolean validatedConnection = false;
    private Pattern urlPattern = Pattern.compile("^https://[^/?]+\\.(sales|visual\\.)force\\.com/services/(S|s)(O|o)(A|a)(P|p)/(u|c)/.*");

    public SalesForceProfileDetailsWizardPage(String pageName) {
        super(pageName, UTIL.getString("SalesForceProfileDetailsWizardPage.Name", new Object[0]), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.modelgenerator.salesforce.ui", (String)"icons/salesforce_wiz.gif"));
    }

    public void createCustomControl(Composite parent) {
        Group group = new Group(parent, 2048);
        group.setText(UTIL.getString("Common.Properties.Label", new Object[0]));
        group.setLayout((Layout)new FillLayout());
        this.scrolled = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.scrolled.setLayout((Layout)gridLayout);
        this.profileLabel = new Label(this.scrolled, 0);
        this.profileLabel.setText(UTIL.getString("Common.Profile.Label", new Object[0]));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.profileLabel.setLayoutData((Object)gd);
        this.profileText = WidgetFactory.createLabel((Composite)this.scrolled, (int)2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.profileText.setLayoutData((Object)gd);
        this.profileText.setText(((ConnectionProfileWizard)this.getWizard()).getProfileName());
        this.profileText.setEnabled(false);
        this.descriptionLabel = new Label(this.scrolled, 0);
        this.descriptionLabel.setText(UTIL.getString("Common.Description.Label", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.descriptionLabel.setLayoutData((Object)gd);
        this.descriptionText = WidgetFactory.createLabel((Composite)this.scrolled, (int)2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.descriptionText.setLayoutData((Object)gd);
        this.descriptionText.setText(((ConnectionProfileWizard)this.getWizard()).getProfileDescription());
        this.descriptionText.setEnabled(false);
        this.usernameLabel = new Label(this.scrolled, 0);
        this.usernameLabel.setText(UTIL.getString("Common.Username.Label", new Object[0]));
        this.usernameLabel.setToolTipText(UTIL.getString("Common.Username.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.usernameLabel.setLayoutData((Object)gd);
        this.usernameText = new Text(this.scrolled, 2052);
        this.usernameText.setToolTipText(UTIL.getString("Common.Username.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.usernameText.setLayoutData((Object)gd);
        this.passwordLabel = new Label(this.scrolled, 0);
        this.passwordLabel.setText(UTIL.getString("Common.Password.Label", new Object[0]));
        this.passwordLabel.setToolTipText(UTIL.getString("Common.Password.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.passwordLabel.setLayoutData((Object)gd);
        this.passwordText = new Text(this.scrolled, 0x400804);
        this.passwordText.setToolTipText(UTIL.getString("Common.Password.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.passwordText.setLayoutData((Object)gd);
        this.urlCheckBox = new Button(this.scrolled, 32);
        this.urlCheckBox.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlCheckBox.setToolTipText(UTIL.getString("Common.URL.CheckBox.ToolTip", new Object[0]));
        this.urlCheckBox.setSelection(false);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.urlCheckBox.setLayoutData((Object)gd);
        this.urlText = new Text(this.scrolled, 2052);
        this.urlText.setText(DEFAULT_URL);
        this.urlText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.setEditable(false);
        this.urlText.setEnabled(false);
        this.setAutoConnectOnFinishDefault(false);
        this.setPingButtonEnabled(false);
        this.setPageComplete(false);
        this.addListeners();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateState();
    }

    private void addListeners() {
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.urlText.addListener(24, (Listener)this);
        this.urlCheckBox.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.urlCheckBox) {
            boolean enable = this.urlCheckBox.getSelection();
            this.urlText.setEnabled(enable);
            this.urlText.setEditable(enable);
            this.urlText.setText("");
            this.setValidatedConnection(false);
            if (!enable) {
                this.urlText.setText(DEFAULT_URL);
                Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
                properties.remove("url");
            }
        }
        if (event.widget == this.usernameText) {
            Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
            properties.setProperty("username", this.usernameText.getText());
            this.setValidatedConnection(false);
        }
        if (event.widget == this.passwordText) {
            Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
            properties.setProperty("password", this.passwordText.getText());
            this.setValidatedConnection(false);
        }
        if (event.widget == this.urlText) {
            Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
            properties.setProperty("url", this.urlText.getText());
            this.setValidatedConnection(false);
        }
        this.updateState();
    }

    void updateState() {
        this.profileText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileDescription());
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (properties.get("username") == null || properties.get("username").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.Username.Error.Message", new Object[0]));
            this.setPingButtonEnabled(false);
            return;
        }
        this.setErrorMessage(null);
        if (properties.get("password") == null || properties.get("password").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.Password.Error.Message", new Object[0]));
            this.setPingButtonEnabled(false);
            return;
        }
        this.setErrorMessage(null);
        if (this.urlCheckBox.getSelection()) {
            if (properties.get("url") == null || properties.get("url").toString().isEmpty()) {
                this.setErrorMessage(UTIL.getString("Common.URL.Error.Message", new Object[0]));
                this.setPingButtonEnabled(false);
                return;
            }
            if (!this.isSFURLValid(properties.get("url").toString())) {
                this.setErrorMessage(UTIL.getString("Common.URLInvalid.Error.Message", new Object[0]));
                this.setPingButtonEnabled(false);
                return;
            }
        } else {
            this.setErrorMessage(null);
        }
        if (!this.isValidatedConnection()) {
            this.setMessage(UTIL.getString("Click.Test.Connection", new Object[0]));
            this.setPingButtonEnabled(true);
        } else {
            this.setPageComplete(true);
            this.setMessage(UTIL.getString("Click.Next", new Object[0]));
        }
    }

    private boolean isSFURLValid(String sfURL) {
        Matcher matcher = this.urlPattern.matcher(sfURL);
        return matcher.matches();
    }

    public boolean canFlipToNextPage() {
        return this.internalComplete(super.canFlipToNextPage());
    }

    private boolean internalComplete(boolean complete) {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (complete && (properties.get("username") == null || properties.get("username").toString().isEmpty())) {
            complete = false;
        }
        if (complete && (properties.get("password") == null || properties.get("password").toString().isEmpty())) {
            complete = false;
        }
        if (complete && this.urlCheckBox.getSelection() && (properties.get("url") == null || properties.get("url").toString().isEmpty())) {
            complete = false;
        }
        if (complete && this.btnPing.isEnabled() && this.isValidatedConnection()) {
            complete = true;
        }
        return complete;
    }

    public void testConnection() {
        super.testConnection();
    }

    protected Runnable createTestConnectionRunnable(IConnectionProfile profile) {
        final SalesforcePingJob pingJob = new SalesforcePingJob(this.getShell(), profile);
        pingJob.schedule();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    pingJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
    }

    public void setValidatedConnection(boolean validatedConnection) {
        this.validatedConnection = validatedConnection;
    }

    public boolean isValidatedConnection() {
        return this.validatedConnection;
    }

    public List getSummaryData() {
        List result = super.getSummaryData();
        result.add(new String[]{UTIL.getString("Common.Username.Label", new Object[0]), this.usernameText.getText()});
        if (this.urlCheckBox.getSelection()) {
            result.add(new String[]{UTIL.getString("Common.URL.Label", new Object[0]), this.urlText.getText()});
        }
        return result;
    }

    public class SalesforcePingJob
    extends Job {
        private IConnectionProfile icp;
        private Shell shell;

        public SalesforcePingJob(Shell shell, IConnectionProfile profile) {
            super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.job"));
            this.setSystem(false);
            this.setUser(true);
            this.shell = shell;
            this.icp = profile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.title"), -1);
            IConnection con = this.createTestConnection(this.icp);
            monitor.done();
            new SalesforcePingUIJob(this.shell, this.getTestConnectionException(con)).schedule();
            if (con != null) {
                con.close();
            }
            return Status.OK_STATUS;
        }

        public IConnection createTestConnection(IConnectionProfile icp) {
            if (icp == null) {
                return null;
            }
            return icp.createConnection("org.eclipse.datatools.connectivity.connectionFactory.pingFactory");
        }

        public Throwable getTestConnectionException(IConnection conn) {
            return conn != null ? conn.getConnectException() : new RuntimeException(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"));
        }

        public class SalesforcePingUIJob
        extends UIJob {
            private Shell shell;
            private Throwable exception;

            public SalesforcePingUIJob(Shell shell, Throwable exception) {
                super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.uijob"));
                this.setSystem(false);
                this.exception = exception;
                this.shell = shell;
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                this.showTestConnectionMessage(this.shell, this.exception);
                return Status.OK_STATUS;
            }

            public void showTestConnectionMessage(Shell shell, Throwable exception) {
                if (exception == null) {
                    MessageDialog.openInformation((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.success"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.success"));
                    SalesForceProfileDetailsWizardPage.this.setValidatedConnection(true);
                    SalesForceProfileDetailsWizardPage.this.updateState();
                } else {
                    ExceptionHandler.showException((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"), (Throwable)exception);
                    SalesForceProfileDetailsWizardPage.this.setValidatedConnection(false);
                    SalesForceProfileDetailsWizardPage.this.setErrorMessage(exception.getMessage());
                    SalesForceProfileDetailsWizardPage.this.updateState();
                }
            }
        }
    }
}

