/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.ui;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.modelgenerator.salesforce.ui.Activator;
import org.teiid.designer.modelgenerator.salesforce.ui.ModelGeneratorSalesforceUiConstants;

public class PropertyPage
extends ProfileDetailsPropertyPage
implements IContextProvider,
ModelGeneratorSalesforceUiConstants {
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(Activator.getDefault().getBundle().getSymbolicName());
    private Composite scrolled;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Label urlLabel;
    private Text urlText;

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected void createCustomContents(Composite parent) {
        Group group = new Group(parent, 2048);
        group.setText(UTIL.getString("Common.Properties.Label", new Object[0]));
        FillLayout fl = new FillLayout();
        fl.type = 256;
        group.setLayout((Layout)new FillLayout());
        this.scrolled = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.scrolled.setLayout((Layout)gridLayout);
        this.usernameLabel = new Label(this.scrolled, 0);
        this.usernameLabel.setText(UTIL.getString("Common.Username.Label", new Object[0]));
        this.usernameLabel.setToolTipText(UTIL.getString("Common.Username.ToolTip", new Object[0]));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.usernameLabel.setLayoutData((Object)gd);
        this.usernameText = new Text(this.scrolled, 2052);
        this.usernameText.setToolTipText(UTIL.getString("Common.Username.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.usernameText.setLayoutData((Object)gd);
        this.passwordLabel = new Label(this.scrolled, 0);
        this.passwordLabel.setText(UTIL.getString("Common.Password.Label", new Object[0]));
        this.passwordLabel.setToolTipText(UTIL.getString("Common.Password.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.passwordLabel.setLayoutData((Object)gd);
        this.passwordText = new Text(this.scrolled, 0x400804);
        this.passwordText.setToolTipText(UTIL.getString("Common.Password.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.passwordText.setLayoutData((Object)gd);
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlLabel.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.urlLabel.setLayoutData((Object)gd);
        this.urlText = new Text(this.scrolled, 2052);
        this.urlText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.urlText.setLayoutData((Object)gd);
        this.initControls();
        this.addlisteners();
    }

    private void addlisteners() {
        this.usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyPage.this.validate();
            }
        });
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyPage.this.validate();
            }
        });
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyPage.this.validate();
            }
        });
    }

    protected void validate() {
        String errorMessage = null;
        boolean valid = true;
        if (this.usernameText.getText() == null || this.usernameText.getText().isEmpty()) {
            errorMessage = UTIL.getString("Common.Username.Error.Message", new Object[0]);
            valid = false;
        }
        if (this.passwordText.getText() == null || this.passwordText.getText().isEmpty()) {
            errorMessage = UTIL.getString("Common.Password.Error.Message", new Object[0]);
            valid = false;
        }
        this.setErrorMessage(errorMessage);
        this.setValid(valid);
    }

    private void initControls() {
        IConnectionProfile profile = this.getConnectionProfile();
        Properties props = profile.getBaseProperties();
        if (props.get("username") != null) {
            this.usernameText.setText((String)props.get("username"));
        }
        if (props.get("password") != null) {
            this.passwordText.setText((String)props.get("password"));
        }
        if (props.get("url") != null) {
            this.urlText.setText((String)props.get("url"));
        }
    }

    protected Properties collectProperties() {
        Properties result = super.collectProperties();
        if (result == null) {
            result = new Properties();
        }
        result.setProperty("username", this.usernameText.getText());
        result.setProperty("password", this.passwordText.getText());
        if (this.urlText.getText() != null && !this.urlText.getText().isEmpty()) {
            result.setProperty("url", this.urlText.getText());
        }
        return result;
    }
}

