/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.convertor.MxdConvertor;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionParser;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.actions.RegistryDeploymentValidator;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.IExecutionConfigurationListener;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;

public class TeiidInstanceMedListener
implements IExecutionConfigurationListener {
    private static TeiidInstanceMedListener instance;
    private ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
    private IStatus result = null;

    public static TeiidInstanceMedListener getInstance() {
        if (instance == null) {
            instance = new TeiidInstanceMedListener();
        }
        return instance;
    }

    private TeiidInstanceMedListener() {
    }

    private void addStatus(int severity, String msg, Exception e) {
        if (this.result == null) {
            this.result = new MultiStatus("org.teiid.designer.extension.ui", -1, Messages.translatorExtensionConversionResult, null);
        }
        ((MultiStatus)this.result).add((IStatus)new Status(severity, "org.teiid.designer.extension.ui", -1, msg, (Throwable)e));
    }

    private void internalRun(File medToRegister, boolean isUpdate) throws Exception {
        FileInputStream inputStream;
        if (isUpdate) {
            inputStream = new FileInputStream(medToRegister);
            try {
                ModelExtensionDefinition med = RegistryDeploymentValidator.parseMed(inputStream, false);
                if (this.registry.isNamespacePrefixRegistered(med.getNamespacePrefix())) {
                    this.registry.removeDefinition(med.getNamespacePrefix());
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        inputStream = new FileInputStream(medToRegister);
        try {
            ModelExtensionDefinition definition = this.registry.addDefinition((InputStream)inputStream, (ModelExtensionAssistant)ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant());
            if (definition != null) {
                definition.markAsImported();
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
    }

    private void deploy(File fileInput) throws Exception {
        CoreArgCheck.isNotNull((Object)fileInput);
        ModelExtensionDefinition med = null;
        ModelExtensionDefinitionParser parser = new ModelExtensionDefinitionParser(ExtensionPlugin.getInstance().getMedSchema());
        FileInputStream inputStream = new FileInputStream(fileInput);
        try {
            med = parser.parse((InputStream)inputStream, (ModelExtensionAssistant)ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant());
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        if (med == null || !parser.getErrors().isEmpty()) {
            String name = med != null ? med.getNamespacePrefix() : Messages.teiidGeneratedMed;
            StringBuffer errorMsg = new StringBuffer(NLS.bind((String)Messages.medFileParseErrorMsg, (Object)name));
            errorMsg.append("\n");
            for (String err : parser.getErrors()) {
                errorMsg.append(Messages.parsingError);
                errorMsg.append(err);
                errorMsg.append("\n");
            }
            throw new Exception(errorMsg.toString());
        }
        ModelExtensionDefinition medNSPrefixMatch = RegistryDeploymentValidator.getRegisteredMedWithNSPrefix(this.registry, med.getNamespacePrefix());
        ModelExtensionDefinition medNSUriMatch = RegistryDeploymentValidator.getRegisteredMedWithNSUri(this.registry, med.getNamespaceUri());
        boolean nsPrefixConflict = false;
        boolean nsUriConflict = false;
        boolean nsPrefixAndUriConflictSameMed = false;
        boolean nsPrefixConflictMedBuiltIn = false;
        boolean nsUriConflictMedBuiltIn = false;
        if (medNSPrefixMatch != null) {
            nsPrefixConflict = true;
            nsPrefixConflictMedBuiltIn = medNSPrefixMatch.isBuiltIn();
        }
        if (medNSUriMatch != null) {
            nsUriConflict = true;
            nsUriConflictMedBuiltIn = medNSUriMatch.isBuiltIn();
        }
        if (nsPrefixConflict && nsUriConflict && medNSPrefixMatch.equals((Object)medNSUriMatch)) {
            nsPrefixAndUriConflictSameMed = true;
        }
        if (!nsPrefixConflict && !nsUriConflict) {
            this.internalRun(fileInput, false);
        } else {
            if (nsPrefixConflictMedBuiltIn) {
                return;
            }
            if (nsUriConflictMedBuiltIn) {
                return;
            }
            if (nsPrefixConflict && (!nsUriConflict || nsUriConflict && nsPrefixAndUriConflictSameMed)) {
                if (med.equals((Object)medNSPrefixMatch)) {
                    return;
                }
                this.internalRun(fileInput, true);
            } else if (nsUriConflict) {
                throw new Exception(Messages.registerMedActionNamespacePrefixRegisteredDoUpdateMsg);
            }
        }
    }

    private IStatus analyseTranslators(ITeiidServer teiidInstance) {
        CoreArgCheck.isNotNull((Object)teiidInstance, (String)"teiid instance");
        FileOutputStream output = null;
        this.result = null;
        Collection<Object> translators = Collections.emptyList();
        try {
            translators = teiidInstance.getTranslators();
        }
        catch (Exception ex) {
            this.addStatus(4, Messages.failureToReceiveTranslators, ex);
            return this.result;
        }
        if (translators == null || translators.isEmpty()) {
            return Status.OK_STATUS;
        }
        MxdConvertor convertor = MxdConvertor.getInstance();
        for (ITeiidTranslator iTeiidTranslator : translators) {
            File outputFile;
            block18: {
                outputFile = File.createTempFile(this.getClass().getSimpleName(), ".xml");
                outputFile.deleteOnExit();
                output = new FileOutputStream(outputFile);
                boolean conversion = convertor.convert(iTeiidTranslator, (OutputStream)output);
                if (conversion) break block18;
                if (output == null) continue;
                try {
                    output.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            try {
                try {
                    this.deploy(outputFile);
                }
                catch (Exception ex) {
                    this.addStatus(4, NLS.bind((String)Messages.errorOccurredAnalysingTranslators, (Object)iTeiidTranslator.getName(), (Object)ex.getLocalizedMessage()), ex);
                    if (output == null) continue;
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (output == null) continue;
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        return this.result != null ? this.result : Status.OK_STATUS;
    }

    public void configurationChanged(final ExecutionConfigurationEvent event) {
        switch (event.getEventType()) {
            case CONNECTED: {
                Job job = new Job(Messages.analyseTranslatorsJob){

                    protected IStatus run(IProgressMonitor monitor) {
                        return TeiidInstanceMedListener.this.analyseTranslators(event.getServer());
                    }
                };
                job.setPriority(30);
                job.setSystem(true);
                job.setUser(false);
                job.schedule();
            }
        }
    }
}

