/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.teiid.core.designer.util.ArrayUtil;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.extension.AbstractMetaclassNameProvider;
import org.teiid.designer.core.extension.ModelTypeMetaclassNameFactory;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ExtendableMetaclassNameProvider;
import org.teiid.designer.extension.definition.MedStatus;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionValidator;
import org.teiid.designer.extension.definition.ValidationStatus;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.UiConstants;
import org.teiid.designer.extension.ui.editors.EditMetaclassDialog;
import org.teiid.designer.extension.ui.editors.EditPropertyDialog;
import org.teiid.designer.extension.ui.editors.ErrorMessage;
import org.teiid.designer.extension.ui.editors.MedEditorPage;
import org.teiid.designer.extension.ui.editors.MedSelectionProvider;
import org.teiid.designer.extension.ui.editors.MedSelectionSynchronizer;
import org.teiid.designer.extension.ui.editors.ModelExtensionDefinitionEditor;
import org.teiid.designer.extension.ui.model.MedModelNode;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.forms.MessageFormDialog;

public class PropertiesEditorPage
extends MedEditorPage {
    private Button btnAddMetaclass;
    private Button btnAddProperty;
    private Button btnEditMetaclass;
    private Button btnEditProperty;
    private Button btnRemoveMetaclass;
    private Button btnRemoveProperty;
    private TableViewer metaclassViewer;
    private MedSelectionProvider metaclassSelectionProvider;
    private TableViewer propertyViewer;
    private MedSelectionProvider propertySelectionProvider;
    private final ErrorMessage metaclassError = new ErrorMessage();
    private final ErrorMessage propertyError = new ErrorMessage();

    public PropertiesEditorPage(ModelExtensionDefinitionEditor medEditor) {
        super(medEditor, UiConstants.EditorIds.MED_PROPERTIES_PAGE, Messages.medEditorPropertiesPageTitle);
        this.validateMetaclasses();
    }

    MedEditorPage accessPage() {
        return this;
    }

    private boolean confirmMetaclass(String metaclassBeingValidated, ExtendableMetaclassNameProvider provider, String validMetaclass) {
        if (metaclassBeingValidated.equals(validMetaclass)) {
            return true;
        }
        String[] kids = provider.getExtendableMetaclassChildren(validMetaclass);
        boolean confirmed = false;
        if (kids != null && kids.length != 0) {
            String[] stringArray = kids;
            int n = kids.length;
            int n2 = 0;
            while (n2 < n) {
                String kid = stringArray[n2];
                confirmed = this.confirmMetaclass(metaclassBeingValidated, provider, kid);
                if (confirmed) break;
                ++n2;
            }
        }
        return confirmed;
    }

    @Override
    protected void createBody(Composite body, FormToolkit toolkit) {
        body.setLayout((Layout)new GridLayout());
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite top = toolkit.createComposite(body, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite finalTop = top;
        Composite bottom = toolkit.createComposite(body, 0);
        bottom.setLayout((Layout)new GridLayout());
        bottom.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite finalBottom = bottom;
        Section metaclassSection = this.createExtendedMetaclassSection(finalTop, toolkit);
        ((GridData)finalTop.getLayoutData()).heightHint = this.metaclassViewer.getTable().getItemHeight() * 10;
        Section propertiesSection = this.createPropertiesSection(finalBottom, toolkit);
        ((GridData)finalBottom.getLayoutData()).heightHint = this.propertyViewer.getTable().getItemHeight() * 10;
        propertiesSection.descriptionVerticalSpacing = metaclassSection.getTextClientHeightDifference();
        MedSelectionSynchronizer selectionSynchronizer = this.getMedEditor().getSelectionSynchronizer();
        this.metaclassSelectionProvider = new SelectionProvider(true);
        selectionSynchronizer.addSelectionProvider(this.metaclassSelectionProvider);
        this.propertySelectionProvider = new SelectionProvider(false);
        selectionSynchronizer.addSelectionProvider(this.propertySelectionProvider);
        this.metaclassViewer.setInput((Object)this);
        WidgetUtil.pack((TableViewer)this.metaclassViewer);
        IMessageManager msgMgr = ((ModelExtensionDefinitionEditor)this.getEditor()).getMessageManager();
        msgMgr.removeMessage(this.metaclassError.getKey());
        msgMgr.removeMessage(this.propertyError.getKey());
    }

    private void configureColumn(TableViewerColumn viewerColumn, int columnIndex, String headerText, String headerToolTip, boolean resizable) {
        viewerColumn.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(columnIndex));
        TableColumn column = viewerColumn.getColumn();
        column.setText(headerText);
        column.setToolTipText(headerToolTip);
        column.setMoveable(false);
        column.setResizable(resizable);
        column.pack();
    }

    private Section createExtendedMetaclassSection(Composite parent, FormToolkit toolkit) {
        Composite container;
        Section section;
        Section finalSection = section = FormUtil.createSection((IManagedForm)this.getManagedForm(), (FormToolkit)toolkit, (Composite)parent, (String)Messages.overviewPageExtendedMetaclassTitle, (String)Messages.overviewPageExtendedMetaclassDescription, (int)8642, (boolean)true);
        Button[] buttons = FormUtil.createSectionToolBar((Section)finalSection, (FormToolkit)toolkit, (Image[])new Image[]{Activator.getDefault().getImage("icons/add-metaclass.png"), Activator.getDefault().getImage("icons/edit-metaclass.png"), Activator.getDefault().getImage("icons/remove-metaclass.png")});
        this.btnAddMetaclass = buttons[0];
        this.btnAddMetaclass.setEnabled(!CoreStringUtil.isEmpty((String)this.getMed().getMetamodelUri()));
        this.btnAddMetaclass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditorPage.this.handleAddMetaclass();
            }
        });
        this.btnAddMetaclass.setToolTipText(Messages.propertiesPageAddMetaclassButtonToolTip);
        this.btnEditMetaclass = buttons[1];
        this.btnEditMetaclass.setEnabled(false);
        this.btnEditMetaclass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditorPage.this.handleEditMetaclass();
            }
        });
        this.btnEditMetaclass.setToolTipText(Messages.propertiesPageEditMetaclassButtonToolTip);
        this.btnRemoveMetaclass = buttons[2];
        this.btnRemoveMetaclass.setEnabled(false);
        this.btnRemoveMetaclass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditorPage.this.handleRemoveMetaclass();
            }
        });
        this.btnRemoveMetaclass.setToolTipText(Messages.propertiesPageRemoveMetaclassButtonToolTip);
        Composite finalContainer = container = toolkit.createComposite((Composite)finalSection);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        finalSection.setClient((Control)container);
        Table table = toolkit.createTable(finalContainer, 2820);
        table.setLayoutData((Object)new GridLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * 5;
        this.metaclassError.setControl((Control)table);
        this.metaclassViewer = new TableViewer(table);
        this.metaclassViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return PropertiesEditorPage.this.getMed().getExtendedMetaclasses();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.metaclassViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String elemString = element.toString();
                return PropertiesEditorPage.this.getMetaclassShortName(elemString);
            }
        });
        this.metaclassViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PropertiesEditorPage.this.handleEditMetaclass();
            }
        });
        this.metaclassViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertiesEditorPage.this.handleMetaclassSelected();
            }
        });
        return finalSection;
    }

    private String getMetaclassShortName(String metaclassName) {
        return AbstractMetaclassNameProvider.getLabel((String)metaclassName);
    }

    private Section createPropertiesSection(Composite parent, FormToolkit toolkit) {
        Composite container;
        Section section;
        Section finalSection = section = FormUtil.createSection((IManagedForm)this.getManagedForm(), (FormToolkit)toolkit, (Composite)parent, (String)Messages.propertiesPageExtensionPropertiesTitle, (String)Messages.propertiesPageExtensionPropertiesDescription, (int)8642, (boolean)true);
        Button[] buttons = FormUtil.createSectionToolBar((Section)finalSection, (FormToolkit)toolkit, (Image[])new Image[]{Activator.getDefault().getImage("icons/add-metaclass.png"), Activator.getDefault().getImage("icons/edit-metaclass.png"), Activator.getDefault().getImage("icons/remove-metaclass.png")});
        this.btnAddProperty = buttons[0];
        this.btnAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditorPage.this.handleAddProperty();
            }
        });
        this.btnAddProperty.setToolTipText(Messages.propertiesPageAddPropertyButtonToolTip);
        this.btnEditProperty = buttons[1];
        this.btnEditProperty.setEnabled(false);
        this.btnEditProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditorPage.this.handleEditProperty();
            }
        });
        this.btnEditProperty.setToolTipText(Messages.propertiesPageEditPropertyButtonToolTip);
        this.btnRemoveProperty = buttons[2];
        this.btnRemoveProperty.setEnabled(false);
        this.btnRemoveProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditorPage.this.handleRemoveProperty();
            }
        });
        this.btnRemoveProperty.setToolTipText(Messages.propertiesPageRemovePropertyButtonToolTip);
        Composite finalContainer = container = toolkit.createComposite((Composite)finalSection);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        finalSection.setClient((Control)container);
        Table table = toolkit.createTable(finalContainer, 2820);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * 5;
        this.propertyError.setControl((Control)table);
        this.propertyViewer = new TableViewer(table);
        this.propertyViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                String metaclass = PropertiesEditorPage.this.getSelectedMetaclass();
                if (CoreStringUtil.isEmpty((String)metaclass)) {
                    return ArrayUtil.Constants.EMPTY_ARRAY;
                }
                return PropertiesEditorPage.this.getMed().getPropertyDefinitions(metaclass).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertyViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PropertiesEditorPage.this.handleEditProperty();
            }
        });
        this.propertyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertiesEditorPage.this.handlePropertySelected();
            }
        });
        TableViewerColumn column = new TableViewerColumn(this.propertyViewer, 16384);
        this.configureColumn(column, 0, ColumnHeaders.SIMPLE_ID, ColumnToolTips.SIMPLE_ID, true);
        column = new TableViewerColumn(this.propertyViewer, 16384);
        this.configureColumn(column, 1, ColumnHeaders.RUNTIME_TYPE, ColumnToolTips.RUNTIME_TYPE, true);
        column = new TableViewerColumn(this.propertyViewer, 0x1000000);
        this.configureColumn(column, 2, ColumnHeaders.REQUIRED, ColumnToolTips.REQUIRED, false);
        column = new TableViewerColumn(this.propertyViewer, 0x1000000);
        this.configureColumn(column, 3, ColumnHeaders.MODFIFIABLE, ColumnToolTips.MODFIFIABLE, false);
        column = new TableViewerColumn(this.propertyViewer, 0x1000000);
        this.configureColumn(column, 4, ColumnHeaders.ADVANCED, ColumnToolTips.ADVANCED, false);
        column = new TableViewerColumn(this.propertyViewer, 0x1000000);
        this.configureColumn(column, 5, ColumnHeaders.MASKED, ColumnToolTips.MASKED, false);
        column = new TableViewerColumn(this.propertyViewer, 0x1000000);
        this.configureColumn(column, 6, ColumnHeaders.INDEXED, ColumnToolTips.INDEXED, false);
        column = new TableViewerColumn(this.propertyViewer, 16384);
        this.configureColumn(column, 7, ColumnHeaders.DEFAULT_VALUE, ColumnToolTips.DEFAULT_VALUE, true);
        column = new TableViewerColumn(this.propertyViewer, 16384);
        this.configureColumn(column, 8, ColumnHeaders.FIXED_VALUE, ColumnToolTips.FIXED_VALUE, true);
        column = new TableViewerColumn(this.propertyViewer, 16384);
        this.configureColumn(column, 9, ColumnHeaders.ALLOWED_VALUES, ColumnToolTips.ALLOWED_VALUES, true);
        column = new TableViewerColumn(this.propertyViewer, 16384);
        this.configureColumn(column, 10, ColumnHeaders.DISPLAY_NAME, ColumnToolTips.DISPLAY_NAME, true);
        column = new TableViewerColumn(this.propertyViewer, 16384);
        this.configureColumn(column, 11, ColumnHeaders.DESCRIPTION, ColumnToolTips.DESCRIPTION, true);
        return finalSection;
    }

    Collection<String> getExistingPropertyIds(String metaclassName) {
        Collection propDefns = this.getMed().getPropertyDefinitions(metaclassName);
        if (propDefns == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> result = new ArrayList<String>(propDefns.size());
        for (ModelExtensionPropertyDefinition propDefn : propDefns) {
            result.add(propDefn.getSimpleId());
        }
        return result;
    }

    Viewer getMetaclassViewer() {
        return this.metaclassViewer;
    }

    Viewer getPropertyViewer() {
        return this.propertyViewer;
    }

    String getSelectedMetaclass() {
        IStructuredSelection selection = (IStructuredSelection)this.metaclassViewer.getSelection();
        return selection.isEmpty() ? null : (String)selection.getFirstElement();
    }

    ModelExtensionPropertyDefinition getSelectedProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.propertyViewer.getSelection();
        return selection.isEmpty() ? null : (ModelExtensionPropertyDefinition)selection.getFirstElement();
    }

    public String getTitleToolTip() {
        return Messages.medEditorPropertiesPageToolTip;
    }

    void handleAddMetaclass() {
        ExtendableMetaclassNameProvider metaclassNameProvider = ExtensionPlugin.getInstance().getMetaclassNameProvider(this.getMed().getMetamodelUri());
        if (metaclassNameProvider instanceof ModelTypeMetaclassNameFactory) {
            metaclassNameProvider = ((ModelTypeMetaclassNameFactory)metaclassNameProvider).getProvider(this.getMed().getSupportedModelTypes());
        }
        List<String> currentlyExtendedMetaclasses = Arrays.asList(this.getMed().getExtendedMetaclasses());
        EditMetaclassDialog dialog = new EditMetaclassDialog(this.getShell(), metaclassNameProvider, currentlyExtendedMetaclasses);
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            String newMetaclassName = dialog.getSelectedMetaclassName();
            if (this.getMed().addMetaclass(newMetaclassName)) {
                this.metaclassViewer.setSelection((ISelection)new StructuredSelection((Object)newMetaclassName));
            }
        }
    }

    void handleEditMetaclass() {
        assert (!CoreStringUtil.isEmpty((String)this.getSelectedMetaclass())) : "Edit metaclass button is enabled and there is no metaclass selected";
        String selectedMetaclassName = this.getSelectedMetaclass();
        String metamodelUri = this.getMed().getMetamodelUri();
        ExtendableMetaclassNameProvider metaclassNameProvider = ExtensionPlugin.getInstance().getMetaclassNameProvider(metamodelUri);
        if (metaclassNameProvider instanceof ModelTypeMetaclassNameFactory) {
            metaclassNameProvider = ((ModelTypeMetaclassNameFactory)metaclassNameProvider).getProvider(this.getMed().getSupportedModelTypes());
        }
        List<String> currentlyExtendedMetaclasses = Arrays.asList(this.getMed().getExtendedMetaclasses());
        EditMetaclassDialog dialog = new EditMetaclassDialog(this.getShell(), metaclassNameProvider, currentlyExtendedMetaclasses, selectedMetaclassName);
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            String modifiedMetaclassName = dialog.getSelectedMetaclassName();
            this.getMed().updateMetaclass(selectedMetaclassName, modifiedMetaclassName);
            this.metaclassViewer.setSelection((ISelection)new StructuredSelection((Object)modifiedMetaclassName));
        }
    }

    void handleAddProperty() {
        assert (this.getSelectedMetaclass() != null) : "Selected metaclass is null and shouldn't be";
        String metaclassName = this.getSelectedMetaclass();
        EditPropertyDialog dialog = new EditPropertyDialog(this.getShell(), (NamespaceProvider)this.getMed(), metaclassName, this.getExistingPropertyIds(metaclassName));
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            ModelExtensionPropertyDefinition newPropDefn = dialog.getPropertyDefinition();
            if (this.getMed().addPropertyDefinition(metaclassName, newPropDefn)) {
                this.propertyViewer.setSelection((ISelection)new StructuredSelection((Object)newPropDefn));
            }
        }
    }

    void handleEditProperty() {
        assert (!CoreStringUtil.isEmpty((String)this.getSelectedMetaclass())) : "Edit property button is enabled and there is no metaclass selected";
        assert (this.getSelectedProperty() != null) : "Edit property button is enabled and there is no property selected";
        String metaclassName = this.getSelectedMetaclass();
        ModelExtensionPropertyDefinition selectedPropDefn = this.getSelectedProperty();
        EditPropertyDialog dialog = new EditPropertyDialog(this.getShell(), (NamespaceProvider)this.getMed(), metaclassName, this.getExistingPropertyIds(metaclassName), selectedPropDefn);
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            ModelExtensionPropertyDefinition modifiedPropDefn = dialog.getPropertyDefinition();
            this.getMed().removePropertyDefinition(metaclassName, selectedPropDefn);
            this.getMed().addPropertyDefinition(metaclassName, modifiedPropDefn);
        }
    }

    @Override
    public void handleMedReloaded() {
        if (this.metaclassViewer != null) {
            this.metaclassViewer.setInput((Object)this);
            this.validateMetaclasses();
        }
    }

    void handleMetaclassSelected() {
        boolean enable;
        boolean bl = enable = this.getSelectedMetaclass() != null && !this.getMedEditor().isReadOnly();
        if (this.btnRemoveMetaclass.getEnabled() != enable) {
            this.btnRemoveMetaclass.setEnabled(enable);
        }
        if (this.btnEditMetaclass.getEnabled() != enable) {
            this.btnEditMetaclass.setEnabled(enable);
        }
        if (this.btnAddProperty.getEnabled() != enable) {
            this.btnAddProperty.setEnabled(enable);
        }
        this.propertyViewer.setInput((Object)this);
        WidgetUtil.pack((TableViewer)this.propertyViewer);
    }

    @Override
    protected void handlePropertyChanged(PropertyChangeEvent e) {
        if (this.btnAddMetaclass == null) {
            return;
        }
        String propName = e.getPropertyName();
        if (ModelExtensionDefinition.PropertyName.METACLASS.toString().equals(propName)) {
            this.validateMetaclasses();
            this.metaclassViewer.refresh();
        } else if (ModelExtensionDefinition.PropertyName.PROPERTY_DEFINITION.toString().equals(propName)) {
            this.validatePropertyDefinitions();
            this.propertyViewer.refresh();
        } else if (ModelExtensionDefinition.PropertyName.NAMESPACE_PREFIX.toString().equals(propName)) {
            this.validatePropertyDefinitions();
            if (this.propertyViewer != null) {
                this.propertyViewer.refresh();
            }
        }
        this.updateState();
    }

    void handlePropertySelected() {
        boolean enable;
        boolean bl = enable = this.getSelectedProperty() != null && !this.getMedEditor().isReadOnly();
        if (this.btnRemoveProperty.getEnabled() != enable) {
            this.btnRemoveProperty.setEnabled(enable);
        }
        if (this.btnEditProperty.getEnabled() != enable) {
            this.btnEditProperty.setEnabled(enable);
        }
    }

    void handleRemoveMetaclass() {
        assert (!CoreStringUtil.isEmpty((String)this.getSelectedMetaclass())) : "Remove metaclass button is enabled and there is no metaclass selected";
        String selectedMetaclassName = this.getSelectedMetaclass();
        String metaclassShortName = this.getMetaclassShortName(selectedMetaclassName);
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)Messages.removeMetaclassDialogTitle, (Image)Activator.getDefault().getImage("icons/model-extension-definition-editor.png"), (String)NLS.bind((String)Messages.removeMetaclassDialogMsg, (Object)metaclassShortName))) {
            this.getMed().removeMetaclass(selectedMetaclassName);
        }
    }

    void handleRemoveProperty() {
        assert (!CoreStringUtil.isEmpty((String)this.getSelectedMetaclass())) : "Remove property button is enabled and there is no metaclass selected";
        assert (this.getSelectedProperty() != null) : "Remove property button is enabled and there is no property selected";
        ModelExtensionPropertyDefinition selectedPropDefn = this.getSelectedProperty();
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)Messages.removePropertyDialogTitle, (Image)Activator.getDefault().getImage("icons/model-extension-definition-editor.png"), (String)NLS.bind((String)Messages.removePropertyDialogMsg, (Object)selectedPropDefn.getSimpleId()))) {
            this.getMed().removePropertyDefinition(this.getSelectedMetaclass(), selectedPropDefn);
        }
    }

    @Override
    public void setFocus() {
        if (this.metaclassViewer != null) {
            this.metaclassViewer.getControl().setFocus();
            if (this.metaclassViewer.getTable().getItemCount() != 0) {
                this.metaclassViewer.getTable().select(0);
                Event event = new Event();
                event.widget = this.metaclassViewer.getTable();
                this.metaclassViewer.getTable().notifyListeners(13, event);
            }
        } else {
            super.setFocus();
        }
    }

    @Override
    protected void setResourceReadOnly(boolean readOnly) {
        this.updateState();
    }

    @Override
    protected void updateAllMessages() {
        this.validateMetaclasses();
        this.validatePropertyDefinitions();
    }

    private void updateState() {
        boolean enable;
        if (this.btnAddMetaclass == null) {
            return;
        }
        boolean bl = enable = !this.getMedEditor().isReadOnly() && !CoreStringUtil.isEmpty((String)this.getMed().getMetamodelUri());
        if (this.btnAddMetaclass.getEnabled() != enable) {
            this.btnAddMetaclass.setEnabled(enable);
        }
        if (this.btnAddProperty.getEnabled() != enable) {
            this.btnAddProperty.setEnabled(enable);
        }
        if (this.btnEditMetaclass.getEnabled() != enable) {
            this.btnEditMetaclass.setEnabled(enable);
        }
        if (this.btnEditProperty.getEnabled() != enable) {
            this.btnEditProperty.setEnabled(enable);
        }
        if (this.btnRemoveMetaclass.getEnabled() != enable) {
            this.btnRemoveMetaclass.setEnabled(enable);
        }
        if (this.btnRemoveProperty.getEnabled() != enable) {
            this.btnRemoveProperty.setEnabled(enable);
        }
        if (this.propertyViewer.getTable().getEnabled() != enable) {
            this.propertyViewer.getTable().setEnabled(enable);
        }
        this.handleMetaclassSelected();
        this.handlePropertySelected();
    }

    private void validateMetaclasses() {
        if (this.getMed().isBuiltIn()) {
            this.metaclassError.setStatus((MedStatus)ValidationStatus.OK_STATUS);
            this.updateMessage(this.metaclassError);
            this.validatePropertyDefinitions();
            return;
        }
        String[] metaclasses = this.getMed().getExtendedMetaclasses();
        MedStatus status = ModelExtensionDefinitionValidator.validateMetaclassNames((String[])metaclasses, (boolean)true);
        if (!status.isError()) {
            ExtendableMetaclassNameProvider provider = ExtensionPlugin.getInstance().getMetaclassNameProvider(this.getMed().getMetamodelUri());
            if (provider instanceof ModelTypeMetaclassNameFactory) {
                provider = ((ModelTypeMetaclassNameFactory)provider).getProvider(this.getMed().getSupportedModelTypes());
            }
            String[] stringArray = metaclasses;
            int n = metaclasses.length;
            int n2 = 0;
            while (n2 < n) {
                String metaclass = stringArray[n2];
                boolean confirmed = false;
                String[] stringArray2 = provider.getExtendableMetaclassRoots();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String metaclassRoot = stringArray2[n4];
                    confirmed = this.confirmMetaclass(metaclass, provider, metaclassRoot);
                    if (confirmed) break;
                    ++n4;
                }
                if (!confirmed) {
                    status = ValidationStatus.createErrorMessage((String)NLS.bind((String)Messages.metaclassNotFoundByProvider, (Object)metaclass));
                    break;
                }
                ++n2;
            }
        }
        this.metaclassError.setStatus(status);
        this.updateMessage(this.metaclassError);
        this.validatePropertyDefinitions();
    }

    private void validatePropertyDefinitions() {
        if (this.getMed().isBuiltIn()) {
            this.propertyError.setStatus((MedStatus)ValidationStatus.OK_STATUS);
        } else {
            this.propertyError.setStatus(ModelExtensionDefinitionValidator.validatePropertyDefinitions((Map)this.getMed().getPropertyDefinitions()));
        }
        this.updateMessage(this.propertyError);
    }

    static interface ColumnHeaders {
        public static final String ADVANCED = Messages.advancedPropertyAttributeColumnHeader;
        public static final String ALLOWED_VALUES = Messages.allowedValuesPropertyAttributeColumnHeader;
        public static final String DEFAULT_VALUE = Messages.defaultValuePropertyAttributeColumnHeader;
        public static final String DESCRIPTION = Messages.descriptionPropertyAttributeColumnHeader;
        public static final String DISPLAY_NAME = Messages.displayNamePropertyAttributeColumnHeader;
        public static final String FIXED_VALUE = Messages.fixedValuePropertyAttributeColumnHeader;
        public static final String INDEXED = Messages.indexedPropertyAttributeColumnHeader;
        public static final String MASKED = Messages.maskedPropertyAttributeColumnHeader;
        public static final String MODFIFIABLE = Messages.modifiablePropertyAttributeColumnHeader;
        public static final String REQUIRED = Messages.requiredPropertyAttributeColumnHeader;
        public static final String RUNTIME_TYPE = Messages.runtimeTypePropertyAttributeColumnHeader;
        public static final String SIMPLE_ID = Messages.simpleIdPropertyAttributeColumnHeader;
    }

    static interface ColumnIndexes {
        public static final int SIMPLE_ID = 0;
        public static final int RUNTIME_TYPE = 1;
        public static final int REQUIRED = 2;
        public static final int MODIFIABLE = 3;
        public static final int ADVANCED = 4;
        public static final int MASKED = 5;
        public static final int INDEXED = 6;
        public static final int DEFAULT_VALUE = 7;
        public static final int FIXED_VALUE = 8;
        public static final int ALLOWED_VALUES = 9;
        public static final int DISPLAY_NAME = 10;
        public static final int DESCRIPTION = 11;
    }

    static interface ColumnToolTips {
        public static final String ADVANCED = Messages.advancedPropertyAttributeColumnHeaderToolTip;
        public static final String ALLOWED_VALUES = Messages.allowedValuesPropertyAttributeColumnHeaderToolTip;
        public static final String DEFAULT_VALUE = Messages.defaultValuePropertyAttributeColumnHeaderToolTip;
        public static final String DESCRIPTION = Messages.descriptionPropertyAttributeColumnHeaderToolTip;
        public static final String DISPLAY_NAME = Messages.displayNamePropertyAttributeColumnHeaderToolTip;
        public static final String FIXED_VALUE = Messages.fixedValuePropertyAttributeColumnHeaderToolTip;
        public static final String INDEXED = Messages.indexedPropertyAttributeColumnHeaderToolTip;
        public static final String MASKED = Messages.maskedPropertyAttributeColumnHeaderToolTip;
        public static final String MODFIFIABLE = Messages.modifiablePropertyAttributeColumnHeaderToolTip;
        public static final String REQUIRED = Messages.requiredPropertyAttributeColumnHeaderToolTip;
        public static final String RUNTIME_TYPE = Messages.runtimeTypePropertyAttributeColumnHeaderToolTip;
        public static final String SIMPLE_ID = Messages.simpleIdPropertyAttributeColumnHeaderToolTip;
    }

    class PropertyLabelProvider
    extends ColumnLabelProvider {
        private final int columnIndex;

        public PropertyLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public Image getImage(Object element) {
            ModelExtensionPropertyDefinition propDefn = (ModelExtensionPropertyDefinition)element;
            boolean enabled = false;
            if (4 == this.columnIndex && propDefn.isAdvanced()) {
                enabled = true;
            } else if (6 == this.columnIndex && propDefn.shouldBeIndexed()) {
                enabled = true;
            } else if (5 == this.columnIndex && propDefn.isMasked()) {
                enabled = true;
            } else if (3 == this.columnIndex && propDefn.isModifiable()) {
                enabled = true;
            } else if (2 == this.columnIndex && propDefn.isRequired()) {
                enabled = true;
            }
            return enabled ? Activator.getDefault().getImage("icons/checkmark.gif") : null;
        }

        public String getText(Object element) {
            String[] allowedValues;
            ModelExtensionPropertyDefinition propDefn = (ModelExtensionPropertyDefinition)element;
            if (this.columnIndex == 0) {
                return propDefn.getSimpleId();
            }
            if (7 == this.columnIndex) {
                return propDefn.getDefaultValue();
            }
            if (8 == this.columnIndex) {
                return propDefn.getFixedValue();
            }
            if (11 == this.columnIndex) {
                String description = propDefn.getDescription();
                if (CoreStringUtil.isEmpty((String)description)) {
                    int size = propDefn.getDescriptions().size();
                    if (size == 1) {
                        return Messages.propertiesPageOneTranslationAvailable;
                    }
                    if (size != 0) {
                        return NLS.bind((String)Messages.propertiesPageManyTranslationsAvailable, (Object)size);
                    }
                    return "";
                }
                return description;
            }
            if (1 == this.columnIndex) {
                return propDefn.getRuntimeType();
            }
            if (10 == this.columnIndex) {
                String displayName = propDefn.getDisplayName();
                if (CoreStringUtil.isEmpty((String)displayName)) {
                    int size = propDefn.getDisplayNames().size();
                    if (size == 1) {
                        return Messages.propertiesPageOneTranslationAvailable;
                    }
                    if (size != 0) {
                        return NLS.bind((String)Messages.propertiesPageManyTranslationsAvailable, (Object)size);
                    }
                    return "";
                }
                return displayName;
            }
            if (9 == this.columnIndex && (allowedValues = propDefn.getAllowedValues()) != null && allowedValues.length != 0) {
                StringBuilder txt = new StringBuilder();
                int size = allowedValues.length;
                int i = 0;
                while (i < size) {
                    if (i != 0) {
                        txt.append(",");
                    }
                    txt.append(allowedValues[i]);
                    ++i;
                }
                return txt.toString();
            }
            return null;
        }
    }

    class SelectionProvider
    implements MedSelectionProvider {
        private final List<ISelectionChangedListener> listeners;
        private final boolean metaclassViewerFlag;

        public SelectionProvider(boolean metaclassViewerFlag) {
            Viewer viewer = metaclassViewerFlag ? PropertiesEditorPage.this.getMetaclassViewer() : PropertiesEditorPage.this.getPropertyViewer();
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectionProvider.this.fireSelectionChanged(event);
                }
            });
            this.metaclassViewerFlag = metaclassViewerFlag;
            this.listeners = new ArrayList<ISelectionChangedListener>(1);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        void fireSelectionChanged(SelectionChangedEvent viewerEvent) {
            IStructuredSelection viewerSelection = (IStructuredSelection)viewerEvent.getSelection();
            if (!viewerSelection.isEmpty()) {
                MedSelectionSynchronizer selectionSynchronizer = PropertiesEditorPage.this.getMedEditor().getSelectionSynchronizer();
                MedModelNode modelNode = null;
                modelNode = this.metaclassViewerFlag ? selectionSynchronizer.getMetaclassNode(PropertiesEditorPage.this.getSelectedMetaclass()) : selectionSynchronizer.getPropertyDefinitionNode(PropertiesEditorPage.this.getSelectedMetaclass(), PropertiesEditorPage.this.getSelectedProperty());
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection((Object)modelNode));
                for (ISelectionChangedListener listener : this.listeners) {
                    listener.selectionChanged(event);
                }
            }
        }

        @Override
        public MedEditorPage getMedEditorPage() {
            return PropertiesEditorPage.this.accessPage();
        }

        public ISelection getSelection() {
            MedSelectionSynchronizer selectionSynchronizer = PropertiesEditorPage.this.getMedEditor().getSelectionSynchronizer();
            if (this.metaclassViewerFlag) {
                MedModelNode metaclassNode;
                String metaclass = PropertiesEditorPage.this.getSelectedMetaclass();
                if (metaclass != null && (metaclassNode = selectionSynchronizer.getMetaclassNode(metaclass)) != null) {
                    return new StructuredSelection((Object)metaclassNode);
                }
            } else {
                MedModelNode propDefnNode;
                ModelExtensionPropertyDefinition propDefn = PropertiesEditorPage.this.getSelectedProperty();
                if (propDefn != null && (propDefnNode = selectionSynchronizer.getPropertyDefinitionNode(PropertiesEditorPage.this.getSelectedMetaclass(), propDefn)) != null) {
                    return new StructuredSelection((Object)propDefnNode);
                }
            }
            return StructuredSelection.EMPTY;
        }

        @Override
        public MedModelNode getSelectedNode(MedModelNode.ModelType type) {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            if (!selection.isEmpty()) {
                String metaclass = PropertiesEditorPage.this.getSelectedMetaclass();
                if (MedModelNode.ModelType.METACLASS == type) {
                    return PropertiesEditorPage.this.getMedEditor().getSelectionSynchronizer().getMetaclassNode(metaclass);
                }
                if (!this.metaclassViewerFlag && MedModelNode.ModelType.PROPERTY_DEFINITION == type) {
                    ModelExtensionPropertyDefinition propDefn = PropertiesEditorPage.this.getSelectedProperty();
                    return PropertiesEditorPage.this.getMedEditor().getSelectionSynchronizer().getPropertyDefinitionNode(metaclass, propDefn);
                }
            }
            return null;
        }

        @Override
        public boolean isApplicable(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                MedModelNode modelNode = (MedModelNode)selection.getFirstElement();
                if (MedModelNode.ModelType.METACLASS == modelNode.getType()) {
                    return this.metaclassViewerFlag;
                }
                if (MedModelNode.ModelType.PROPERTY_DEFINITION == modelNode.getType()) {
                    return !this.metaclassViewerFlag;
                }
            }
            return false;
        }

        @Override
        public void refresh() {
            Viewer viewer = this.metaclassViewerFlag ? PropertiesEditorPage.this.getMetaclassViewer() : PropertiesEditorPage.this.getPropertyViewer();
            viewer.refresh();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                MedModelNode modelNode = (MedModelNode)((IStructuredSelection)selection).getFirstElement();
                if (!this.metaclassViewerFlag && MedModelNode.ModelType.PROPERTY_DEFINITION == modelNode.getType()) {
                    StructuredSelection propertySelection;
                    StructuredSelection metaclassSelection = new StructuredSelection((Object)modelNode.getMetaclass());
                    if (!metaclassSelection.equals(PropertiesEditorPage.this.getMetaclassViewer().getSelection())) {
                        PropertiesEditorPage.this.getMetaclassViewer().setSelection((ISelection)metaclassSelection, true);
                    }
                    if (!(propertySelection = new StructuredSelection((Object)modelNode.getPropertyDefinition())).equals(PropertiesEditorPage.this.getPropertyViewer().getSelection())) {
                        PropertiesEditorPage.this.getPropertyViewer().setSelection((ISelection)propertySelection, true);
                    }
                    PropertiesEditorPage.this.ensureVisible(PropertiesEditorPage.this.getPropertyViewer().getControl());
                } else if (MedModelNode.ModelType.METACLASS == modelNode.getType()) {
                    StructuredSelection metaclassSelection = new StructuredSelection((Object)modelNode.getMetaclass());
                    if (this.metaclassViewerFlag) {
                        if (!metaclassSelection.equals(PropertiesEditorPage.this.getMetaclassViewer().getSelection())) {
                            PropertiesEditorPage.this.getMetaclassViewer().setSelection((ISelection)metaclassSelection, true);
                        }
                        PropertiesEditorPage.this.ensureVisible((Control)PropertiesEditorPage.this.getMetaclassViewer().getControl().getParent());
                    }
                }
            }
        }
    }
}

