/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ResourceChangeUtilities;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionParser;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionWriter;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.registry.RegistryEvent;
import org.teiid.designer.extension.registry.RegistryListener;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.UiConstants;
import org.teiid.designer.extension.ui.actions.RegistryDeploymentValidator;
import org.teiid.designer.extension.ui.actions.ShowModelExtensionRegistryViewAction;
import org.teiid.designer.extension.ui.editors.MedEditorPage;
import org.teiid.designer.extension.ui.editors.MedOutlinePage;
import org.teiid.designer.extension.ui.editors.MedSelectionSynchronizer;
import org.teiid.designer.extension.ui.editors.OverviewEditorPage;
import org.teiid.designer.extension.ui.editors.PropertiesEditorPage;
import org.teiid.designer.extension.ui.editors.SourceEditorPage;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.forms.MessageFormDialog;

public final class ModelExtensionDefinitionEditor
extends SharedHeaderFormEditor
implements IPersistableEditor,
PropertyChangeListener,
RegistryListener {
    private static final String SELECTED_PAGE = "SELECTED_PAGE";
    private boolean dirty = false;
    private boolean readOnly = false;
    private IMemento memento;
    private final FileDocumentProvider documentProvider = new FileDocumentProvider();
    private long modificationStamp = 0L;
    private Listener refreshListener;
    private ModelExtensionDefinition originalMed;
    private ModelExtensionDefinition medBeingEdited;
    private MedSelectionSynchronizer selectionSynchronizer;
    private ScrolledForm scrolledForm;
    private final Map<MedEditorPage, Integer> medEditorPages = new HashMap<MedEditorPage, Integer>(3);
    private IAction showRegistryViewAction;
    private IAction updateRegisteryAction;
    private MedOutlinePage contentOutlinePage;
    private MedResourceChangeListener medResourceListener;

    Map<MedEditorPage, Integer> accessMedEditorPages() {
        return this.medEditorPages;
    }

    ModelExtensionDefinitionEditor accessThis() {
        return this;
    }

    protected void addPages() {
        int pageNum = 0;
        try {
            int value;
            MedEditorPage page = new OverviewEditorPage(this);
            this.addPage(pageNum, (IFormPage)page);
            this.medEditorPages.put(page, pageNum);
            page = new PropertiesEditorPage(this);
            this.addPage(++pageNum, (IFormPage)page);
            this.medEditorPages.put(page, pageNum);
            page = new SourceEditorPage(this);
            this.addPage(++pageNum, (IFormPage)page);
            this.medEditorPages.put(page, pageNum);
            this.scrolledForm.setText(this.getPageText(0));
            this.addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    ModelExtensionDefinitionEditor.this.handlePageChanged();
                }
            });
            this.refreshListener = new Listener(){

                public void handleEvent(Event event) {
                    ModelExtensionDefinitionEditor.this.refreshMed();
                }
            };
            this.getContainer().addListener(26, this.refreshListener);
            int selectedPageNum = 0;
            if (this.memento != null && (value = this.memento.getInteger(SELECTED_PAGE).intValue()) != -1) {
                selectedPageNum = value;
            }
            this.setActivePage(selectedPageNum);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.errorOpeningMedEditor, e);
        }
    }

    private void contributeToMenu(IMenuManager menuMgr) {
        menuMgr.add(this.updateRegisteryAction);
        menuMgr.add(this.showRegistryViewAction);
        menuMgr.update(true);
    }

    private void contributeToToolBar(IToolBarManager toolBarMgr) {
        toolBarMgr.add(this.updateRegisteryAction);
        toolBarMgr.add(this.showRegistryViewAction);
        toolBarMgr.update(true);
    }

    private void createActions() {
        this.updateRegisteryAction = new Action(Messages.updateMedInRegistryActionText, 0x800000){

            public void run() {
                IEditorInput editorInput = ModelExtensionDefinitionEditor.this.getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    IFile medFile = ((IFileEditorInput)editorInput).getFile();
                    RegistryDeploymentValidator.deploy(medFile);
                }
            }
        };
        this.updateRegisteryAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/registry-med-update.png"));
        this.updateRegisteryAction.setToolTipText(Messages.updateMedInRegistryActionToolTip);
        this.showRegistryViewAction = new ShowModelExtensionRegistryViewAction();
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.scrolledForm = headerForm.getForm();
        this.scrolledForm.setImage(Activator.getDefault().getImage("icons/model-extension-definition-editor.png"));
        Form form = this.scrolledForm.getForm();
        this.getToolkit().decorateFormHeading(form);
        this.createActions();
        this.contributeToToolBar(form.getToolBarManager());
        this.contributeToMenu(form.getMenuManager());
    }

    private boolean isBuiltIn(IFile file) {
        String projName = file.getProject().getName();
        if (projName == null) {
            return false;
        }
        return projName.equals("BuiltInMedsProject");
    }

    private boolean isImported(IFile file) {
        IContainer parent = file.getParent();
        if (parent == null) {
            return false;
        }
        return this.isBuiltIn(file) && parent.getName().equals("imported");
    }

    private void createMed() throws Exception {
        ModelExtensionDefinitionParser parser = new ModelExtensionDefinitionParser(ExtensionPlugin.getInstance().getMedSchema());
        this.originalMed = parser.parse(this.getFile().getContents(), (ModelExtensionAssistant)ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant());
        Collection fatals = parser.getFatalErrors();
        if (fatals != null && !fatals.isEmpty()) {
            throw new RuntimeException((String)fatals.iterator().next());
        }
        if (this.medBeingEdited != null) {
            this.medBeingEdited.removeListener((PropertyChangeListener)this);
        }
        this.medBeingEdited = new ModelExtensionDefinition((ModelExtensionAssistant)ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant());
        this.medBeingEdited.setDescription(this.originalMed.getDescription());
        this.medBeingEdited.setMetamodelUri(this.originalMed.getMetamodelUri());
        this.medBeingEdited.setNamespacePrefix(this.originalMed.getNamespacePrefix());
        this.medBeingEdited.setNamespaceUri(this.originalMed.getNamespaceUri());
        this.medBeingEdited.setVersion(this.originalMed.getVersion());
        for (String modelType : this.originalMed.getSupportedModelTypes()) {
            this.medBeingEdited.addModelType(modelType);
        }
        String[] stringArray = this.originalMed.getExtendedMetaclasses();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String metaclassName = stringArray[n2];
            this.medBeingEdited.addMetaclass(metaclassName);
            for (ModelExtensionPropertyDefinition propDefn : this.originalMed.getPropertyDefinitions(metaclassName)) {
                ModelExtensionPropertyDefinition copy = (ModelExtensionPropertyDefinition)propDefn.clone();
                copy.setNamespaceProvider((NamespaceProvider)this.medBeingEdited);
                this.medBeingEdited.addPropertyDefinition(metaclassName, copy);
            }
            ++n2;
        }
        IFile medFile = this.getFile();
        if (this.isImported(medFile)) {
            this.medBeingEdited.markAsImported();
        } else if (this.isBuiltIn(medFile)) {
            this.medBeingEdited.markAsBuiltIn();
        }
        if (this.selectionSynchronizer == null) {
            this.selectionSynchronizer = new MedSelectionSynchronizer(this);
        } else {
            this.selectionSynchronizer.setMed(this.medBeingEdited);
        }
        this.medBeingEdited.addListener((PropertyChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        assert (input instanceof IFileEditorInput) : "MED Editor input is not a file";
        try {
            this.createMed();
            this.medResourceListener = new MedResourceChangeListener(this.getFile());
            ModelerCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.medResourceListener);
        }
        catch (Exception e) {
            throw new PartInitException(Messages.errorOpeningMedEditor, (Throwable)e);
        }
    }

    private void internalSave(IProgressMonitor progressMonitor) {
        IEditorInput input = this.getEditorInput();
        try {
            try {
                ModelExtensionDefinitionWriter writer = new ModelExtensionDefinitionWriter();
                String medAsString = writer.writeAsText(this.medBeingEdited);
                IDocument document = this.documentProvider.getDocument((Object)input);
                document.set(medAsString);
                this.documentProvider.aboutToChange((Object)input);
                this.documentProvider.saveDocument(progressMonitor, (Object)input, document, true);
                this.modificationStamp = this.documentProvider.getModificationStamp((Object)input);
                this.createMed();
            }
            catch (Exception e) {
                Object status = null;
                status = !(e instanceof CoreException) ? new Status(4, UiConstants.PLUGIN_ID, e.getLocalizedMessage()) : ((CoreException)e).getStatus();
                if (status == null || status.getSeverity() != 8) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.errorDialogTitle, (String)Messages.medEditorSaveError, (IStatus)status);
                }
                this.documentProvider.changed((Object)input);
                this.refreshDirtyState();
            }
        }
        finally {
            this.documentProvider.changed((Object)input);
            this.refreshDirtyState();
        }
    }

    public void dispose() {
        if (this.medEditorPages != null) {
            this.medEditorPages.clear();
        }
        this.getRegistry().removeListener((RegistryListener)this);
        if (this.medResourceListener != null) {
            ModelerCore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.medResourceListener);
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.internalSave(progressMonitor);
    }

    public void doSaveAs() {
        IProgressMonitor progressMonitor = this.getProgressMonitor();
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        dialog.setOriginalFile(this.getFile());
        dialog.create();
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IPath filePath = dialog.getResult();
        if (!"mxd".equals(filePath.getFileExtension())) {
            filePath = filePath.addFileExtension("mxd");
        }
        IWorkspace workspace = ModelerCore.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        try {
            ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
            file.create((InputStream)emptyStream, true, progressMonitor);
            this.setInput((IEditorInput)new FileEditorInput(file));
            this.internalSave(progressMonitor);
        }
        catch (Exception e) {
            Object status = null;
            status = !(e instanceof CoreException) ? new Status(4, UiConstants.PLUGIN_ID, e.getLocalizedMessage()) : ((CoreException)e).getStatus();
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.errorDialogTitle, (String)Messages.medEditorSaveError, (IStatus)status);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IContentOutlinePage.class)) {
            if (this.contentOutlinePage == null) {
                this.contentOutlinePage = new MedOutlinePage(this);
            }
            return this.contentOutlinePage;
        }
        return super.getAdapter(adapter);
    }

    protected IFile getFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    ModelExtensionDefinition getMed() {
        return this.medBeingEdited;
    }

    IMessageManager getMessageManager() {
        return this.scrolledForm.getMessageManager();
    }

    private IProgressMonitor getProgressMonitor() {
        IStatusLineManager statusLineMgr = this.getEditorSite().getActionBars().getStatusLineManager();
        return statusLineMgr == null ? null : statusLineMgr.getProgressMonitor();
    }

    ModelExtensionRegistry getRegistry() {
        return ExtensionPlugin.getInstance().getRegistry();
    }

    Shell getShell() {
        return this.getEditorSite().getShell();
    }

    public MedSelectionSynchronizer getSelectionSynchronizer() {
        return this.selectionSynchronizer;
    }

    void handlePageChanged() {
        FormPage page = (FormPage)this.getSelectedPage();
        this.scrolledForm.setText(page.getTitle());
        page.setFocus();
    }

    private void hookRefreshListener() {
        if (!this.getContainer().isDisposed()) {
            this.getContainer().addListener(26, this.refreshListener);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    boolean isSynchronized() {
        long currentModifiedStamp = this.documentProvider.getModificationStamp((Object)this.getEditorInput());
        return this.modificationStamp == currentModifiedStamp;
    }

    public void process(RegistryEvent e) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!ModelExtensionDefinitionEditor.this.getShell().isDisposed()) {
                    for (MedEditorPage medEditorPage : ModelExtensionDefinitionEditor.this.accessMedEditorPages().keySet()) {
                        medEditorPage.updateAllMessages();
                    }
                }
            }
        });
    }

    @Override
    public final void propertyChange(PropertyChangeEvent e) {
        this.refreshDirtyState();
        for (MedEditorPage page : this.medEditorPages.keySet()) {
            this.getMessageManager().setAutoUpdate(false);
            page.handlePropertyChanged(e);
            this.getMessageManager().setAutoUpdate(true);
        }
    }

    protected void refreshDirtyState() {
        boolean newValue;
        boolean bl = newValue = !this.originalMed.equals((Object)this.medBeingEdited);
        if (this.isDirty() != newValue) {
            this.dirty = newValue;
            this.getHeaderForm().dirtyStateChanged();
        }
    }

    void refreshMed() {
        if (this.getContainer() == null || this.getContainer().isDisposed()) {
            return;
        }
        if (!this.isSynchronized()) {
            this.unhookRefreshListener();
            if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)Messages.medChangedOnFileSystemDialogTitle, (Image)Activator.getDefault().getImage("icons/model-extension-definition-editor.png"), (String)NLS.bind((String)Messages.medChangedOnFileSystemDialogMsg, (Object)this.getFile().getName()))) {
                try {
                    this.getFile().refreshLocal(1, null);
                    this.modificationStamp = this.documentProvider.getModificationStamp((Object)this.getEditorInput());
                    this.createMed();
                    for (MedEditorPage page : this.medEditorPages.keySet()) {
                        page.handleMedReloaded();
                    }
                }
                catch (Exception e) {
                    UiConstants.UTIL.log((Throwable)e);
                    MessageFormDialog.openError((Shell)this.getShell(), (String)Messages.medEditorRefreshErrorTitle, (Image)Activator.getDefault().getImage("icons/model-extension-definition-editor.png"), (String)Messages.medEditorRefreshErrorMsg);
                }
            }
            this.hookRefreshListener();
        }
    }

    private void refreshReadOnlyState() {
        boolean newValue;
        ResourceAttributes attributes = this.getFile().getResourceAttributes();
        if (this.isImported(this.getFile())) {
            attributes.setReadOnly(true);
        }
        boolean bl = newValue = attributes == null ? true : attributes.isReadOnly();
        if (this.isReadOnly() != newValue) {
            this.readOnly = newValue;
            for (MedEditorPage page : this.medEditorPages.keySet()) {
                page.setResourceReadOnly(this.readOnly);
                IManagedForm mf = page.getManagedForm();
                if (mf == null) continue;
                mf.refresh();
            }
        }
    }

    public void restoreState(IMemento memento) {
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        int selectedPageNum = this.getActivePage();
        memento.putInteger(SELECTED_PAGE, selectedPageNum);
    }

    public void selectPage(MedEditorPage page) {
        if (this.getActivePageInstance() != page) {
            this.setActivePage(this.medEditorPages.get((Object)page));
        }
    }

    public void setFocus() {
        super.setFocus();
        this.refreshMed();
        this.refreshReadOnlyState();
    }

    protected void setInput(IEditorInput input) {
        if (this.getEditorInput() == null) {
            this.getRegistry().addListener((RegistryListener)this);
        } else {
            this.documentProvider.disconnect((Object)this.getEditorInput());
        }
        if (input instanceof IFileEditorInput) {
            super.setInput(input);
            try {
                this.documentProvider.connect((Object)input);
                this.modificationStamp = this.documentProvider.getModificationStamp((Object)input);
                IAnnotationModel model = this.documentProvider.getAnnotationModel((Object)input);
                model.connect(this.documentProvider.getDocument((Object)input));
                this.setPartName(this.getEditorInput().getName());
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.errorOpeningMedEditor, e);
            }
        } else {
            throw new RuntimeException(Messages.medEditorInputNotAFile);
        }
    }

    private void unhookRefreshListener() {
        if (!this.getContainer().isDisposed()) {
            this.getContainer().removeListener(26, this.refreshListener);
        }
    }

    private static class MedResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private final IFile file;

        public MedResourceChangeListener(IFile file) {
            this.file = file;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MedResourceChangeListener other = (MedResourceChangeListener)obj;
            return !(this.file == null ? other.file != null : !this.file.equals((Object)other.file));
        }

        public void resourceChanged(IResourceChangeEvent event) {
            int type = event.getType();
            if (type != 1) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (Exception e) {
                UiConstants.UTIL.log(4, (Throwable)e, e.getMessage());
            }
        }

        public boolean visit(IResourceDelta delta) {
            final Collection openEditors = UiUtil.getEditorsForFile((IFile)this.file);
            if (openEditors.isEmpty()) {
                return false;
            }
            if (!delta.getResource().equals((Object)this.file)) {
                return true;
            }
            Runnable runnable = null;
            if ((delta.getKind() & 2) != 0) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (IEditorPart editor : openEditors) {
                            editor.getSite().getPage().closeEditor(editor, false);
                        }
                    }
                };
            } else if (ResourceChangeUtilities.isContentChanged((IResourceDelta)delta)) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (IEditorPart editor : openEditors) {
                            if (!(editor instanceof ModelExtensionDefinitionEditor)) continue;
                            ((ModelExtensionDefinitionEditor)editor).refreshMed();
                        }
                    }
                };
            }
            if (runnable != null) {
                UiUtil.runInSwtThread((Runnable)runnable, (boolean)true);
            }
            return false;
        }
    }
}

