/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.definition.MedStatus;
import org.teiid.designer.extension.definition.ValidationStatus;

final class ErrorMessage
implements IMessage {
    private MedStatus status;
    private Control widget;

    ErrorMessage() {
    }

    private static int getMessageType(MedStatus medStatus) {
        if (medStatus.isError()) {
            return 3;
        }
        if (medStatus.isWarning()) {
            return 2;
        }
        if (medStatus.isInfo()) {
            return 1;
        }
        return 0;
    }

    public void clearMessage() {
        this.setMessage(null);
    }

    public Control getControl() {
        return this.widget;
    }

    public Object getData() {
        return null;
    }

    public Object getKey() {
        return this;
    }

    public String getMessage() {
        return this.status.getMessage();
    }

    public int getMessageType() {
        return ErrorMessage.getMessageType(this.status);
    }

    public String getPrefix() {
        return null;
    }

    public boolean isError() {
        return this.status.isError();
    }

    public boolean isInfo() {
        return this.status.isInfo();
    }

    public boolean isOk() {
        return this.status.isOk();
    }

    public boolean isWarning() {
        return this.status.isWarning();
    }

    public void setControl(Control newControl) {
        this.widget = newControl;
    }

    public void setMessage(String newMessage) {
        this.setStatus((MedStatus)(CoreStringUtil.isEmpty((String)newMessage) ? ValidationStatus.OK_STATUS : ValidationStatus.createErrorMessage((String)newMessage)));
    }

    public void setStatus(MedStatus status) {
        this.status = status;
    }

    public void update(IMessageManager msgMgr) {
        msgMgr.removeMessages(this.getControl());
        if (!this.status.isOk()) {
            if (this.status.isMulti()) {
                int i = 0;
                for (MedStatus medStatus : this.status.getChildren()) {
                    msgMgr.addMessage((Object)i++, medStatus.getMessage(), null, ErrorMessage.getMessageType(medStatus), this.getControl());
                }
            } else {
                msgMgr.addMessage(this.getKey(), this.getMessage(), null, this.getMessageType(), this.getControl());
            }
        }
    }
}

