/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.definition.ExtendableMetaclassNameProvider;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.editors.ErrorMessage;

final class EditMetaclassDialog
extends FormDialog {
    private ScrolledForm scrolledForm;
    private Button btnOk;
    private final List<String> currentExtendedMetaclasses;
    private String selectedMetaclassName;
    private TreeViewer treeViewer;
    private MetaclassTreeContentProvider treeContentProvider;
    ExtendableMetaclassNameProvider metaclassNameProvider;
    private String metaclassNameBeingEdited;
    private final ErrorMessage metaclassError;

    public EditMetaclassDialog(Shell parentShell, ExtendableMetaclassNameProvider metaclassNameProvider, List<String> currentExtendedMetaclasses) {
        super(parentShell);
        this.metaclassNameProvider = metaclassNameProvider;
        this.treeContentProvider = new MetaclassTreeContentProvider(metaclassNameProvider, currentExtendedMetaclasses);
        this.currentExtendedMetaclasses = new ArrayList<String>(currentExtendedMetaclasses);
        this.metaclassError = new ErrorMessage();
    }

    public EditMetaclassDialog(Shell parentShell, ExtendableMetaclassNameProvider metaclassNameProvider, List<String> currentExtendedMetaclasses, String metaclassNameBeingEdited) {
        this(parentShell, metaclassNameProvider, currentExtendedMetaclasses);
        CoreArgCheck.isNotNull((Object)metaclassNameBeingEdited, (String)"metaclassNameBeingEdited is null");
        this.metaclassNameBeingEdited = metaclassNameBeingEdited;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isEditMode()) {
            newShell.setText(Messages.editMetaclassDialogTitle);
        } else {
            newShell.setText(Messages.addMetaclassDialogTitle);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(Messages.metaclassDialogTitle);
        this.scrolledForm.setImage(Activator.getDefault().getImage("icons/model-extension-definition-editor.png"));
        this.scrolledForm.setMessage(Messages.metaclassDialogMessage, 0);
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        Composite body = this.scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout(1, true));
        Tree tree = toolkit.createTree(body, 2820);
        tree.setLayoutData((Object)new GridLayout());
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)tree.getLayoutData()).heightHint = tree.getItemHeight() * 10;
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeContentProvider);
        this.treeViewer.setInput((Object)this);
        this.treeViewer.setSelection(null, false);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String selectedMetaclassStr = EditMetaclassDialog.this.getSelectedMetaclass();
                EditMetaclassDialog.this.handleMetaclassNameSelectionChanged(selectedMetaclassStr);
            }
        });
    }

    private String getSelectedMetaclass() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        return selection.isEmpty() ? null : (String)selection.getFirstElement();
    }

    public String getSelectedMetaclassName() {
        return this.selectedMetaclassName;
    }

    void handleMetaclassNameSelectionChanged(String newMetaclassName) {
        this.selectedMetaclassName = newMetaclassName;
        if (CoreStringUtil.isEmpty((String)this.selectedMetaclassName)) {
            this.metaclassError.setMessage(Messages.editMetaclassNothingSelected);
        } else if (this.currentExtendedMetaclasses.contains(this.selectedMetaclassName)) {
            this.metaclassError.setMessage(Messages.editMetaclassAlreadyExtendedMetaclassSelected);
            if (this.isEditMode() && this.selectedMetaclassName.equals(this.metaclassNameBeingEdited)) {
                this.metaclassError.setMessage(Messages.editMetaclassEditedMetaclassSelected);
            }
        } else {
            this.metaclassError.clearMessage();
        }
        this.updateState();
    }

    private boolean isEditMode() {
        return !CoreStringUtil.isEmpty((String)this.metaclassNameBeingEdited);
    }

    private void updateState() {
        String errorMsg = this.metaclassError.getMessage();
        int imageType = 0;
        if (CoreStringUtil.isEmpty((String)errorMsg)) {
            boolean enable = true;
            if (this.btnOk.getEnabled() != enable) {
                this.btnOk.setEnabled(enable);
            }
            errorMsg = Messages.metaclassDialogMessage;
        } else {
            this.btnOk.setEnabled(true);
            imageType = 0;
        }
        this.scrolledForm.setMessage(errorMsg, imageType);
    }

    class MetaclassTreeContentProvider
    extends LabelProvider
    implements ITreeContentProvider {
        private ExtendableMetaclassNameProvider metaclassNameProvider;

        public MetaclassTreeContentProvider(ExtendableMetaclassNameProvider metaclassNameProvider, List<String> currentExtendedClasses) {
            this.metaclassNameProvider = metaclassNameProvider;
        }

        public Object[] getChildren(Object parentElement) {
            return this.metaclassNameProvider.getExtendableMetaclassChildren(parentElement.toString());
        }

        public Object getParent(Object element) {
            return this.metaclassNameProvider.getParent(element.toString());
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.metaclassNameProvider.getExtendableMetaclassRoots();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.metaclassNameProvider.getLabelText(element.toString());
        }
    }
}

