/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateSupport;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.esb.core.model.impl.ContentBasedRouter;

public class AddContentBasedRouterSupport
extends DefaultCreateSupport {
    protected DefaultWizardDataValidator cbrValidator = new CBRValidator();

    protected void finish() throws XModelException {
        String ruleSet;
        String entity = this.getEntityName();
        Properties p = this.extractStepData(0);
        String cbrAlias = this.action.getProperty("cbrAlias");
        if (cbrAlias != null) {
            p.setProperty(ContentBasedRouter.ATTR_CBR_ALIAS, cbrAlias);
        }
        if ((ruleSet = p.getProperty(ContentBasedRouter.ATTR_RULE_SET)) == null || ruleSet.length() == 0) {
            p.remove(ContentBasedRouter.ATTR_RULE_RELOAD);
        }
        XModelObject action = XModelObjectLoaderUtil.createValidObject((XModel)this.getTarget().getModel(), (String)entity, (Properties)p);
        DefaultCreateHandler.addCreatedObject((XModelObject)this.getTarget(), (XModelObject)action, (Properties)this.getProperties());
    }

    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        if (ContentBasedRouter.ATTR_RULE_RELOAD.equals(name)) {
            String ruleSet = values.getProperty(ContentBasedRouter.ATTR_RULE_SET);
            if (ruleSet == null || ruleSet.trim().length() == 0) {
                return false;
            }
        } else if (ContentBasedRouter.ATTR_RULE_LANGUAGE.equals(name)) {
            String alias = values.getProperty(ContentBasedRouter.ATTR_CBR_ALIAS);
            if (alias == null) {
                alias = this.action.getProperty("cbrAlias");
            }
            if (this.isRegexOrXPathOrEmpty(alias)) {
                return false;
            }
        }
        return true;
    }

    private boolean isRegexOrXPathOrEmpty(String alias) {
        return alias == null || alias.length() == 0 || "Regex".equalsIgnoreCase(alias) || "Xpath".equalsIgnoreCase(alias);
    }

    public WizardDataValidator getValidator(int step) {
        this.cbrValidator.setSupport((SpecialWizardSupport)this, step);
        return this.cbrValidator;
    }

    class CBRValidator
    extends DefaultWizardDataValidator {
        CBRValidator() {
        }

        public void validate(Properties data) {
            String ruleSet;
            this.message = null;
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String alias = data.getProperty(ContentBasedRouter.ATTR_CBR_ALIAS);
            if ("Drools".equalsIgnoreCase(alias) && ((ruleSet = data.getProperty(ContentBasedRouter.ATTR_RULE_SET)) == null || ruleSet.length() == 0)) {
                this.message = "Rule Set must be set for Drools Router";
                return;
            }
        }
    }
}

