/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.wizards.ModelerZipExporter;
import org.xml.sax.SAXException;

public class ModelerProjectZipOperation
implements IRunnableWithProgress {
    private static final String EXPORT_TITLE = ModelerProjectZipOperation.getString("zipExportTitle");
    private static final String ZIPPING_PROBLEM = "zippingProblem";
    private static final String ZIPPING_RESOURCE_PROBLEM = "zippingResourceProblem";
    private static final String CANNOT_OPEN_ZIP = ModelerProjectZipOperation.getString("cannotOpenZip");
    private static final String CANNOT_CLOSE_ZIP = ModelerProjectZipOperation.getString("cannotCloseZip");
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ModelerProjectZipOperation.class);
    private ModelerZipExporter exporter;
    private String destinationFilename;
    private IProgressMonitor monitor;
    private List resourcesToExport;
    private IResource resource;
    private List errorTable = new ArrayList(1);
    private boolean useCompression = true;
    private boolean createLeadupStructure = true;
    private boolean clearSourceConnectionInfo = false;

    private static String getString(String id) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object obj) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, obj);
    }

    public ModelerProjectZipOperation(List resources, String filename, boolean clearSourceConnectionInfo) {
        Iterator elementsEnum = resources.iterator();
        while (elementsEnum.hasNext()) {
            IResource currentResource = (IResource)elementsEnum.next();
            if (!this.isDescendent(resources, currentResource)) continue;
            elementsEnum.remove();
        }
        this.resourcesToExport = resources;
        this.destinationFilename = filename;
        this.clearSourceConnectionInfo = clearSourceConnectionInfo;
    }

    protected void addError(String message, Throwable e) {
        this.errorTable.add(new Status(4, "org.eclipse.ui", 0, message, e));
    }

    protected int countChildrenOf(IResource resource) throws CoreException {
        if (resource.getType() == 1) {
            return 1;
        }
        int count = 0;
        if (resource.isAccessible()) {
            IResource[] children = ((IContainer)resource).members();
            int i = 0;
            while (i < children.length) {
                count += this.countChildrenOf(children[i]);
                ++i;
            }
        }
        return count;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        Iterator resources = this.resourcesToExport.iterator();
        while (resources.hasNext()) {
            result += this.countChildrenOf((IResource)resources.next());
        }
        return result;
    }

    protected void exportResource(IResource resource) throws InterruptedException {
        this.exportResource(resource, 1);
    }

    protected void exportResource(IResource resource, int leadupDepth) throws InterruptedException {
        if (!resource.isAccessible()) {
            return;
        }
        if (resource.getType() == 1) {
            IPath fullPath = resource.getFullPath();
            String destinationName = this.createLeadupStructure ? fullPath.makeRelative().toString() : fullPath.removeFirstSegments(fullPath.segmentCount() - leadupDepth).toString();
            this.monitor.subTask(destinationName);
            try {
                this.exporter.write((IFile)resource, destinationName);
            }
            catch (IOException e) {
                this.addError(ModelerProjectZipOperation.getString(ZIPPING_RESOURCE_PROBLEM, new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            catch (CoreException e) {
                this.addError(ModelerProjectZipOperation.getString(ZIPPING_RESOURCE_PROBLEM, new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            catch (SAXException e) {
                this.addError(ModelerProjectZipOperation.getString(ZIPPING_RESOURCE_PROBLEM, new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            catch (ParserConfigurationException e) {
                this.addError(ModelerProjectZipOperation.getString(ZIPPING_RESOURCE_PROBLEM, new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            catch (TransformerConfigurationException e) {
                this.addError(ModelerProjectZipOperation.getString(ZIPPING_RESOURCE_PROBLEM, new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            catch (TransformerException e) {
                this.addError(ModelerProjectZipOperation.getString(ZIPPING_RESOURCE_PROBLEM, new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            catch (TransformerFactoryConfigurationError e) {
                this.addError(ModelerProjectZipOperation.getString(ZIPPING_RESOURCE_PROBLEM, new Object[]{resource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            this.monitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        } else {
            IResource[] children = null;
            try {
                children = ((IContainer)resource).members();
            }
            catch (CoreException e) {
                this.addError(ModelerProjectZipOperation.getString(ZIPPING_RESOURCE_PROBLEM, new Object[]{resource.getFullPath()}), e);
            }
            int i = 0;
            while (i < children.length) {
                this.exportResource(children[i], leadupDepth + 1);
                ++i;
            }
        }
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        for (IResource currentResource : this.resourcesToExport) {
            this.exportResource(currentResource);
        }
    }

    public List getResult() {
        return this.errorTable;
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ui", 0, errors, ModelerProjectZipOperation.getString(ZIPPING_PROBLEM), null);
    }

    protected void initialize() throws IOException {
        this.exporter = new ModelerZipExporter(this.destinationFilename, this.useCompression, this.clearSourceConnectionInfo);
    }

    protected boolean isDescendent(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.monitor = monitor;
        try {
            this.initialize();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e, ModelerProjectZipOperation.getString(CANNOT_OPEN_ZIP, new Object[]{e.getMessage()}));
        }
        try {
            int totalWork = -1;
            try {
                totalWork = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException coreException) {}
            monitor.beginTask(EXPORT_TITLE, totalWork);
            if (this.resourcesToExport == null) {
                this.exportResource(this.resource);
            } else {
                this.exportSpecifiedResources();
            }
            try {
                this.exporter.finished();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e, CANNOT_CLOSE_ZIP);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void setCreateLeadupStructure(boolean value) {
        this.createLeadupStructure = value;
    }

    public void setUseCompression(boolean value) {
        this.useCompression = value;
    }
}

