/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.util.ModelStatisticsVisitor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;

public class ModelStatisticsDialog
extends Dialog {
    private static final String TITLE = UiConstants.Util.getString("ModelStatisticsDialog.title", new Object[0]);
    private static final String LF = "\r\n";
    private ModelStatisticsVisitor visitor;
    private ModelResource modelResource;
    private StyledText text;
    private HashMap typeMap;

    public ModelStatisticsDialog(Shell shell, ModelStatisticsVisitor visitor, ModelResource resource) {
        super(shell);
        this.visitor = visitor;
        this.modelResource = resource;
        this.buildTypeMap();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.text = new StyledText(composite, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 400;
        this.text.setLayoutData((Object)gd);
        this.text.setEditable(false);
        this.text.setWordWrap(false);
        this.text.setTabs(10);
        String metamodelName = null;
        try {
            metamodelName = this.modelResource.getPrimaryMetamodelDescriptor().getDisplayName();
        }
        catch (Exception e) {
            UiConstants.Util.log((Throwable)e);
        }
        String header1 = UiConstants.Util.getString("ModelStatisticsDialog.header1", (Object)this.modelResource.getItemName());
        StyleRange headerRange = new StyleRange();
        headerRange.start = 0;
        headerRange.length = header1.length();
        headerRange.fontStyle = 1;
        StringBuffer buff = new StringBuffer(header1);
        buff.append(LF);
        buff.append(LF);
        buff.append('\t');
        buff.append(UiConstants.Util.getString("ModelStatisticsDialog.header2", (Object)metamodelName));
        buff.append(LF);
        buff.append(LF);
        TreeSet sortedNames = new TreeSet(this.typeMap.keySet());
        Iterator iter = sortedNames.iterator();
        while (iter.hasNext()) {
            EClass eClass = (EClass)this.typeMap.get(iter.next());
            int count = this.visitor.getCount(eClass);
            buff.append('\t');
            buff.append(count);
            buff.append('\t');
            if (count == 1) {
                buff.append(CoreStringUtil.computeDisplayableForm((String)eClass.getName()));
            } else {
                buff.append(CoreStringUtil.computePluralForm((String)CoreStringUtil.computeDisplayableForm((String)eClass.getName())));
            }
            buff.append(LF);
        }
        this.text.setText(buff.toString());
        this.text.setStyleRange(headerRange);
        return composite;
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
        super.getShell().setText(TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void buildTypeMap() {
        this.typeMap = new HashMap();
        for (EClass eClass : this.visitor.getEClassesFound()) {
            this.typeMap.put(eClass.getName(), eClass);
        }
    }
}

