/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IStatus;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.viewsupport.ModelNameChecker;

public abstract class ModelNameUtil {
    public static final int IGNORE_CASE = 1;
    public static final int NO_EXISTING_MODEL_AT_LOCATION = 2;
    public static final int NO_DUPLICATE_MODEL_NAMES = 4;
    public static final int NO_DUPLICATE_MODEL_NAMES_OTHER_THAN_LOCATION = 8;

    public static IStatus validate(String proposedModelName, String fileExtension, IContainer resource, int flags) {
        ModelNameChecker checker = new ModelNameChecker(proposedModelName, fileExtension, resource, flags);
        return checker.validate();
    }

    public static IStatus validate(String proposedModelName, String fileExtension, int flags) {
        ModelNameChecker checker = new ModelNameChecker(proposedModelName, fileExtension, null, flags);
        return checker.validate();
    }

    public static String getNewUniqueModelName(String proposedNameWithoutExtension, IContainer project) {
        ModelNameChecker checker = new ModelNameChecker(proposedNameWithoutExtension, ".xmi", project, 4);
        IStatus status = checker.validate();
        if (status.getSeverity() == 4) {
            int count = 1;
            String newName = String.valueOf(proposedNameWithoutExtension) + '_' + Integer.toString(count);
            while (status.getSeverity() == 4 && count < 20) {
                checker = new ModelNameChecker(newName, ".xmi", project, 4);
                ++count;
                if (checker.validate().getSeverity() != 4) {
                    return newName;
                }
                newName = String.valueOf(proposedNameWithoutExtension) + '_' + Integer.toString(count);
            }
        }
        return proposedNameWithoutExtension;
    }

    public static interface MESSAGES {
        public static final String INVALID_MODEL_NAME = String.valueOf(UiConstants.Util.getString("ModelNameUtil.invalidModelName", new Object[0])) + " ";
        public static final String INVALID_SOURCE_MODEL_NAME = String.valueOf(UiConstants.Util.getString("ModelNameUtil.invalidSourceModelName", new Object[0])) + " ";
        public static final String INVALID_VIEW_MODEL_NAME = String.valueOf(UiConstants.Util.getString("ModelNameUtil.invalidViewModelName", new Object[0])) + " ";
        public static final String INVALID_SCHEMA_FILE_NAME = String.valueOf(UiConstants.Util.getString("ModelNameUtil.invalidSchemaFileName", new Object[0])) + " ";
    }
}

