/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;

public class ModelNameChecker
extends ModelNameUtil
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ModelNameChecker.class);
    private boolean ignoreCase = false;
    private boolean noDuplicateModelNames = false;
    private boolean noExistingModelNameAtLocation = false;
    private boolean noDuplicateModelNamesOtherThanLocation = false;
    private String originalName;
    private String originalNameWithoutExtension;
    private String originalFileExtension;
    private IProject project;
    private IContainer targetContainer;
    private IStatus status = Status.OK_STATUS;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, String param) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, (Object)param);
    }

    public ModelNameChecker(String modelName, String fileExtension, IContainer targetContainer, int flags) {
        CoreArgCheck.isNotNull((Object)modelName, (String)"modelName");
        CoreArgCheck.isNotNull((Object)fileExtension, (String)"fileExtension");
        this.setFlags(flags);
        if (this.noExistingModelNameAtLocation) {
            CoreArgCheck.isNotNull((Object)targetContainer, (String)"resource");
        }
        this.originalName = modelName;
        this.originalFileExtension = fileExtension;
        this.targetContainer = targetContainer;
        if (this.targetContainer != null) {
            this.project = this.targetContainer.getProject();
        }
    }

    public IStatus validate() {
        this.checkNameAndExtension();
        if (this.isOK()) {
            if (this.noExistingModelNameAtLocation && this.doesModelNameExistAtLocation(this.targetContainer)) {
                this.createErrorStatus(ModelNameChecker.getString("sameNameModelExistsInProjectMessage", this.originalName));
            }
            if (this.isOK() && this.noDuplicateModelNames && this.project != null && this.doesModelNameExistInContainer((IContainer)this.project)) {
                this.createErrorStatus(ModelNameChecker.getString("sameNameModelExistsInProjectMessage", this.originalName));
            }
        }
        return this.status;
    }

    private void setFlags(int flags) {
        if ((1 & flags) == 1) {
            this.ignoreCase = true;
        }
        if ((2 & flags) == 2) {
            this.noExistingModelNameAtLocation = true;
        }
        if ((4 & flags) == 4) {
            this.noDuplicateModelNames = true;
        }
        if ((8 & flags) == 8) {
            this.noDuplicateModelNamesOtherThanLocation = true;
        }
    }

    private void createErrorStatus(String message) {
        this.status = new Status(4, "org.teiid.designer.ui", message);
    }

    private boolean isOK() {
        return this.status.getSeverity() < 4;
    }

    private void checkNameAndExtension() {
        String finalProposedName = this.originalName;
        if (this.ignoreCase) {
            finalProposedName = this.originalName.toUpperCase();
        }
        String finalFileExtension = this.originalFileExtension;
        if (this.ignoreCase) {
            finalFileExtension = this.originalFileExtension.toUpperCase();
        }
        if (finalProposedName == null || finalProposedName.equals("")) {
            this.createErrorStatus(ModelNameChecker.getString("zeroLengthFileMessage"));
            return;
        }
        boolean removedValidExtension = false;
        if (finalProposedName.endsWith(finalFileExtension)) {
            finalProposedName = finalProposedName.substring(0, finalProposedName.lastIndexOf(finalFileExtension));
            removedValidExtension = true;
        }
        if (finalProposedName.indexOf(46) != -1) {
            if (!removedValidExtension) {
                this.createErrorStatus(ModelNameChecker.getString("illegalExtensionMessage", finalFileExtension));
                return;
            }
        } else {
            StringNameValidator nameValidator = new StringNameValidator();
            String result = nameValidator.checkValidName(finalProposedName);
            if (result != null) {
                this.createErrorStatus(result);
            }
        }
        this.originalNameWithoutExtension = finalProposedName;
    }

    private boolean doesResourceNameMatch(IResource resource) {
        if (this.ignoreCase) {
            String nameMinusExt = resource.getName().toUpperCase();
            if (nameMinusExt.endsWith(this.originalFileExtension.toUpperCase())) {
                nameMinusExt = nameMinusExt.substring(0, nameMinusExt.lastIndexOf(this.originalFileExtension.toUpperCase()));
            }
            if (nameMinusExt.equals(this.originalNameWithoutExtension.toUpperCase())) {
                return true;
            }
        } else {
            String nameMinusExt = resource.getName();
            if (nameMinusExt.endsWith(this.originalFileExtension)) {
                nameMinusExt = nameMinusExt.substring(0, nameMinusExt.lastIndexOf(this.originalFileExtension));
            }
            if (nameMinusExt.equalsIgnoreCase(this.originalNameWithoutExtension)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doesModelNameExistAtLocation(IContainer container) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource iRes = iResourceArray[n2];
                boolean result = this.doesResourceNameMatch(iRes);
                if (result) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            UiConstants.Util.log(4, (Throwable)ex, ex.getMessage());
        }
        return false;
    }

    private boolean doesModelNameExistInContainer(IContainer container) {
        boolean result = false;
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iRes = iResourceArray[n2];
                if (this.noDuplicateModelNamesOtherThanLocation && iRes == this.targetContainer || !(result = iRes instanceof IContainer ? this.doesModelNameExistInContainer((IContainer)iRes) : this.doesResourceNameMatch(iRes))) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (CoreException ex) {
            UiConstants.Util.log(4, (Throwable)ex, ex.getMessage());
        }
        return result;
    }
}

