/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.IDiagramHelper;

public abstract class DiagramHelperManager {
    private static HashMap diagramHelpers;
    private static boolean helpersLoaded;

    static {
        helpersLoaded = false;
    }

    public static boolean canRename(Diagram diagram) {
        if (DiagramHelperManager.getDiagramHelper(diagram) != null) {
            return DiagramHelperManager.getDiagramHelper(diagram).canRename(diagram);
        }
        return false;
    }

    public static boolean canCopy(Diagram diagram) {
        if (DiagramHelperManager.getDiagramHelper(diagram) != null) {
            return DiagramHelperManager.getDiagramHelper(diagram).canCopy(diagram);
        }
        return false;
    }

    public static boolean canCut(Diagram diagram) {
        if (DiagramHelperManager.getDiagramHelper(diagram) != null) {
            return DiagramHelperManager.getDiagramHelper(diagram).canCut(diagram);
        }
        return false;
    }

    public static boolean canDelete(Diagram diagram) {
        if (DiagramHelperManager.getDiagramHelper(diagram) != null) {
            return DiagramHelperManager.getDiagramHelper(diagram).canDelete(diagram);
        }
        return false;
    }

    public static boolean canClone(Diagram diagram) {
        if (DiagramHelperManager.getDiagramHelper(diagram) != null) {
            return DiagramHelperManager.getDiagramHelper(diagram).canClone(diagram);
        }
        return false;
    }

    public static boolean canPaste(Diagram diagram, EObject pasteParent) {
        if (DiagramHelperManager.getDiagramHelper(diagram) != null) {
            return DiagramHelperManager.getDiagramHelper(diagram).canPaste(diagram, pasteParent);
        }
        return false;
    }

    public static void paste(Diagram diagram, EObject pasteParent) {
        if (DiagramHelperManager.getDiagramHelper(diagram) != null) {
            DiagramHelperManager.getDiagramHelper(diagram).paste(diagram, pasteParent);
        }
    }

    public static boolean canCreate(Diagram diagram) {
        if (DiagramHelperManager.getDiagramHelper(diagram) != null) {
            return DiagramHelperManager.getDiagramHelper(diagram).canCreate(diagram);
        }
        return false;
    }

    public static IDiagramHelper getDiagramHelper(Diagram diagram) {
        if (!helpersLoaded) {
            DiagramHelperManager.loadDiagramHelperExtensions();
        }
        if (diagramHelpers != null) {
            return (IDiagramHelper)diagramHelpers.get(diagram.getType());
        }
        return null;
    }

    private static void loadDiagramHelperExtensions() {
        diagramHelpers = new HashMap();
        helpersLoaded = true;
        String id = "diagramHelper";
        String classTag = "class";
        String className = "name";
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", id);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    Object helper;
                    if (elements[j].getName().equals(classTag) && (helper = elements[j].createExecutableExtension(className)) instanceof IDiagramHelper) {
                        String diagramType = elements[j].getAttribute("diagramType");
                        diagramHelpers.put(diagramType, helper);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("ModelerActionService.configurationErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
    }
}

