/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.ClosedProjectFilter;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.DesignerProperties;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class DefineModelProjectDialog
extends TitleAreaDialog
implements IChangeListener,
UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DefineModelProjectDialog.class);
    private IProject project;
    private ILabelProvider labelProvider = new ModelExplorerLabelProvider();
    private Button newProjectButton;
    private Button browseButton;
    private Text selectedProjectText;
    DesignerProperties designerProperties;

    public DefineModelProjectDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public DefineModelProjectDialog(Shell parentShell, Properties properties) {
        this(parentShell);
        this.designerProperties = (DesignerProperties)properties;
    }

    public boolean close() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Util.getString(String.valueOf(PREFIX) + "title", new Object[0]));
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(pnlOuter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)new GridData(1808));
        this.setTitle(Util.getString(String.valueOf(PREFIX) + "subTitle", new Object[0]));
        this.setMessage(Util.getString(String.valueOf(PREFIX) + "initialMessage", new Object[0]));
        Label label = WidgetFactory.createLabel((Composite)panel, (String)Util.getString(String.valueOf(PREFIX) + "modelProject", new Object[0]));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.selectedProjectText = WidgetFactory.createTextField((Composite)panel, (int)768);
        this.selectedProjectText.setToolTipText(Util.getString(String.valueOf(PREFIX) + "projectNameTooltip", new Object[0]));
        this.selectedProjectText.setEditable(false);
        this.selectedProjectText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedProjectText.setForeground(Display.getCurrent().getSystemColor(10));
        this.newProjectButton = WidgetFactory.createButton((Composite)panel, (String)Util.getString(String.valueOf(PREFIX) + "newButton", new Object[0]));
        this.newProjectButton.setToolTipText(Util.getString(String.valueOf(PREFIX) + "newButtonTooltip", new Object[0]));
        this.newProjectButton.setEnabled(true);
        this.newProjectButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.newProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineModelProjectDialog.this.handleNewProjectPressed();
            }
        });
        this.browseButton = WidgetFactory.createButton((Composite)panel, (String)Util.getString(String.valueOf(PREFIX) + "browseButton", new Object[0]));
        this.browseButton.setToolTipText(Util.getString(String.valueOf(PREFIX) + "browseButtonTooltip", new Object[0]));
        this.browseButton.setEnabled(true);
        this.browseButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineModelProjectDialog.this.handleBrowseWorkspaceForObjectPressed();
            }
        });
        return panel;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.designerProperties != null) {
            this.project = DesignerPropertiesUtil.getProject(this.designerProperties);
            if (this.project != null) {
                this.selectedProjectText.setText(this.project.getName());
            }
            this.updateState();
        }
        return control;
    }

    public IProject getProject() {
        return this.project;
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    private void updateState() {
        IStatus status = Status.OK_STATUS;
        if (status.getSeverity() == 4) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(Util.getString(String.valueOf(PREFIX) + "okMsg", new Object[0]));
        }
    }

    private void handleNewProjectPressed() {
        Properties properties = this.designerProperties;
        if (properties == null) {
            properties = new Properties();
        } else {
            ((Properties)properties).clear();
        }
        ModelerUiViewUtils.launchWizard("newModelProject", (IStructuredSelection)new StructuredSelection(), properties, true);
        this.project = DesignerPropertiesUtil.getProject(properties);
        if (this.project != null) {
            this.selectedProjectText.setText(this.project.getName());
        }
    }

    private void handleBrowseWorkspaceForObjectPressed() {
        ModelWorkspaceDialog sdDialog = this.createProjectSelector();
        sdDialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            IProject selectedProject = (IProject)selections[0];
            if (this.project != null && selectedProject != null && selectedProject.getName().equals(this.project.getName())) {
                return;
            }
            this.designerProperties.clear();
            this.project = selectedProject;
            String pName = this.project != null ? this.project.getName() : "";
            this.selectedProjectText.setText(pName);
            DesignerPropertiesUtil.setProjectName(this.designerProperties, pName);
            if (this.project != null) {
                DesignerPropertiesUtil.setProjectStatus(this.designerProperties, "openProjectsExist");
                try {
                    IResource[] iResourceArray = this.project.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource res = iResourceArray[n2];
                        if (res instanceof IContainer) {
                            if (((IContainer)res).getName().equalsIgnoreCase("sources")) {
                                DesignerPropertiesUtil.setSourcesFolderName(this.designerProperties, "sources");
                            } else if (((IContainer)res).getName().equalsIgnoreCase("views")) {
                                DesignerPropertiesUtil.setViewsFolderName(this.designerProperties, "views");
                            }
                        }
                        ++n2;
                    }
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
            }
            this.updateState();
        }
    }

    public ModelWorkspaceDialog createProjectSelector() {
        ModelWorkspaceDialog result = new ModelWorkspaceDialog(this.getShell(), null, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        String title = Util.getString(String.valueOf(PREFIX) + "selectionDialog.title", new Object[0]);
        String message = Util.getString(String.valueOf(PREFIX) + "selectionDialog.message", new Object[0]);
        result.setTitle(title);
        result.setMessage(message);
        result.setAllowMultiple(false);
        result.setInput(ModelerCore.getWorkspace().getRoot());
        result.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || selection[0] == null || !(selection[0] instanceof IProject) || !DotProjectUtils.isModelerProject((IProject)((IProject)selection[0]))) {
                    String msg = Util.getString(String.valueOf(PREFIX) + "selectionDialog.invalidSelection", new Object[0]);
                    return new StatusInfo("org.teiid.designer.ui", 4, msg);
                }
                return new StatusInfo("org.teiid.designer.ui");
            }
        });
        return result;
    }
}

