/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.teiid.designer.ui.common.eventsupport.SelectionProvider;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.table.ModelObjectTableModel;
import org.teiid.designer.ui.table.ModelRowElement;

public class ModelObjectTableSelectionManager
extends SelectionProvider
implements ISelectionChangedListener {
    private TableViewer tableViewer;
    private ModelObjectTableModel tableModel;
    private boolean isSelecting;

    ModelObjectTableSelectionManager(TableViewer tableViewer, ModelObjectTableModel tableModel) {
        this.tableViewer = tableViewer;
        this.tableModel = tableModel;
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void setName(String name) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isSelecting) {
            return;
        }
        this.isSelecting = true;
        try {
            if (event.getSource() instanceof TableViewer) {
                List rowList = SelectionUtilities.getSelectedObjects((ISelection)event.getSelection());
                ArrayList<EObject> objectList = new ArrayList<EObject>(rowList.size());
                for (ModelRowElement mre : rowList) {
                    objectList.add(mre.getModelObject());
                }
                this.setSelection((ISelection)new StructuredSelection(objectList), true);
            } else {
                this.setSelection(event.getSelection());
            }
        }
        finally {
            this.isSelecting = false;
        }
    }

    public void setSelection(ISelection selection) {
        ISelection modelRowSelection = this.createModelRowElementSelection(selection);
        if (!modelRowSelection.isEmpty()) {
            this.setSelection(selection, false);
            this.tableViewer.setSelection(modelRowSelection, true);
            Control ctrl = this.tableViewer.getControl();
            TabFolder tabFolder = (TabFolder)ctrl.getParent();
            TabItem[] items = tabFolder.getItems();
            int ndx = items.length;
            while (--ndx >= 0) {
                TabItem item = items[ndx];
                if (item.getControl() != ctrl) continue;
                tabFolder.setSelection(ndx);
            }
        }
    }

    private ISelection createModelRowElementSelection(ISelection modelObjectSelection) {
        List objectList = SelectionUtilities.getSelectedEObjects((ISelection)modelObjectSelection);
        ArrayList<ModelRowElement> rowList = new ArrayList<ModelRowElement>(objectList.size());
        Iterator iter = objectList.iterator();
        while (iter.hasNext()) {
            ModelRowElement mre = this.tableModel.getRowElementForInstance((EObject)iter.next());
            if (mre == null) continue;
            rowList.add(mre);
        }
        return new StructuredSelection(rowList);
    }
}

