/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.rename;

import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.teiid.designer.core.refactor.IRefactorModelHandler;
import org.teiid.designer.core.refactor.PathPair;
import org.teiid.designer.core.refactor.RelatedResourceFinder;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.refactor.AbstractResourcesRefactoring;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.rename.RenameResourceCompositeChange;
import org.teiid.designer.ui.refactor.rename.RenameResourceDescriptor;

public class RenameResourceRefactoring
extends AbstractResourcesRefactoring {
    private String newName;

    public RenameResourceRefactoring(IResource selectedResource) {
        super(RefactorResourcesUtils.getString("RenameRefactoring.title", new Object[0]), Collections.singletonList(selectedResource));
    }

    IResource getResource() {
        return this.getResources().get(0);
    }

    public String getNewResourceName() {
        return this.newName;
    }

    public void setNewResourceName(String newName) {
        this.newName = newName;
    }

    @Override
    protected void checkResource(IResource resource, IProgressMonitor progressMonitor, RefactoringStatus status) {
        String readOnlyStatusMsg = this.getResources().contains(resource) ? RefactorResourcesUtils.getString("ResourcesRefactoring.readOnlyResourceError", resource.getName()) : RefactorResourcesUtils.getString("ResourcesRefactoring.readOnlyRelatedResourceError", resource.getName());
        RefactorResourcesUtils.checkResourceExists(resource, status);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkResourceSynched(resource, status);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkResourceWritable(resource, status, 4, readOnlyStatusMsg);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkExtensionManager(resource, IRefactorModelHandler.RefactorType.MOVE, progressMonitor, status);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkModelResourceWritable(resource, status, 4, readOnlyStatusMsg);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkSavedResource(resource, status);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkOpenEditors(resource, status);
    }

    public RefactoringStatus checkInitialConditions(final IProgressMonitor progressMonitor) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            progressMonitor.beginTask(RefactorResourcesUtils.getString("RenameRefactoring.initialConditions", new Object[0]), 1);
            this.checkResourcesNotEmpty(status);
            for (IResource resource : this.getResources()) {
                this.checkResource(resource, progressMonitor, status);
                if (!status.isOK()) {
                    break;
                }
                RefactorResourcesUtils.AbstractResourceCallback callback = new RefactorResourcesUtils.AbstractResourceCallback(){

                    @Override
                    public void checkValidFile(IFile relatedFile, RefactoringStatus validityStatus) {
                        RenameResourceRefactoring.this.checkResource((IResource)relatedFile, progressMonitor, validityStatus);
                    }
                };
                RefactorResourcesUtils.calculateRelatedResources(resource, status, callback, RelatedResourceFinder.Relationship.DEPENDENT);
            }
        }
        finally {
            progressMonitor.done();
        }
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        this.clearChanges();
        RefactoringStatus status = new RefactoringStatus();
        try {
            progressMonitor.beginTask(RefactorResourcesUtils.getString("RenameRefactoring.finalConditions", new Object[0]), 2);
            for (IResource resource : this.getResources()) {
                IPath location = ModelUtil.getLocation((IResource)resource);
                IPath absPath = location.makeAbsolute();
                IPath parentFolder = absPath.removeLastSegments(1);
                IPath destination = parentFolder.append(this.getNewResourceName());
                PathPair absPathPair = new PathPair(absPath.toOSString(), destination.toOSString());
                RelatedResourceCallback callback = new RelatedResourceCallback(absPathPair);
                if (ModelUtil.isModelFile((IResource)resource)) {
                    try {
                        TextFileChange textFileChange = new TextFileChange(resource.getName(), (IFile)resource);
                        RefactorResourcesUtils.calculateSQLChanges((IFile)resource, absPathPair, textFileChange);
                        if (textFileChange.getEdit() != null && textFileChange.getEdit().hasChildren()) {
                            this.addChange(resource, (Change)textFileChange);
                        }
                        RefactorResourcesUtils.calculateRelatedVdbResources(resource, status, callback);
                    }
                    catch (Exception ex) {
                        UiConstants.Util.log((Throwable)ex);
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)ex.getMessage()));
                    }
                }
                RefactorResourcesUtils.calculateRelatedResources(resource, status, callback, RelatedResourceFinder.Relationship.DEPENDENT);
                this.addChange(resource, (Change)new RenameResourceChange(resource.getFullPath(), this.getNewResourceName()));
            }
        }
        finally {
            progressMonitor.done();
        }
        return status;
    }

    public Change createChange(IProgressMonitor progressMonitor) throws OperationCanceledException, CoreException {
        try {
            RenameResourceCompositeChange change;
            progressMonitor.beginTask(RefactorResourcesUtils.getString("RenameRefactoring.creatingChange", new Object[0]), 1);
            RenameResourceCompositeChange renameResourceCompositeChange = change = new RenameResourceCompositeChange(this.getName(), this.getChanges().toArray(new Change[0]), this.newName, this.getResource());
            return renameResourceCompositeChange;
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, RenameResourceDescriptor.REFACTORING_ID, ex.getMessage()));
        }
        finally {
            progressMonitor.done();
        }
    }

    private class RelatedResourceCallback
    extends RefactorResourcesUtils.AbstractResourceCallback {
        private final PathPair pathPair;

        public RelatedResourceCallback(PathPair pathPair) {
            this.pathPair = pathPair;
        }

        @Override
        public void checkValidFile(IFile relatedFile, RefactoringStatus status) {
            RenameResourceRefactoring.this.checkResource((IResource)relatedFile, (IProgressMonitor)new NullProgressMonitor(), status);
        }

        @Override
        public void indexFile(IResource resource, IFile relatedFile, RefactoringStatus status) throws Exception {
            RefactorResourcesUtils.unloadModelResource((IResource)relatedFile);
            IPath relatedFilePath = ModelUtil.getLocation((IResource)relatedFile).makeAbsolute();
            IPath relatedParentPath = relatedFilePath.removeLastSegments(1);
            PathPair relativePathPair = RefactorResourcesUtils.getRelativePath(relatedParentPath.toOSString(), this.pathPair);
            TextFileChange textFileChange = RefactorResourcesUtils.calculateTextChanges(relatedFile, Collections.singleton(relativePathPair));
            RefactorResourcesUtils.calculateModelImportsElementLChanges(relatedFile, relativePathPair, textFileChange);
            if (ModelUtil.isModelFile((IResource)RenameResourceRefactoring.this.getResource())) {
                RefactorResourcesUtils.calculateSQLChanges(relatedFile, relativePathPair, textFileChange);
            }
            if (RenameResourceRefactoring.this.addTextChange(relatedFile, textFileChange) || RenameResourceRefactoring.this.getResource() instanceof IContainer) {
                RefactorResourcesUtils.calculateRelatedVdbResources((IResource)relatedFile, status, this);
            }
        }

        @Override
        public void indexVdb(IResource resource, IFile vdbFile, RefactoringStatus status) {
            IPath oldResourcePath = resource.getFullPath();
            IPath newResourcePath = null;
            if (RenameResourceRefactoring.this.getResource().equals((Object)resource)) {
                newResourcePath = oldResourcePath.removeLastSegments(1).append(RenameResourceRefactoring.this.getNewResourceName());
            } else if (RenameResourceRefactoring.this.getResource().getFullPath().isPrefixOf(oldResourcePath)) {
                IPath oldRResPath = RenameResourceRefactoring.this.getResource().getFullPath();
                IPath newRResPath = oldRResPath.removeLastSegments(1).append(RenameResourceRefactoring.this.getNewResourceName());
                int segmentCount = oldRResPath.matchingFirstSegments(oldResourcePath);
                newResourcePath = oldResourcePath.removeFirstSegments(segmentCount);
                newResourcePath = newRResPath.append(newResourcePath);
            } else {
                newResourcePath = oldResourcePath;
            }
            RenameResourceRefactoring.this.addVdbChange(vdbFile, oldResourcePath, newResourcePath);
        }
    }
}

