/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.move;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.teiid.designer.ui.refactor.AbstractResourcesCompositeChange;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.move.MoveResourcesDescriptor;

public class MoveResourcesCompositeChange
extends AbstractResourcesCompositeChange {
    private final IContainer destination;
    private final List<IResource> resources;

    public MoveResourcesCompositeChange(String name, Change[] changes, IContainer destination, List<IResource> resources) {
        super(name, changes);
        this.destination = destination;
        this.resources = resources;
    }

    @Override
    public ChangeDescriptor getDescriptor() {
        String project = this.destination.getProject().getName();
        String description = RefactorResourcesUtils.getString("MoveRefactoring.moveDescriptorDescription", new Object[0]);
        String comment = RefactorResourcesUtils.getString("MoveRefactoring.moveDescriptorComment", new Object[0]);
        MoveResourcesDescriptor descriptor = new MoveResourcesDescriptor(project, description, comment);
        descriptor.setResourcesToMove(this.resources);
        descriptor.setDestinationPath(this.destination.getFullPath());
        return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
    }

    @Override
    protected Change createUndoChange(Change[] childUndos) {
        return new MoveResourcesCompositeChange(this.getName(), childUndos, this.destination, this.resources);
    }
}

