/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.udp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.properties.ModelObjectPropertySource;
import org.teiid.designer.ui.properties.udp.UserDefinedPropertyDescriptor;

public class UserDefinedPropertySource
implements IPropertySource {
    private EObject object;
    private Collection tags;

    public UserDefinedPropertySource(EObject object) {
        this.object = object;
        this.tags = ModelerCore.getModelEditor().getTags(object);
    }

    public Object getEditableValue() {
        return this.object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList temp = new ArrayList();
        for (EcoreEMap map : this.tags) {
            Iterator entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                temp.add(entries.next());
            }
        }
        IPropertyDescriptor[] result = new IPropertyDescriptor[temp.size()];
        Iterator tempIt = temp.iterator();
        int i = 0;
        while (tempIt.hasNext()) {
            Object next = tempIt.next();
            if (!(next instanceof EStringToStringMapEntryImpl)) continue;
            EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)next;
            result[i++] = new UserDefinedPropertyDescriptor((EObject)entry, entry.getKey());
        }
        return result;
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof EStringToStringMapEntryImpl) {
            return ((EStringToStringMapEntryImpl)id).getValue();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return this.getPropertyValue(id) != null;
    }

    public void resetPropertyValue(Object id) {
        if (id instanceof EStringToStringMapEntryImpl) {
            EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)id;
            String name = entry.getKey();
            boolean started = ModelerCore.startTxn((String)(String.valueOf(ModelObjectPropertySource.RESET) + name), (Object)this);
            boolean succeeded = false;
            try {
                ((EStringToStringMapEntryImpl)id).setValue(null);
                succeeded = true;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id instanceof EStringToStringMapEntryImpl) {
            EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)id;
            String name = entry.getKey();
            boolean started = ModelerCore.startTxn((String)(String.valueOf(ModelObjectPropertySource.SET) + name), (Object)this);
            boolean succeeded = false;
            try {
                ((EStringToStringMapEntryImpl)id).setValue((String)value);
                succeeded = true;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }
}

