/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.extension;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.properties.extension.Messages;
import org.teiid.designer.ui.properties.extension.UdfJarDialogCellEditor;

public class ModelExtensionPropertyDescriptor
extends PropertyDescriptor
implements Comparable<ModelExtensionPropertyDescriptor> {
    private final EObject eObject;
    private final ILabelProvider labelProvider;
    private final ModelExtensionPropertyDefinition propDefn;

    private static ICellEditorValidator createValidator(final ModelExtensionPropertyDefinition propDefn) {
        return new ICellEditorValidator(){

            public String isValid(Object value) {
                return propDefn.isValidValue((String)value);
            }
        };
    }

    public ModelExtensionPropertyDescriptor(EObject eObject, ModelExtensionPropertyDefinition propDefn) {
        super((Object)propDefn.getId(), CoreStringUtil.isEmpty((String)propDefn.getDisplayName()) ? propDefn.getId() : String.valueOf(propDefn.getNamespaceProvider().getNamespacePrefix()) + ':' + propDefn.getDisplayName());
        CoreArgCheck.isNotNull((Object)eObject, (String)"eObject is null");
        this.eObject = eObject;
        this.propDefn = propDefn;
        this.labelProvider = new ModelExtensionDescriptorLabelProvider();
        this.setCategory(Messages.modelExtensionPropertyCategory);
        this.setDescription(this.propDefn.getDescription());
        this.setLabelProvider(this.labelProvider);
    }

    @Override
    public int compareTo(ModelExtensionPropertyDescriptor thatDescriptor) {
        return this.propDefn.getId().compareTo(thatDescriptor.propDefn.getId());
    }

    public CellEditor createPropertyEditor(Composite parent) {
        TextCellEditor editor = null;
        ModelResource modelResource = null;
        try {
            modelResource = ModelUtil.getModifiableModel((Object)this.eObject);
            if (modelResource == null || !this.propDefn.isModifiable()) {
                return null;
            }
        }
        catch (ModelWorkspaceException e) {
            ExtensionPlugin.Util.log((Throwable)e);
            return null;
        }
        IFile file = (IFile)modelResource.getResource();
        if (file == null) {
            ExtensionPlugin.Util.log(4, NLS.bind((String)Messages.workspaceFileNotFound, (Object)modelResource.getItemName()));
            return null;
        }
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            FileEditorInput fileInput = new FileEditorInput(file);
            IEditorPart modelEditor = page.findEditor((IEditorInput)fileInput);
            if (modelEditor == null && !ModelEditorManager.autoOpen(window.getShell(), this.eObject, true)) {
                return null;
            }
        }
        catch (Exception e) {
            ExtensionPlugin.Util.log((Throwable)e);
            return null;
        }
        String[] allowedValues = this.propDefn.getAllowedValues();
        if (this.propDefn.getId().equalsIgnoreCase("function:udfJarPath") || this.propDefn.getId().equalsIgnoreCase("relational:udfJarPath")) {
            return new UdfJarDialogCellEditor(parent, this.eObject);
        }
        if (allowedValues != null && allowedValues.length != 0) {
            editor = new ComboBoxCellEditor(parent, allowedValues, 8);
        } else {
            editor = new TextCellEditor(parent);
            editor.setValidator(ModelExtensionPropertyDescriptor.createValidator(this.propDefn));
            if (this.propDefn.isMasked()) {
                ((Text)editor.getControl()).setEchoChar('*');
            }
        }
        return editor;
    }

    public String getDescription() {
        return this.propDefn.getDescription();
    }

    public Object getId() {
        return this;
    }

    public String getPropDefnId() {
        return this.propDefn.getId();
    }

    ModelObjectExtensionAssistant getModelExtensionAssistant(String propId) {
        Collection assistants = ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistants(this.eObject.getClass().getName());
        if (assistants.isEmpty()) {
            this.log((IStatus)new Status(4, "org.teiid.designer.ui", NLS.bind((String)Messages.modelExtensionAssistantNotFound, (Object)propId)));
            return null;
        }
        for (ModelExtensionAssistant assistant : assistants) {
            if (!ModelExtensionPropertyDefinition.Utils.isExtensionPropertyId((String)propId, (NamespaceProvider)assistant.getModelExtensionDefinition())) continue;
            return assistant instanceof ModelObjectExtensionAssistant ? (ModelObjectExtensionAssistant)assistant : null;
        }
        this.log((IStatus)new Status(4, "org.teiid.designer.ui", NLS.bind((String)Messages.modelExtensionAssistantNotFound, (Object)propId)));
        return null;
    }

    protected EObject getModelObject() {
        return this.eObject;
    }

    protected ModelExtensionPropertyDefinition getPropertyDefinition() {
        return this.propDefn;
    }

    Object getPropertyValue() {
        String propId = this.propDefn.getId();
        ModelObjectExtensionAssistant assistant = this.getModelExtensionAssistant(propId);
        if (assistant != null) {
            try {
                boolean hasAllowedValues;
                String value = assistant.getPropertyValue((Object)this.eObject, propId);
                String[] allowedValues = this.propDefn.getAllowedValues();
                boolean bl = hasAllowedValues = allowedValues != null && allowedValues.length != 0;
                if (CoreStringUtil.isEmpty((String)value)) {
                    if (hasAllowedValues) {
                        return -1;
                    }
                    value = "";
                } else if (hasAllowedValues) {
                    int i = 0;
                    while (i < allowedValues.length) {
                        if (allowedValues[i].equalsIgnoreCase(value)) {
                            return i;
                        }
                        ++i;
                    }
                    this.log((IStatus)new Status(4, "org.teiid.designer.ui", NLS.bind((String)Messages.valueIsNotAnAllowedValue, (Object)value, (Object)propId)));
                    return -1;
                }
                return value;
            }
            catch (Exception e) {
                String msg = NLS.bind((String)Messages.errorObtainingPropertyFromAssistant, (Object)propId, (Object)assistant.getClass().getName());
                this.log((IStatus)new Status(4, "org.teiid.designer.ui", msg, (Throwable)e));
            }
        }
        this.log((IStatus)new Status(4, "org.teiid.designer.ui", NLS.bind((String)Messages.unexpectedPropertySourceId, (Object)propId)));
        return "";
    }

    void log(IStatus status) {
        ExtensionPlugin.getInstance().getLog().log(status);
    }

    void setPropertyValue(Object value) {
        String propId = this.propDefn.getId();
        ModelObjectExtensionAssistant assistant = this.getModelExtensionAssistant(propId);
        if (assistant != null) {
            if (value instanceof Integer) {
                int index = (Integer)value;
                String[] allowedValues = this.propDefn.getAllowedValues();
                value = index < 0 || allowedValues == null || allowedValues.length == 0 || index > allowedValues.length - 1 ? "" : allowedValues[index];
            }
            if (value instanceof String) {
                try {
                    assistant.setPropertyValue((Object)this.eObject, propId, (String)value);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)Messages.errorObtainingPropertyFromAssistant, (Object)propId, (Object)assistant.getClass().getName());
                    this.log((IStatus)new Status(4, "org.teiid.designer.ui", msg, (Throwable)e));
                }
            } else {
                this.log((IStatus)new Status(4, "org.teiid.designer.ui", NLS.bind((String)Messages.unexpectedPropertyValueType, (Object)propId)));
            }
        } else {
            this.log((IStatus)new Status(4, "org.teiid.designer.ui", NLS.bind((String)Messages.unexpectedPropertySourceId, (Object)propId.getClass().getName())));
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ModelExtensionPropertyDescriptor that = (ModelExtensionPropertyDescriptor)obj;
        if (!this.getPropertyDefinition().equals(that.getPropertyDefinition())) {
            return false;
        }
        return this.getModelObject().equals(that.getModelObject());
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getPropertyDefinition()});
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getModelObject()});
        return hc;
    }

    protected class ModelExtensionDescriptorLabelProvider
    extends LabelProvider {
        protected ModelExtensionDescriptorLabelProvider() {
        }

        public Image getImage(Object element) {
            ModelExtensionPropertyDefinition propDefn = ModelExtensionPropertyDescriptor.this.getPropertyDefinition();
            Object value = ModelExtensionPropertyDescriptor.this.getPropertyValue();
            if (value instanceof String) {
                String errorMsg = propDefn.isValidValue((String)value);
                if (!CoreStringUtil.isEmpty((String)errorMsg)) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
                String stringValue = (String)value;
                String defaultValue = propDefn.getDefaultValue();
                if (CoreStringUtil.isEmpty((String)stringValue) && CoreStringUtil.isEmpty((String)defaultValue) || CoreStringUtil.equals((String)stringValue, (String)defaultValue)) {
                    return null;
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            if (value instanceof Integer) {
                String stringValue = "";
                if ((Integer)value == -1) {
                    if (propDefn.isRequired()) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    }
                } else {
                    stringValue = propDefn.getAllowedValues()[(Integer)value];
                }
                if (!CoreStringUtil.valuesAreEqual((String)stringValue, (String)propDefn.getDefaultValue())) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
            }
            return null;
        }

        public String getText(Object element) {
            String[] allowedValues;
            if (ModelExtensionPropertyDescriptor.this.getPropertyDefinition().isMasked()) {
                return "*****";
            }
            if (element instanceof Integer && (allowedValues = ModelExtensionPropertyDescriptor.this.getPropertyDefinition().getAllowedValues()) != null && allowedValues.length != 0) {
                if ((Integer)element == -1) {
                    return "";
                }
                return allowedValues[(Integer)element];
            }
            return super.getText(element);
        }
    }
}

