/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.metamodels.core.Datatype;
import org.teiid.designer.ui.properties.ModelObjectPropertySheetPage;
import org.teiid.designer.ui.properties.ModelPropertySource;
import org.teiid.designer.ui.properties.sdt.SimpleDatatypePropertySource;
import org.teiid.designer.ui.viewsupport.IExtendedModelObject;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelObjectPropertySourceProvider
implements IPropertySourceProvider {
    private static ModelObjectPropertySheetPage propertySheetPage;

    public IPropertySource getPropertySource(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IItemPropertySource) {
            return new PropertySource(object, (IItemPropertySource)object);
        }
        if (object instanceof EObject) {
            if (propertySheetPage == null) {
                this.getPropertySheetPage();
            }
            if (object instanceof XSDSimpleTypeDefinition && !(object instanceof Datatype) && ((EObject)object).eContainer() instanceof XSDSchema) {
                IPropertySource emfSource = ModelObjectUtilities.getEmfPropertySourceProvider().getPropertySource(object);
                return new SimpleDatatypePropertySource((XSDSimpleTypeDefinition)object, emfSource);
            }
            return ModelObjectUtilities.getEmfPropertySourceProvider().getPropertySource(object);
        }
        if (object instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)object))) {
            return new ModelPropertySource((IFile)object);
        }
        if (object instanceof IExtendedModelObject) {
            return ((IExtendedModelObject)object).getPropertySource();
        }
        IAdapterManager manager = Platform.getAdapterManager();
        return (IPropertySource)manager.getAdapter(object, IPropertySource.class);
    }

    public PropertySheetPage getPropertySheetPage() {
        if (propertySheetPage == null) {
            propertySheetPage = new ModelObjectPropertySheetPage();
            propertySheetPage.setPropertySourceProvider(this);
        }
        return propertySheetPage;
    }

    public void dispose() {
    }
}

