/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ModelerActionService;
import org.teiid.designer.ui.actions.ModelerSpecialActionManager;
import org.teiid.designer.ui.actions.SortModelContentsAction;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorPageOutline;
import org.teiid.designer.ui.outline.ModelOutlineTreeViewer;

public class ModelOutlinePage
extends ContentOutlinePage {
    private static final ImageDescriptor blankIcon = UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/blank.gif");
    ModelEditor modelEditor;
    private PageBook pageBook;
    private ModelEditorPageOutline currentViewer;
    ModelOutlineTreeViewer viewer;
    private HashMap contributionMap = new HashMap();
    private ArrayList initList = new ArrayList();
    private IAction modelOutlineAction;
    private IAction contributionAction;
    IAction refreshAction;
    private IAction collapseAllAction;
    private boolean hasInitialized = false;
    private KeyAdapter kaKeyAdapter;

    public ModelOutlinePage(ModelEditor editor) {
        this.modelEditor = editor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void addOutlineContribution(ModelEditorPage page) {
        ModelEditorPageOutline contribution = page.getOutlineContribution();
        if (contribution != null) {
            String id = page.getClass().getName();
            this.contributionMap.put(id, contribution);
        }
    }

    public void createControl(Composite parent) {
        ModelerActionService service = this.getModelerActionService();
        service.registerDefaultGlobalActions(this.getSite().getActionBars());
        this.pageBook = new PageBook(parent, 0);
        this.viewer = new ModelOutlineTreeViewer(this.modelEditor);
        final String id = this.viewer.getClass().getName();
        this.viewer.init(this.getSite());
        this.viewer.createControl((Composite)this.pageBook);
        SortableSelectionAction previewAction = ModelerSpecialActionManager.getAction("org.teiid.designer.runtime.ui.preview.PreviewTableDataContextAction");
        if (previewAction != null) {
            this.getSite().getActionBars().getToolBarManager().add((IAction)previewAction);
            this.getSite().getActionBars().getToolBarManager().add((IContributionItem)new Separator());
        }
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this.modelOutlineAction = new Action(){

            public void run() {
                ModelOutlinePage.this.showPage(id);
                ModelOutlinePage.this.refreshAction.setEnabled(true);
            }
        };
        this.modelOutlineAction.setToolTipText(this.viewer.getToolTipText());
        this.modelOutlineAction.setImageDescriptor(this.viewer.getIcon());
        this.contributionAction = new Action(){

            public void run() {
                ModelOutlinePage.this.showPage(ModelOutlinePage.this.modelEditor.getCurrentPage().getClass().getName());
                ModelOutlinePage.this.refreshAction.setEnabled(false);
            }
        };
        this.contributionAction.setImageDescriptor(blankIcon);
        this.contributionAction.setEnabled(false);
        this.contributionAction.setChecked(false);
        tbm.add(this.contributionAction);
        tbm.add(this.modelOutlineAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)new SortModelContentsAction((ContentViewer)this.viewer.getTree()));
        this.refreshAction = new Action(){

            public void run() {
                ModelOutlinePage.this.viewer.getTree().refresh();
            }
        };
        this.refreshAction.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/refresh.gif"));
        this.refreshAction.setToolTipText(UiConstants.Util.getString("ModelOutlinePage.refreshAction.tooltip", new Object[0]));
        this.refreshAction.setText(UiConstants.Util.getString("ModelOutlinePage.refreshAction.text", new Object[0]));
        tbm.add(this.refreshAction);
        this.refreshAction.setEnabled(true);
        this.refreshAction = new Action(){

            public void run() {
                ModelOutlinePage.this.viewer.getTree().refresh();
            }
        };
        tbm.add((IContributionItem)new Separator());
        this.collapseAllAction = new Action(){

            public void run() {
                ModelOutlinePage.this.viewer.getTree().collapseAll();
            }
        };
        this.collapseAllAction.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/collapseall.gif"));
        this.collapseAllAction.setToolTipText(UiConstants.Util.getString("ModelOutlinePage.collapseAllAction.tooltip", new Object[0]));
        this.collapseAllAction.setText(UiConstants.Util.getString("ModelOutlinePage.collapseAllAction.text", new Object[0]));
        tbm.add(this.collapseAllAction);
        this.collapseAllAction.setEnabled(true);
        this.hasInitialized = true;
        if (this.modelEditor.getCurrentPage() instanceof ModelEditorPage) {
            this.setActiveEditorPage((ModelEditorPage)this.modelEditor.getCurrentPage());
        }
        this.showPage(this.viewer.getClass().getName());
    }

    private ModelerActionService getModelerActionService() {
        return (ModelerActionService)UiPlugin.getDefault().getActionService(this.getSite().getPage());
    }

    public void setActiveEditorPage(ModelEditorPage page) {
        if (this.hasInitialized) {
            ModelEditorPageOutline contribution = (ModelEditorPageOutline)this.contributionMap.get(page.getClass().getName());
            if (contribution != null) {
                this.contributionAction.setToolTipText(contribution.getToolTipText());
                this.contributionAction.setImageDescriptor(contribution.getIcon());
                this.contributionAction.setEnabled(contribution.isEnabled());
                this.refreshAction.setEnabled(false);
            } else {
                this.contributionAction.setEnabled(false);
                this.contributionAction.setToolTipText(null);
                this.contributionAction.setImageDescriptor(blankIcon);
                this.showPage(this.viewer.getClass().getName());
                this.refreshAction.setEnabled(false);
            }
        }
    }

    public void dispose() {
        Iterator iter = this.contributionMap.values().iterator();
        while (iter.hasNext()) {
            ((ModelEditorPageOutline)iter.next()).dispose();
        }
        if (this.viewer != null) {
            this.viewer.dispose();
        }
        super.dispose();
    }

    public Control getControl() {
        return this.pageBook;
    }

    public Object getCurrentViewer() {
        return this.currentViewer;
    }

    public void setFocus() {
        if (this.currentViewer != null) {
            this.currentViewer.getControl().setFocus();
        }
    }

    protected void showPage(String id) {
        if (!this.hasInitialized) {
            return;
        }
        Control pageToShow = null;
        if (id.equals(ModelOutlineTreeViewer.class.getName())) {
            this.contributionAction.setChecked(false);
            this.modelOutlineAction.setChecked(true);
            pageToShow = this.viewer.getControl();
            this.currentViewer = this.viewer;
        } else {
            ModelEditorPageOutline contribution = (ModelEditorPageOutline)this.contributionMap.get(id);
            if (contribution != null) {
                boolean isEnabled = true;
                if (!this.initList.contains(id)) {
                    contribution.createControl((Composite)this.pageBook);
                    this.initList.add(id);
                    isEnabled = contribution.isEnabled();
                }
                if (isEnabled) {
                    this.contributionAction.setChecked(true);
                    this.modelOutlineAction.setChecked(false);
                    pageToShow = contribution.getControl();
                    this.currentViewer = contribution;
                } else {
                    this.contributionAction.setChecked(false);
                    this.contributionAction.setEnabled(false);
                }
            }
        }
        if (pageToShow != null) {
            this.initKeyListener();
            this.pageBook.showPage(pageToShow);
        }
    }

    private void initKeyListener() {
        if (this.kaKeyAdapter == null) {
            this.kaKeyAdapter = new KeyAdapter(){

                public void keyReleased(KeyEvent event) {
                    ModelOutlinePage.this.handleKeyEvent(event);
                }
            };
        }
        if (this.currentViewer != null) {
            this.currentViewer.getControl().removeKeyListener((KeyListener)this.kaKeyAdapter);
            this.currentViewer.getControl().addKeyListener((KeyListener)this.kaKeyAdapter);
        }
    }

    void handleKeyEvent(KeyEvent event) {
        IAction actDelete;
        if (event.stateMask != 0) {
            return;
        }
        if (event.keyCode == 0x100000B) {
            try {
                IAction actRename = this.getModelerActionService().getAction(ActionFactory.RENAME.getId());
                if (actRename != null && actRename.isEnabled()) {
                    actRename.run();
                }
            }
            catch (CoreException coreException) {}
        } else if (event.character == '\u007f' && (actDelete = this.getSite().getActionBars().getGlobalActionHandler(ActionFactory.DELETE.getId())) != null && actDelete.isEnabled()) {
            actDelete.run();
        }
    }
}

