/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.forms;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;

public class MessageFormDialog
extends FormDialog {
    private final Image titleImage;
    private final String message;
    private final String msgTitle;
    private final Kind kind;

    private static String getMessageTitle(Kind kind) {
        if (Kind.ERROR == kind) {
            return UiConstants.Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(MessageFormDialog.class)) + "errorTitle", new Object[0]);
        }
        if (Kind.INFORMATION == kind) {
            return UiConstants.Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(MessageFormDialog.class)) + "infoTitle", new Object[0]);
        }
        if (Kind.QUESTION == kind) {
            return UiConstants.Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(MessageFormDialog.class)) + "questionTitle", new Object[0]);
        }
        if (Kind.WARNING == kind) {
            return UiConstants.Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(MessageFormDialog.class)) + "warningTitle", new Object[0]);
        }
        return "";
    }

    private static int getMessageType(Kind kind) {
        if (Kind.ERROR == kind) {
            return 3;
        }
        if (Kind.INFORMATION == kind || Kind.QUESTION == kind) {
            return 1;
        }
        if (Kind.WARNING == kind) {
            return 2;
        }
        return 0;
    }

    public static boolean openError(Shell parent, String msgTitle, Image titleImage, String message) {
        return MessageFormDialog.open(Kind.ERROR, parent, msgTitle, titleImage, message);
    }

    public static boolean openInfo(Shell parent, String msgTitle, Image titleImage, String message) {
        return MessageFormDialog.open(Kind.INFORMATION, parent, msgTitle, titleImage, message);
    }

    public static boolean openQuestion(Shell parent, String msgTitle, Image titleImage, String message) {
        return MessageFormDialog.open(Kind.QUESTION, parent, msgTitle, titleImage, message);
    }

    public static boolean openWarning(Shell parent, String msgTitle, Image titleImage, String message) {
        return MessageFormDialog.open(Kind.WARNING, parent, msgTitle, titleImage, message);
    }

    private static boolean open(Kind kind, Shell parent, String msgTitle, Image titleImage, String message) {
        MessageFormDialog dialog = new MessageFormDialog(kind, parent, msgTitle, titleImage, message);
        dialog.create();
        dialog.getShell().pack();
        return dialog.open() == 0;
    }

    private MessageFormDialog(Kind kind, Shell parent, String msgTitle, Image titleImage, String message) {
        super(parent);
        this.kind = kind;
        this.msgTitle = msgTitle;
        this.titleImage = titleImage;
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageFormDialog.getMessageTitle(this.kind));
        if (this.titleImage != null) {
            newShell.setImage(this.titleImage);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (this.kind == Kind.QUESTION) {
            if (id == 0) {
                label = IDialogConstants.YES_LABEL;
            } else if (1 == id) {
                label = IDialogConstants.NO_LABEL;
            }
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.kind == Kind.QUESTION) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setText(this.msgTitle);
        scrolledForm.setMessage("", MessageFormDialog.getMessageType(this.kind));
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(scrolledForm.getForm());
        Composite body = scrolledForm.getBody();
        body.setLayout((Layout)new TableWrapLayout());
        toolkit.createLabel(body, this.message, 64);
    }

    private static enum Kind {
        ERROR,
        QUESTION,
        INFORMATION,
        WARNING;

    }
}

