/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.forms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.teiid.designer.ui.forms.ComponentSetEvent;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.forms.SimpleComponentSet;

public class CheckboxComponentSet
extends SimpleComponentSet {
    private static final Boolean DEFAULT_SETTING = Boolean.FALSE;
    private final String labelText;
    private final String[] buttonIDs;
    private final String[] buttonTitles;
    private final int orientation;
    private MySelectionListener selList;
    private Object lastSetValue;
    private Button[] btns;
    private Map idToBtn;
    Set selectedIDs;
    private Set returnSet;

    public CheckboxComponentSet(String id, String text) {
        super(id, null);
        this.labelText = text;
        this.buttonIDs = null;
        this.buttonTitles = null;
        this.orientation = 0;
    }

    public CheckboxComponentSet(String id, String groupTitle, String[] buttonIDs, String[] buttonTitles, int orientation) {
        super(id, groupTitle);
        this.orientation = orientation;
        this.labelText = null;
        this.buttonIDs = buttonIDs;
        this.buttonTitles = buttonTitles;
    }

    @Override
    protected void addControls(Composite parent, FormToolkit ftk) {
        this.init();
        if (this.buttonIDs != null) {
            this.btns = new Button[this.buttonIDs.length];
            this.idToBtn = new HashMap(this.buttonIDs.length);
            this.selectedIDs = new HashSet(this.buttonIDs.length);
            this.returnSet = Collections.unmodifiableSet(this.selectedIDs);
            Composite grp = ftk.createComposite(parent);
            grp.setLayout((Layout)new FillLayout(this.orientation));
            int i = 0;
            while (i < this.buttonIDs.length) {
                String id = this.buttonIDs[i];
                String text = this.buttonTitles[i];
                this.btns[i] = ftk.createButton(grp, text, 32);
                this.btns[i].setData((Object)id);
                this.btns[i].addSelectionListener((SelectionListener)this.selList);
                this.idToBtn.put(id, this.btns[i]);
                ++i;
            }
        } else {
            this.btns = new Button[]{ftk.createButton(parent, this.labelText, 32)};
            this.btns[0].addSelectionListener((SelectionListener)this.selList);
        }
    }

    private void init() {
        if (this.selList == null) {
            this.selList = new MySelectionListener();
        }
    }

    @Override
    protected void addMonitor(ComponentSetMonitor monitor) {
        this.init();
        this.selList.mon = monitor;
    }

    @Override
    protected void removeMonitor(ComponentSetMonitor monitor) {
        this.init();
        this.selList.mon = null;
    }

    @Override
    public boolean isUserSet() {
        return !FormUtil.safeEquals(this.getValue(), this.lastSetValue);
    }

    @Override
    public void setValue(Object o) {
        if (o != null) {
            this.lastSetValue = o;
        } else {
            o = DEFAULT_SETTING;
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            this.btns[0].setSelection(b.booleanValue());
        } else if (o instanceof Collection) {
            Collection toSelect = (Collection)o;
            for (String id : toSelect) {
                Button b = (Button)this.idToBtn.get(id);
                b.setSelection(true);
            }
            HashSet toDeselect = new HashSet(this.idToBtn.keySet());
            toDeselect.removeAll(toSelect);
            for (String id : toDeselect) {
                Button b = (Button)this.idToBtn.get(id);
                b.setSelection(false);
            }
        }
    }

    public Object getValue() {
        Object rv = this.buttonIDs != null ? this.returnSet : new Boolean(this.btns[0].getSelection());
        return rv;
    }

    @Override
    public void reset() {
        this.setValue(this.lastSetValue);
    }

    @Override
    public void setEditible(boolean enabled) {
        super.setEditible(enabled);
        if (this.btns != null && this.btns.length > 1) {
            int i = 0;
            while (i < this.btns.length) {
                this.btns[i].setEnabled(enabled);
                ++i;
            }
        }
    }

    class MySelectionListener
    extends SelectionAdapter {
        public ComponentSetMonitor mon;

        MySelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object id = e.widget.getData();
            if (id != null) {
                if (((Button)e.widget).getSelection()) {
                    CheckboxComponentSet.this.selectedIDs.add(id);
                } else {
                    CheckboxComponentSet.this.selectedIDs.remove(id);
                }
            }
            if (this.mon != null) {
                this.mon.update(new ComponentSetEvent(CheckboxComponentSet.this, false, CheckboxComponentSet.this.getValue()));
            }
        }
    }
}

