/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.editors;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.editors.ModelEditor;

public class OpenEditorMap {
    private static final OpenEditorMap instance = new OpenEditorMap();
    private HashMap modelEditorMap = new HashMap();
    private HashMap fileEditorMap = new HashMap();
    private HashMap resourceEditorMap = new HashMap();

    public static OpenEditorMap getInstance() {
        return instance;
    }

    private OpenEditorMap() {
    }

    public synchronized boolean isEditorOpen(ModelResource modelResource) {
        return this.modelEditorMap.keySet().contains(modelResource);
    }

    public synchronized boolean isEditorOpen(IFile modelFile) {
        return this.fileEditorMap.keySet().contains(modelFile);
    }

    public synchronized boolean isEditorOpen(Resource emfResource) {
        return this.resourceEditorMap.keySet().contains(emfResource);
    }

    public synchronized ModelEditor getModelEditor(ModelResource modelResource) {
        return (ModelEditor)this.modelEditorMap.get(modelResource);
    }

    public synchronized ModelEditor getModelEditor(IFile modelFile) {
        return (ModelEditor)this.fileEditorMap.get(modelFile);
    }

    public synchronized ModelEditor getModelEditor(Resource emfResource) {
        return (ModelEditor)this.resourceEditorMap.get(emfResource);
    }

    synchronized void addModelEditor(ModelEditor editor, ModelResource resource) throws ModelWorkspaceException {
        this.modelEditorMap.put(resource, editor);
        this.fileEditorMap.put(resource.getResource(), editor);
        this.resourceEditorMap.put(resource.getEmfResource(), editor);
    }

    synchronized void removeModelEditor(ModelResource resource) throws ModelWorkspaceException {
        this.modelEditorMap.remove(resource);
        this.fileEditorMap.remove(resource.getResource());
        this.resourceEditorMap.remove(resource.getEmfResource());
    }
}

