/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorSite;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.ModelObjectEditorPanel;
import org.teiid.designer.ui.undo.IUndoManager;

public abstract class MultiPageModelEditor
extends EditorPart
implements IGotoMarker {
    protected ModelObjectEditorPanel editorContainer;
    CTabFolder tabFolder;
    private SashForm splitter;
    private ViewForm viewForm;
    private List nestedEditors = new ArrayList(3);
    private List allEditors = new ArrayList(3);
    private List objectEditors;
    private HashMap objectEditorMap = new HashMap();
    private boolean ignoreInternalFocus = false;
    private boolean tabFolderSelectionInProgress = false;

    protected MultiPageModelEditor() {
    }

    public int addPage(Control control) {
        CTabItem item = this.createItem();
        item.setControl(control);
        return this.getPageCount() - 1;
    }

    protected abstract void createPages();

    protected abstract boolean isResourceDirty();

    protected abstract void pageChange(int var1);

    protected abstract void initializeEditor(IEditorPart var1);

    public int addPage(IEditorPart editor, IEditorInput input) throws PartInitException {
        IEditorSite site = this.createSite(editor);
        editor.init(site, input);
        CTabItem item = this.createItem();
        Composite parent = new Composite((Composite)this.getTabFolder(), 0);
        parent.setLayout((Layout)new FillLayout());
        item.setControl((Control)parent);
        item.setData((Object)editor);
        this.allEditors.add(editor);
        return this.getPageCount() - 1;
    }

    protected void initializePage(IEditorPart editor) {
        CTabItem[] items = this.getTabFolder().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() == editor) {
                this.initializePage(editor, items[i]);
                break;
            }
            ++i;
        }
    }

    protected void initializePage(IEditorPart editor, CTabItem item) {
        try {
            Composite parent = (Composite)item.getControl();
            editor.createPartControl(parent);
            editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propertyId) {
                    MultiPageModelEditor.this.handlePropertyChange(propertyId);
                }
            });
            item.setData((Object)editor);
            this.nestedEditors.add(editor);
            this.initializeEditor(editor);
            parent.layout();
        }
        catch (Exception e) {
            String message = UiConstants.Util.getString("MultiPageModelEditor.pageInitializationErrorMessage", (Object)editor.getClass().getName());
            UiConstants.Util.log(4, (Throwable)e, message);
            String title = UiConstants.Util.getString("MultiPageModelEditor.pageInitializationErrorTitle", new Object[0]);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)message);
        }
    }

    protected boolean hasInitialized(IEditorPart editor) {
        return this.nestedEditors.contains(editor);
    }

    protected void initializeObjectEditors() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "modelObjectEditorPage");
        IExtension[] extensions = extensionPoint.getExtensions();
        this.objectEditors = new ArrayList(extensions.length);
        int i = extensions.length - 1;
        while (i >= 0) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            Object extension = null;
            int j = 0;
            while (j < elements.length) {
                try {
                    extension = elements[j].createExecutableExtension("name");
                    if (extension instanceof ModelObjectEditorPage) {
                        this.objectEditors.add(extension);
                        String id = elements[j].getAttribute("name");
                        this.objectEditorMap.put(id, extension);
                        ((ModelObjectEditorPage)extension).addPropertyListener(new IPropertyListener(){

                            public void propertyChanged(Object theSource, final int thePropId) {
                                UiUtil.runInSwtThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        MultiPageModelEditor.this.changeProperty(thePropId);
                                    }
                                }, (boolean)true);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    String message = UiConstants.Util.getString("MultiPageModelEditor.pageInitializationErrorMessage", (Object)elements[j].getAttribute("name"));
                    UiConstants.Util.log(4, (Throwable)e, message);
                    String title = UiConstants.Util.getString("MultiPageModelEditor.pageInitializationErrorTitle", new Object[0]);
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)message);
                }
                ++j;
            }
            --i;
        }
        Iterator iter = this.objectEditors.iterator();
        while (iter.hasNext()) {
            ((ModelObjectEditorPage)iter.next()).initialize(this);
        }
    }

    void changeProperty(int thePropId) {
        this.firePropertyChange(thePropId);
    }

    public boolean canEditModelObject(Object object) {
        if (this.objectEditors != null) {
            for (ModelObjectEditorPage objectEditor : this.objectEditors) {
                if (!objectEditor.canEdit(object, this.getActiveEditor())) continue;
                return true;
            }
        }
        return false;
    }

    public Object getEditableObject(Object object) {
        if (this.objectEditors != null) {
            Object editableObject = null;
            for (ModelObjectEditorPage objectEditor : this.objectEditors) {
                editableObject = objectEditor.getEditableObject(object);
                if (editableObject == null) continue;
                return editableObject;
            }
        }
        return null;
    }

    public void editModelObject(Object object, String editorId) {
        ModelObjectEditorPage objectEditor;
        if (editorId != null && (objectEditor = (ModelObjectEditorPage)this.objectEditorMap.get(editorId)) != null && objectEditor.canEdit(object, this.getActiveEditor())) {
            this.editorContainer.activateModelObjectEditor(objectEditor, object);
            return;
        }
        if (this.objectEditors != null) {
            ModelObjectEditorPage editorToOpen = null;
            ArrayList<ModelObjectEditorPage> canOpenList = new ArrayList<ModelObjectEditorPage>(this.objectEditors.size());
            for (ModelObjectEditorPage objectEditor2 : this.objectEditors) {
                if (!objectEditor2.canEdit(object, this.getActiveEditor())) continue;
                editorToOpen = objectEditor2;
                canOpenList.add(objectEditor2);
            }
            if (canOpenList.size() > 1) {
                RuntimeException ex = new RuntimeException("More than one ModelObjectEditorPage found for " + object.toString());
                UiConstants.Util.log((Throwable)ex);
                if (editorToOpen != null) {
                    this.editorContainer.activateModelObjectEditor(editorToOpen, object);
                }
            } else if (editorToOpen != null) {
                this.editorContainer.activateModelObjectEditor(editorToOpen, object);
            }
        }
    }

    public ModelObjectEditorPage getActiveObjectEditor() {
        return this.editorContainer.getActiveEditor();
    }

    public boolean closeObjectEditor() {
        return this.editorContainer.close();
    }

    private void createContainer(Composite parent) {
        this.splitter = new SashForm(parent, 512);
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        this.splitter.setLayoutData((Object)gid);
        this.viewForm = new ViewForm((Composite)this.splitter, 2048);
        this.viewForm.setLayoutData((Object)new GridData(1808));
        this.tabFolder = new CTabFolder((Composite)this.viewForm, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(final SelectionEvent e) {
                MultiPageModelEditor.this.tabFolderSelectionInProgress = true;
                UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CTabItem item = (CTabItem)e.item;
                        if (!item.isDisposed()) {
                            IEditorPart editor = (IEditorPart)item.getData();
                            if (!MultiPageModelEditor.this.hasInitialized(editor)) {
                                MultiPageModelEditor.this.initializePage(editor, item);
                            }
                            int newPageIndex = (this).MultiPageModelEditor.this.tabFolder.indexOf(item);
                            MultiPageModelEditor.this.pageChange(newPageIndex);
                        }
                        MultiPageModelEditor.this.tabFolderSelectionInProgress = false;
                    }
                });
            }
        });
        this.viewForm.setContent((Control)this.tabFolder);
        this.editorContainer = new ModelObjectEditorPanel(this, (Composite)this.splitter, 0);
        this.splitter.setWeights(new int[]{3, 2});
    }

    private CTabItem createItem() {
        CTabItem item = new CTabItem(this.getTabFolder(), 0);
        return item;
    }

    public final void createPartControl(Composite parent) {
        this.createContainer(parent);
        this.createPages();
        if (this.getActivePage() == -1) {
            this.setActivePage(0);
        }
        this.initializeObjectEditors();
        new DropTarget((Control)parent, 0);
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new ModelEditorSite(this, editor);
    }

    public void dispose() {
        this.preDisposeEditors();
        if (this.editorContainer != null) {
            this.editorContainer.dispose();
        }
        int i = 0;
        while (i < this.nestedEditors.size()) {
            IEditorPart editor = (IEditorPart)this.nestedEditors.get(i);
            this.disposePart((IWorkbenchPart)editor);
            ++i;
        }
        for (IEditorPart editorPart : this.allEditors) {
            if (!(editorPart.getSite() instanceof ModelEditorSite)) continue;
            ((ModelEditorSite)editorPart.getSite()).dispose();
        }
        this.nestedEditors.clear();
        this.allEditors.clear();
    }

    private void preDisposeEditors() {
        Iterator iter = this.getAllEditors().iterator();
        IEditorPart editor = null;
        while (iter.hasNext()) {
            editor = (IEditorPart)iter.next();
            if (!(editor instanceof ModelEditorPage)) continue;
            ((ModelEditorPage)editor).preDispose();
        }
    }

    public IEditorPart getActiveEditor() {
        int index = this.getActivePage();
        if (index != -1) {
            return this.getEditor(index);
        }
        return null;
    }

    protected int getActivePage() {
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder != null && !tabFolder.isDisposed()) {
            return tabFolder.getSelectionIndex();
        }
        return -1;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IUndoManager.class)) {
            return this.getUndoManager();
        }
        return super.getAdapter(adapter);
    }

    protected IUndoManager getUndoManager() {
        return null;
    }

    protected Composite getContainer() {
        return this.splitter;
    }

    protected Control getControl(int pageIndex) {
        return this.getItem(pageIndex).getControl();
    }

    protected IEditorPart getEditor(int pageIndex) {
        Object data;
        CTabItem item = this.getItem(pageIndex);
        if (item != null && (data = item.getData()) instanceof IEditorPart) {
            return (IEditorPart)data;
        }
        return null;
    }

    protected CTabItem getItem(int pageIndex) {
        return this.getTabFolder().getItem(pageIndex);
    }

    protected int getPageCount() {
        CTabFolder folder = this.getTabFolder();
        if (folder != null && !folder.isDisposed()) {
            return folder.getItemCount();
        }
        return 0;
    }

    protected Image getPageImage(int pageIndex) {
        return this.getItem(pageIndex).getImage();
    }

    protected String getPageText(int pageIndex) {
        return this.getItem(pageIndex).getText();
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    protected void handlePropertyChange(int propertyId) {
        this.firePropertyChange(propertyId);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        for (IEditorPart editor : this.nestedEditors) {
            if (!editor.isDirty()) continue;
            return true;
        }
        if (this.editorContainer != null && this.editorContainer.getActiveEditor() != null && this.editorContainer.getActiveEditor().isDirty()) {
            return true;
        }
        return this.isResourceDirty();
    }

    private void disposePart(final IWorkbenchPart part) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                part.dispose();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public void removePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        IEditorPart editor = this.getEditor(pageIndex);
        this.getItem(pageIndex).dispose();
        if (editor != null) {
            this.nestedEditors.remove(editor);
            this.disposePart((IWorkbenchPart)editor);
        }
    }

    protected void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.getTabFolder().setSelection(pageIndex);
    }

    protected void setControl(int pageIndex, Control control) {
        this.getItem(pageIndex).setControl(control);
    }

    public void setFocus() {
        if (this.getSite().getWorkbenchWindow().getActivePage() == null) {
            this.getSite().getWorkbenchWindow().addPageListener(new IPageListener(){

                public void pageOpened(IWorkbenchPage page) {
                }

                public void pageClosed(IWorkbenchPage page) {
                }

                public void pageActivated(IWorkbenchPage page) {
                    page.getWorkbenchWindow().removePageListener((IPageListener)this);
                    if (!MultiPageModelEditor.this.isIgnoreInternalFocus()) {
                        MultiPageModelEditor.this.internalSetFocus();
                    } else {
                        MultiPageModelEditor.this.setIgnoreInternalFocus(true);
                    }
                }
            });
        } else if (!this.isIgnoreInternalFocus()) {
            this.internalSetFocus();
        } else {
            this.setIgnoreInternalFocus(true);
        }
    }

    public void selectPage(IEditorPart editor) {
        CTabItem[] items = this.getTabFolder().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() == editor) {
                CTabItem item = items[i];
                this.getTabFolder().setSelection(item);
                Event event = new Event();
                event.widget = this.getTabFolder();
                event.item = item;
                event.type = 13;
                this.getTabFolder().notifyListeners(13, event);
                break;
            }
            ++i;
        }
    }

    public boolean isPageSelected(ModelEditorPage page) {
        CTabItem currentSelectedTab = this.getTabFolder().getSelection();
        if (currentSelectedTab != null && currentSelectedTab.getData() instanceof ModelEditorPage) {
            return currentSelectedTab.getData() == page;
        }
        return false;
    }

    void internalSetFocus() {
        int index;
        CTabItem[] items = this.getTabFolder().getItems();
        int ndx = items.length;
        while (--ndx >= 0) {
            CTabItem item = items[ndx];
            ModelEditorPage editor = (ModelEditorPage)item.getData();
            if (ndx != 0 && !editor.isSelectedFirst(this.getEditorInput())) continue;
            this.getTabFolder().setSelection(item);
            Event event = new Event();
            event.widget = this.getTabFolder();
            event.item = item;
            event.type = 13;
            if (this.tabFolderSelectionInProgress) break;
            this.getTabFolder().notifyListeners(13, event);
            break;
        }
        if ((index = this.getActivePage()) != -1) {
            this.setFocus(index);
        }
    }

    private void setFocus(int pageIndex) {
        Control control;
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        IEditorPart editor = this.getEditor(pageIndex);
        if (editor == null && (control = this.getControl(pageIndex)) != null) {
            control.setFocus();
        }
    }

    protected void setPageImage(int pageIndex, Image image) {
        this.getItem(pageIndex).setImage(image);
    }

    protected void setPageText(int pageIndex, String text) {
        this.getItem(pageIndex).setText(text);
    }

    protected void setPageToolTipText(int index, String text) {
        this.getTabFolder().getItem(index).setToolTipText(text);
    }

    void zoomObjectEditor(boolean hideTabs) {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            if (hideTabs) {
                this.tabFolder.getParent().setVisible(false);
            } else {
                this.tabFolder.getParent().setVisible(true);
            }
            this.splitter.layout();
        }
    }

    protected final void preSave(boolean isClosing) {
        this.editorContainer.saveEditorState(isClosing);
    }

    public void gotoMarker(IMarker marker) {
        for (ModelEditorPage editor : this.nestedEditors) {
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        }
    }

    public List getAllEditors() {
        return this.allEditors;
    }

    public List getNestedEditors() {
        return new ArrayList(this.nestedEditors);
    }

    public List getObjectEditors() {
        return this.objectEditors;
    }

    public boolean isIgnoreInternalFocus() {
        return this.ignoreInternalFocus;
    }

    public void setIgnoreInternalFocus(boolean theIgnoreInternalFocus) {
        this.ignoreInternalFocus = theIgnoreInternalFocus;
    }

    public void updateReadOnlyState() {
        if (this.objectEditors != null) {
            Iterator iter = this.objectEditors.iterator();
            while (iter.hasNext()) {
                ((ModelObjectEditorPage)iter.next()).updateReadOnlyState();
            }
        }
    }
}

