/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ModelObjectAction;
import org.teiid.designer.ui.actions.TransactionSettings;
import org.teiid.designer.ui.actions.workers.CutWorker;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class CutAction
extends ModelObjectAction
implements UiConstants {
    private CutWorker worker;
    private static final String CANNOT_UNDO_TITLE = "CutAction.cannotUndoTitle";
    private static final String CANNOT_UNDO_MSG = "CutAction.cannotUndoMsg";

    public CutAction() {
        super(UiPlugin.getDefault());
        ISharedImages imgs = this.getPlugin().getWorkbench().getSharedImages();
        this.setImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_CUT"));
        this.setDisabledImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.worker = new CutWorker(true);
        this.setActionWorker(this.worker);
    }

    public void runWithEvent(Event event) {
        if (!(event.widget instanceof StyledText)) {
            this.run();
        }
    }

    @Override
    protected boolean preRun() {
        TransactionSettings ts = this.getTransactionSettings();
        this.worker.setTransactionSettings(ts);
        this.worker.initTransactionSettings();
        if (!ts.isUndoable()) {
            String sTitle = UiConstants.Util.getString(CANNOT_UNDO_TITLE, new Object[0]);
            String sMsg = UiConstants.Util.getString(CANNOT_UNDO_MSG, new Object[0]);
            boolean bDoAnyway = MessageDialog.openQuestion((Shell)this.getShell(), (String)sTitle, (String)sMsg);
            if (!bDoAnyway) {
                return false;
            }
        }
        if (this.requiresEditorForRun()) {
            Object cachedSelection = this.worker.getSelection();
            if (this.worker.getFocusedObject() != null) {
                if (!ModelEditorManager.isOpen(this.worker.getFocusedObject())) {
                    ModelEditorManager.open(this.worker.getFocusedObject(), true);
                }
            } else if (this.worker.getModelResource() != null) {
                ModelEditorManager.activate(this.worker.getModelResource(), true);
            }
            this.worker.selectionChanged(cachedSelection);
        }
        return true;
    }

    @Override
    protected void postRun() {
        this.worker.selectionChanged(this.getSelection());
        this.worker.setTransactionSettings(null);
        super.postRun();
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }

    public ISelection getSelection() {
        if (this.worker.getEditorIsOpening() && this.worker.getTempSelection() != null) {
            return this.worker.getTempSelection();
        }
        return super.getSelection();
    }

    protected Shell getShell() {
        return UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }
}

