/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui;

import java.util.EventObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.event.EventBroker;
import org.teiid.core.designer.event.SynchEventBroker;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.INotificationHelper;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ModelWorkspaceNotification;
import org.teiid.designer.core.workspace.ModelWorkspaceNotificationListener;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.ModelerActionService;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.PreferenceKeyAndDefaultValue;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.editors.ModelEditorProjectListener;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.favorites.EObjectModelerCache;
import org.teiid.designer.ui.product.IModelerProductContexts;
import org.teiid.designer.ui.table.EObjectPropertiesOrderPreferences;
import org.teiid.designer.ui.undo.ModelerUndoManager;
import org.teiid.designer.ui.viewsupport.ModelerNotificationHelper;

public final class UiPlugin
extends AbstractUiPlugin
implements PluginConstants,
UiConstants,
IModelerProductContexts {
    private static UiPlugin plugin;
    private EventBroker eventBroker;
    private EObjectModelerCache eObjCache;
    ISelection cachedSelection = null;
    private final ModelEditorProjectListener projectListener = new ModelEditorProjectListener();
    private EObjectPropertiesOrderPreferences eObjectPropertiesOrderPreferences;
    private ModelerActionService service;
    private IPropertyChangeListener tablePrefPropListener;

    public static UiPlugin getDefault() {
        return plugin;
    }

    public UiPlugin() {
        plugin = this;
    }

    private void addToRegistry(ImageRegistry registry, String imagePath) {
        registry.put(imagePath, this.getImageDescriptor(imagePath));
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        super.initializeImageRegistry(registry);
        this.addToRegistry(registry, "icons/full/cview16/edit-document.png");
        this.addToRegistry(registry, "icons/full/cview16/teiid-server-default.png");
        this.addToRegistry(registry, "icons/full/cview16/teiid-server-disconnected.png");
        this.addToRegistry(registry, "icons/full/ovr16/error_co.gif");
        this.addToRegistry(registry, "icons/full/ovr16/warning_co.gif");
        this.addToRegistry(registry, "icons/full/ovr16/extension_ovr.gif");
        this.addToRegistry(registry, "icons/full/ovr16/run_co.gif");
    }

    protected ActionService createActionService(IWorkbenchPage page) {
        if (this.service == null) {
            page.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)new ViewSelectionCache());
            this.service = new ModelerActionService(page);
            this.service.initializeGlobalActions();
        }
        return this.service;
    }

    public void extractModelTableColumnUtilsToPreferenceStore() {
        this.getPreferenceStore().setValue("columnOrder", this.getEObjectPropertiesOrderPreferences().toString());
    }

    public EObjectModelerCache getEObjectCache() {
        if (this.eObjCache == null) {
            this.eObjCache = new EObjectModelerCache();
        }
        return this.eObjCache;
    }

    public EObjectPropertiesOrderPreferences getEObjectPropertiesOrderPreferences() {
        if (this.eObjectPropertiesOrderPreferences == null) {
            this.eObjectPropertiesOrderPreferences = new EObjectPropertiesOrderPreferences();
            this.tablePrefPropListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("columnOrder")) {
                        UiPlugin.this.initializeModelTableColumnUtilsFromPreferenceStore();
                    }
                }
            };
            this.getPreferenceStore().addPropertyChangeListener(this.tablePrefPropListener);
        }
        return this.eObjectPropertiesOrderPreferences;
    }

    public ImageDescriptor getErrorDecoratorImage() {
        ImageRegistry imageRegistry = plugin.getImageRegistry();
        return imageRegistry.getDescriptor("icons/full/ovr16/error_co.gif");
    }

    public EventBroker getEventBroker() {
        if (this.eventBroker == null) {
            this.eventBroker = new SynchEventBroker();
        }
        return this.eventBroker;
    }

    public PluginUtil getPluginUtil() {
        return Util;
    }

    public ISelection getPreviousViewSelection() {
        return this.cachedSelection;
    }

    public Image getProjectImage() {
        return this.getImage("icons/full/obj16/ModelProject.gif");
    }

    public Image getSimpleProjectImage() {
        return this.getImage("icons/full/obj16/SimpleProject.gif");
    }

    public ImageDescriptor getWarningDecoratorImage() {
        ImageRegistry imageRegistry = plugin.getImageRegistry();
        return imageRegistry.getDescriptor("icons/full/ovr16/warning_co.gif");
    }

    public ImageDescriptor getExtensionDecoratorImage() {
        ImageRegistry imageRegistry = plugin.getImageRegistry();
        return imageRegistry.getDescriptor("icons/full/ovr16/extension_ovr.gif");
    }

    public ImageDescriptor getPreviewableDecoratorImage() {
        ImageRegistry imageRegistry = plugin.getImageRegistry();
        return imageRegistry.getDescriptor("icons/full/ovr16/run_co.gif");
    }

    public static void registerActionForSelection(ISelectionListener action) {
        ActionService actionService = UiPlugin.getDefault().getActionService(UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage());
        actionService.addWorkbenchSelectionListener(action);
    }

    public static void unregisterActionForSelection(ISelectionListener action) {
        ActionService actionService = UiPlugin.getDefault().getActionService(UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage());
        actionService.removeWorkbenchSelectionListener(action);
    }

    void initializeModelTableColumnUtilsFromPreferenceStore() {
        this.getEObjectPropertiesOrderPreferences().initializeFromString(this.getPreferenceStore().getString("columnOrder"));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
        try {
            ProductCustomizerMgr.getInstance().loadCustomizations();
        }
        catch (Exception theException) {
            Util.log((Throwable)theException);
        }
        ModelerUndoManager.getInstance();
        ModelerCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.projectListener);
        NotificationUtilities.setNotificationHelper((INotificationHelper)new ModelerNotificationHelper());
        ModelWorkspaceManager.getModelWorkspaceManager();
        ModelWorkspaceNotificationListener modelWsListener = new ModelWorkspaceNotificationListener(){

            protected ModelResource getModelResource(Notification notification) {
                IResource resource = (IResource)notification.getNotifier();
                return ModelerCore.getModelWorkspace().findModelResource(resource);
            }

            public void notifyAdd(ModelWorkspaceNotification notification) {
                ModelResource modelResource;
                if (notification.isPostChange() && (modelResource = this.getModelResource((Notification)notification)) != null) {
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 7, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyChanged(Notification notification) {
                ModelResource modelResource;
                if (notification instanceof ModelWorkspaceNotification && ((ModelWorkspaceNotification)notification).isPreAutoBuild() && (modelResource = this.getModelResource(notification)) != null) {
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 4, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyClean(IProject proj) {
            }

            public void notifyClosing(ModelWorkspaceNotification notification) {
                ModelResource modelResource = this.getModelResource((Notification)notification);
                if (modelResource != null) {
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 2, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyMove(ModelWorkspaceNotification notification) {
                ModelResource modelResource;
                if (notification.isPostChange() && (modelResource = this.getModelResource((Notification)notification)) != null) {
                    IPath oldPath = notification.getDelta().getMovedFromPath();
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 9, (Object)this, oldPath);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyOpen(ModelWorkspaceNotification notification) {
                ModelResource modelResource = this.getModelResource((Notification)notification);
                if (modelResource != null) {
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 1, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyReloaded(ModelWorkspaceNotification notification) {
                ModelResource modelResource = this.getModelResource((Notification)notification);
                if (modelResource != null) {
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 6, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyRemove(ModelWorkspaceNotification notification) {
                Object notifier;
                if (notification.isPostChange() && (notifier = notification.getNotifier()) instanceof IResource) {
                    IResource srcFile = (IResource)notifier;
                    ModelResourceEvent event = new ModelResourceEvent(srcFile, 8, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyRename(ModelWorkspaceNotification notification) {
                ModelResource modelResource;
                if (notification.isPostChange() && (modelResource = this.getModelResource((Notification)notification)) != null) {
                    IPath oldPath = notification.getDelta().getMovedFromPath();
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 9, (Object)this, oldPath);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }
        };
        ModelerCore.getModelWorkspace().addNotificationListener(modelWsListener);
        this.storeDefaultPreferenceValues();
        this.initializeModelTableColumnUtilsFromPreferenceStore();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.tablePrefPropListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.tablePrefPropListener);
        }
        this.extractModelTableColumnUtilsToPreferenceStore();
        ModelerCore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.projectListener);
        super.stop(context);
    }

    private void storeDefaultPreferenceValues() {
        IPreferenceStore preferenceStore = UiPlugin.getDefault().getPreferenceStore();
        PreferenceKeyAndDefaultValue[] preferenceKeyAndDefaultValueArray = PluginConstants.Prefs.General.PREFERENCES;
        int n = PluginConstants.Prefs.General.PREFERENCES.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceKeyAndDefaultValue element = preferenceKeyAndDefaultValueArray[n2];
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)element);
            ++n2;
        }
        UiPlugin.getDefault().savePreferences();
    }

    class ViewSelectionCache
    implements ISelectionListener {
        ViewSelectionCache() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!(part instanceof IEditorPart)) {
                UiPlugin.this.cachedSelection = selection;
            }
        }
    }
}

