/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.RelationalPlugin;

public class ProcedureParametersRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        ValidationProblemImpl problem;
        int directionKind;
        DirectionKind direction;
        CoreArgCheck.isInstanceOf(Procedure.class, (Object)eObject);
        Procedure procedure = (Procedure)eObject;
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        Iterator paramIter = procedure.getParameters().iterator();
        boolean foundReturnParam = false;
        while (paramIter.hasNext()) {
            ProcedureParameter param = (ProcedureParameter)paramIter.next();
            direction = param.getDirection();
            if (direction == null) {
                ValidationProblemImpl problem2 = new ValidationProblemImpl(0, 4, RelationalPlugin.Util.getString("ProcedureParametersRule.Parameter_{0}_does_not_have_a_direction._1", new Object[]{param.getName()}));
                result.addProblem((ValidationProblem)problem2);
            }
            if ((directionKind = direction.getValue()) == 4) {
                problem = new ValidationProblemImpl(0, 4, RelationalPlugin.Util.getString("ProcedureParametersRule.Parameter_{0}_has_an_UNKNOWN_direction._1", new Object[]{param.getName()}));
                result.addProblem((ValidationProblem)problem);
                continue;
            }
            if (directionKind != 3) continue;
            if (!foundReturnParam) {
                foundReturnParam = true;
                continue;
            }
            problem = new ValidationProblemImpl(0, 4, RelationalPlugin.Util.getString("ProcedureParametersRule.Procedure_{0}_has_more_than_one_parameter_with_RETURN_direction._1", new Object[]{procedure.getName()}));
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        if (procedure.isFunction()) {
            for (ProcedureParameter param : procedure.getParameters()) {
                direction = param.getDirection();
                directionKind = direction.getValue();
                if (directionKind != 2 && directionKind != 1 && directionKind != 4) continue;
                problem = new ValidationProblemImpl(0, 4, RelationalPlugin.Util.getString("ProcedureParametersRule.Procedure_{0}_is_defined_as_function_and_can_only_have_in_parameters_and_one_return_parameter", new Object[]{procedure.getName()}));
                result.addProblem((ValidationProblem)problem);
            }
        }
        context.addResult((ValidationResult)result);
    }
}

