/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.uml;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.metamodel.aspect.uml.UmlAssociation;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.UniqueConstraint;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.metamodels.relational.aspects.uml.RelationalEntityAspect;

public abstract class UniqueKeyAspect
extends RelationalEntityAspect
implements UmlAssociation {
    public int getAggregation(Object assoc, int end) {
        return 301;
    }

    public String[] getProperties(Object assoc, int end) {
        return CoreStringUtil.Constants.EMPTY_STRING_ARRAY;
    }

    public int getNavigability(Object assoc, int end) {
        if (end == 1) {
            return 503;
        }
        if (end == 0) {
            return 501;
        }
        return 502;
    }

    public String getMultiplicity(Object eObject, int end) {
        UniqueKey key = this.assertUniqueKey(eObject);
        if (key instanceof PrimaryKey) {
            if (end == 0) {
                return "0..1";
            }
            if (end == 1) {
                return "0..1";
            }
        } else if (key instanceof UniqueConstraint) {
            if (end == 0) {
                return "0..1";
            }
            if (end == 1) {
                return "0..*";
            }
        }
        return "";
    }

    public String getSignature(Object eObject, int showMask) {
        UniqueKey key = this.assertUniqueKey(eObject);
        StringBuffer result = new StringBuffer();
        switch (showMask) {
            case 1: {
                result.append(key.getName());
                break;
            }
            case 2: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">>");
                break;
            }
            case 3: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">> ");
                result.append(key.getName());
                break;
            }
            case 4: {
                result.append(super.getArrayAsString(this.getProperties(key, 0)));
                break;
            }
            case 5: {
                result.append(key.getName());
                result.append(super.getArrayAsString(this.getProperties(key, 0)));
                break;
            }
            case 6: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">> ");
                result.append(super.getArrayAsString(this.getProperties(key, 0)));
                break;
            }
            case 7: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">> ");
                result.append(key.getName());
                result.append(super.getArrayAsString(this.getProperties(key, 0)));
                break;
            }
            default: {
                throw new TeiidDesignerRuntimeException(RelationalPlugin.Util.getString("Aspect.invalidShowMask", (Object)showMask));
            }
        }
        return result.toString();
    }

    public String getEditableSignature(Object eObject) {
        return this.getSignature(eObject, 1);
    }

    public IStatus setRoleName(Object assoc, int end, String name) {
        throw new UnsupportedOperationException();
    }

    public IStatus setMultiplicity(Object assoc, int end, String mult) {
        throw new UnsupportedOperationException();
    }

    public IStatus setProperties(Object assoc, int end, String[] props) {
        throw new UnsupportedOperationException();
    }

    public IStatus setNavigability(Object assoc, int end, int navigability) {
        throw new UnsupportedOperationException();
    }

    public IStatus setSignature(Object eObject, String newSignature) {
        try {
            UniqueKey key = this.assertUniqueKey(eObject);
            key.setName(newSignature);
        }
        catch (Throwable e) {
            return new Status(4, "org.teiid.designer.metamodels.relational", 0, e.getMessage(), e);
        }
        return new Status(0, "org.teiid.designer.metamodels.relational", 0, RelationalPlugin.Util.getString("Aspect.ok", new Object[0]), null);
    }

    protected UniqueKey assertUniqueKey(Object eObject) {
        CoreArgCheck.isInstanceOf(UniqueKey.class, (Object)eObject);
        return (UniqueKey)eObject;
    }
}

