/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stax.StAXSource;
import org.teiid.core.types.XMLType;

public class XMLReader
extends Reader {
    private static final int BUFFER_SIZE = 8192;
    private int pos = 0;
    private StringBuilder builder = new StringBuilder(8192);
    private XMLEventReader reader;
    private XMLEventWriter writer;

    public XMLReader(StAXSource source, XMLOutputFactory outFactory) throws XMLStreamException {
        this.reader = source.getXMLEventReader();
        if (this.reader == null) {
            this.reader = XMLType.getXmlInputFactory().createXMLEventReader(source.getXMLStreamReader());
        }
        this.writer = outFactory.createXMLEventWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                XMLReader.this.builder.append(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
                XMLReader.this.builder.append(str, off, len);
            }

            @Override
            public void close() throws IOException {
            }
        });
    }

    @Override
    public int read() throws IOException {
        while (this.pos >= this.builder.length()) {
            if (!this.reader.hasNext()) {
                return -1;
            }
            if (this.builder.length() > 8192) {
                this.builder.setLength(0);
                this.pos = 0;
            }
            try {
                XMLEvent event = this.reader.nextEvent();
                this.writer.add(event);
                this.writer.flush();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
        return this.builder.charAt(this.pos++);
    }

    @Override
    public void close() throws IOException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        int c = 0;
        i = 0;
        while (i < len) {
            c = this.read();
            if (c == -1) {
                if (i != 0) break;
                return -1;
            }
            cbuf[i + off] = (char)c;
            ++i;
        }
        return i;
    }
}

