/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Translator;
import org.teiid.core.util.ArgCheck;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;
import org.teiid.runtime.client.Messages;

public class TeiidTranslator
implements Comparable<TeiidTranslator>,
ITeiidTranslator {
    private final Translator translator;
    private final ITeiidServer teiidServer;
    private final Collection<TeiidPropertyDefinition> propDefs = new ArrayList<TeiidPropertyDefinition>();
    private final Collection<TeiidPropertyDefinition> importPropDefs = new ArrayList<TeiidPropertyDefinition>();
    private final Collection<TeiidPropertyDefinition> extPropDefs = new ArrayList<TeiidPropertyDefinition>();

    public TeiidTranslator(Translator translator, Collection<? extends PropertyDefinition> propDefs, ITeiidServer teiidServer) {
        ArgCheck.isNotNull(translator, "translator");
        ArgCheck.isNotEmpty(propDefs, "propDefs");
        ArgCheck.isNotNull(teiidServer, "teiidServer");
        this.translator = translator;
        this.teiidServer = teiidServer;
        for (PropertyDefinition propertyDefinition : propDefs) {
            TeiidPropertyDefinition teiidPropertyDefn = new TeiidPropertyDefinition();
            teiidPropertyDefn.setName(propertyDefinition.getName());
            teiidPropertyDefn.setDisplayName(propertyDefinition.getDisplayName());
            teiidPropertyDefn.setDescription(propertyDefinition.getDescription());
            teiidPropertyDefn.setPropertyTypeClassName(propertyDefinition.getPropertyTypeClassName());
            teiidPropertyDefn.setDefaultValue(propertyDefinition.getDefaultValue());
            teiidPropertyDefn.setAllowedValues(propertyDefinition.getAllowedValues());
            teiidPropertyDefn.setModifiable(propertyDefinition.isModifiable());
            teiidPropertyDefn.setConstrainedToAllowedValues(propertyDefinition.isConstrainedToAllowedValues());
            teiidPropertyDefn.setAdvanced(propertyDefinition.isAdvanced());
            teiidPropertyDefn.setRequired(propertyDefinition.isRequired());
            teiidPropertyDefn.setMasked(propertyDefinition.isMasked());
            this.propDefs.add(teiidPropertyDefn);
        }
    }

    public TeiidTranslator(Translator translator, Collection<? extends PropertyDefinition> propDefs, Collection<? extends PropertyDefinition> importPropDefs, Collection<? extends PropertyDefinition> extPropDefs, ITeiidServer teiidServer) {
        this(translator, propDefs, teiidServer);
        TeiidPropertyDefinition teiidPropertyDefn;
        for (PropertyDefinition propertyDefinition : importPropDefs) {
            teiidPropertyDefn = new TeiidPropertyDefinition();
            teiidPropertyDefn.setName(propertyDefinition.getName());
            teiidPropertyDefn.setDisplayName(propertyDefinition.getDisplayName());
            teiidPropertyDefn.setDescription(propertyDefinition.getDescription());
            teiidPropertyDefn.setPropertyTypeClassName(propertyDefinition.getPropertyTypeClassName());
            teiidPropertyDefn.setDefaultValue(propertyDefinition.getDefaultValue());
            teiidPropertyDefn.setAllowedValues(propertyDefinition.getAllowedValues());
            teiidPropertyDefn.setModifiable(propertyDefinition.isModifiable());
            teiidPropertyDefn.setConstrainedToAllowedValues(propertyDefinition.isConstrainedToAllowedValues());
            teiidPropertyDefn.setAdvanced(propertyDefinition.isAdvanced());
            teiidPropertyDefn.setRequired(propertyDefinition.isRequired());
            teiidPropertyDefn.setMasked(propertyDefinition.isMasked());
            this.importPropDefs.add(teiidPropertyDefn);
        }
        for (PropertyDefinition propertyDefinition : extPropDefs) {
            teiidPropertyDefn = new TeiidPropertyDefinition();
            teiidPropertyDefn.setName(propertyDefinition.getName());
            teiidPropertyDefn.setDisplayName(propertyDefinition.getDisplayName());
            teiidPropertyDefn.setDescription(propertyDefinition.getDescription());
            teiidPropertyDefn.setPropertyTypeClassName(propertyDefinition.getPropertyTypeClassName());
            teiidPropertyDefn.setDefaultValue(propertyDefinition.getDefaultValue());
            teiidPropertyDefn.setAllowedValues(propertyDefinition.getAllowedValues());
            teiidPropertyDefn.setModifiable(propertyDefinition.isModifiable());
            teiidPropertyDefn.setConstrainedToAllowedValues(propertyDefinition.isConstrainedToAllowedValues());
            teiidPropertyDefn.setAdvanced(propertyDefinition.isAdvanced());
            teiidPropertyDefn.setRequired(propertyDefinition.isRequired());
            teiidPropertyDefn.setMasked(propertyDefinition.isMasked());
            teiidPropertyDefn.setOwner(propertyDefinition.getPropertyValue("owner"));
            this.extPropDefs.add(teiidPropertyDefn);
        }
    }

    @Override
    public int compareTo(TeiidTranslator translator) {
        ArgCheck.isNotNull(translator, "translator");
        return this.getName().compareTo(translator.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ITeiidTranslator other = (ITeiidTranslator)obj;
        ITeiidServer otherServer = other.getTeiidServer();
        return this.getName().equals(other.getName()) && (this.getTeiidServer() == otherServer || this.getTeiidServer().equals(otherServer));
    }

    public Collection<String> findInvalidProperties(ITeiidTranslator.TranslatorPropertyType propType) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (TeiidPropertyDefinition propDefn : this.propDefs) {
            String name = propDefn.getName();
            String value = this.getPropertyValue(name, propType);
            if (value == null || value.length() == 0) {
                if (!propDefn.isRequired()) continue;
                propertyNames.add(name);
                continue;
            }
            if (this.isValidPropertyValue(name, value, propType) == null) continue;
            propertyNames.add(name);
        }
        return propertyNames;
    }

    protected Translator getTranslator() {
        return this.translator;
    }

    public String getName() {
        return this.translator.getName();
    }

    public Properties getProperties() {
        return this.translator.getProperties();
    }

    public String getPropertyValue(String name, ITeiidTranslator.TranslatorPropertyType type) {
        return this.translator.getPropertyValue(name);
    }

    public String getType() {
        return this.translator.getType();
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getTeiidServer() == null ? 0 : this.getTeiidServer().hashCode());
        return result;
    }

    public ITeiidServer getTeiidServer() {
        return this.teiidServer;
    }

    public TeiidPropertyDefinition getPropertyDefinition(String name, ITeiidTranslator.TranslatorPropertyType type) {
        block4: {
            block5: {
                block3: {
                    ArgCheck.isNotNull(name, "name");
                    if (type != ITeiidTranslator.TranslatorPropertyType.OVERRIDE) break block3;
                    for (TeiidPropertyDefinition propDef : this.getPropertyDefinitions()) {
                        if (!name.equals(propDef.getName())) continue;
                        return propDef;
                    }
                    break block4;
                }
                if (type != ITeiidTranslator.TranslatorPropertyType.IMPORT) break block5;
                for (TeiidPropertyDefinition propDef : this.getImportPropertyDefinitions()) {
                    if (!name.equals(propDef.getName())) continue;
                    return propDef;
                }
                break block4;
            }
            if (type != ITeiidTranslator.TranslatorPropertyType.EXTENSION_METADATA) break block4;
            for (TeiidPropertyDefinition propDef : this.getExtensionPropertyDefinitions()) {
                if (!name.equals(propDef.getName())) continue;
                return propDef;
            }
        }
        return null;
    }

    public Properties getDefaultPropertyValues() {
        Properties defaultValues = new Properties();
        for (TeiidPropertyDefinition propDef : this.getPropertyDefinitions()) {
            String value = propDef.getDefaultValue() == null ? "" : propDef.getDefaultValue().toString();
            defaultValues.setProperty(propDef.getName(), value);
        }
        return defaultValues;
    }

    public String isValidPropertyValue(String name, String value, ITeiidTranslator.TranslatorPropertyType propType) {
        TeiidPropertyDefinition definition = this.getPropertyDefinition(name, propType);
        if (definition == null) {
            return Messages.getString(Messages.ExecutionAdmin.missingPropertyDefinition, name);
        }
        if (value == null) {
            return Messages.getString(Messages.ExecutionAdmin.invalidNullPropertyValue, name);
        }
        String type = definition.getPropertyTypeClassName();
        if (Boolean.class.getName().equals(type) || Boolean.TYPE.getName().equals(type)) {
            if (!value.equalsIgnoreCase(Boolean.TRUE.toString()) && !value.equalsIgnoreCase(Boolean.FALSE.toString())) {
                return Messages.getString(Messages.ExecutionAdmin.invalidPropertyEditorValue, value, Boolean.TYPE.getName());
            }
        } else if (Character.class.getName().equals(type) || Character.TYPE.getName().equals(type)) {
            if (value.length() != 1) {
                return Messages.getString(Messages.ExecutionAdmin.invalidPropertyEditorValue, value, Character.TYPE.getName());
            }
        } else if (Byte.class.getName().equals(type) || Byte.TYPE.getName().equals(type)) {
            try {
                Byte.parseByte(value);
            }
            catch (Exception exception) {
                return Messages.getString(Messages.ExecutionAdmin.invalidPropertyEditorValue, value, Byte.TYPE.getName());
            }
        } else if (Short.class.getName().equals(type) || Short.TYPE.getName().equals(type)) {
            try {
                Short.parseShort(value);
            }
            catch (Exception exception) {
                return Messages.getString(Messages.ExecutionAdmin.invalidPropertyEditorValue, value, Short.TYPE.getName());
            }
        } else if (Integer.class.getName().equals(type) || Integer.TYPE.getName().equals(type)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception exception) {
                return Messages.getString(Messages.ExecutionAdmin.invalidPropertyEditorValue, value, Integer.TYPE.getName());
            }
        } else if (Long.class.getName().equals(type) || Long.TYPE.getName().equals(type)) {
            try {
                Long.parseLong(value);
            }
            catch (Exception exception) {
                return Messages.getString(Messages.ExecutionAdmin.invalidPropertyEditorValue, value, Long.TYPE.getName());
            }
        } else if (Float.class.getName().equals(type) || Float.TYPE.getName().equals(type)) {
            try {
                Float.parseFloat(value);
            }
            catch (Exception exception) {
                return Messages.getString(Messages.ExecutionAdmin.invalidPropertyEditorValue, value, Float.TYPE.getName());
            }
        } else if (Double.class.getName().equals(type) || Double.TYPE.getName().equals(type)) {
            try {
                Double.parseDouble(value);
            }
            catch (Exception exception) {
                return Messages.getString(Messages.ExecutionAdmin.invalidPropertyEditorValue, value, Double.TYPE.getName());
            }
        } else if (!String.class.getName().equals(type)) {
            return Messages.getString(Messages.ExecutionAdmin.unknownPropertyType, name, type);
        }
        if (definition.isConstrainedToAllowedValues()) {
            Collection values = definition.getAllowedValues();
            assert (values != null && !values.isEmpty());
            for (Object allowedValue : values) {
                if (!allowedValue.equals(value)) continue;
                return null;
            }
            return Messages.getString(Messages.ExecutionAdmin.invalidPropertyEditorConstrainedValue, value, values.toString());
        }
        return null;
    }

    public void setPropertyValue(String name, String value, ITeiidTranslator.TranslatorPropertyType type) throws Exception {
        ArgCheck.isNotNull(name, "name");
        this.getProperties().setProperty(name, value);
    }

    public void setProperties(Properties changedProperties) throws Exception {
        ArgCheck.isNotNull(changedProperties, "changedProperties");
        Set<Map.Entry<Object, Object>> entrySet = changedProperties.entrySet();
        ArgCheck.isNotEmpty(entrySet, "changedProperties");
        Properties props = this.getProperties();
        for (Map.Entry<Object, Object> entry : entrySet) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public Collection<TeiidPropertyDefinition> getPropertyDefinitions() {
        return this.propDefs;
    }

    public Collection<TeiidPropertyDefinition> getImportPropertyDefinitions() {
        return this.importPropDefs;
    }

    public Collection<TeiidPropertyDefinition> getExtensionPropertyDefinitions() {
        return this.extPropDefs;
    }

    public String toString() {
        return Messages.getString(Messages.ExecutionAdmin.connectorDetailedName, this.getName(), this.getType());
    }
}

