/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.xquery.saxon;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLTranslator;
import org.teiid.core.types.XMLType;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.sql.lang.NamespaceItem;
import org.teiid.query.sql.lang.XMLColumn;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.xquery.saxon.StreamingUtils;
import org.teiid.runtime.client.Messages;

public class SaxonXQueryExpression {
    private static final String XQUERY_PLANNING = "XQuery Planning";
    private static final String EMPTY_STRING = "";
    static final String DEFAULT_PREFIX = "-";
    public static final Properties DEFAULT_OUTPUT_PROPERTIES = new Properties();
    private static final Expression DUMMY_EXPRESSION = new Expression(){

        public ItemType getItemType(TypeHierarchy th) {
            return null;
        }

        public void explain(ExpressionPresenter out) {
        }

        public Expression copy() {
            return null;
        }

        protected int computeCardinality() {
            return 0;
        }

        public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
            return pathMapNodeSet;
        }
    };
    private static final ErrorListener ERROR_LISTENER = new ErrorListener(){

        @Override
        public void warning(TransformerException arg0) throws TransformerException {
        }

        @Override
        public void error(TransformerException arg0) throws TransformerException {
        }

        @Override
        public void fatalError(TransformerException arg0) throws TransformerException {
        }
    };
    XQueryExpression xQuery;
    String xQueryString;
    Map<String, String> namespaceMap;
    Configuration config;
    PathMap.PathMapRoot contextRoot;
    String streamingPath;
    public static final boolean[] isValidAncestorAxis;

    static {
        boolean[] blArray = new boolean[14];
        blArray[2] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[12] = true;
        isValidAncestorAxis = blArray;
    }

    public SaxonXQueryExpression(String xQueryString, XMLNamespaces namespaces, List<DerivedColumn> passing, List<XMLColumn> columns) throws QueryResolverException {
        DEFAULT_OUTPUT_PROPERTIES.setProperty("method", "xml");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        this.namespaceMap = new HashMap<String, String>();
        this.config = new Configuration();
        this.config.setErrorListener(ERROR_LISTENER);
        this.xQueryString = xQueryString;
        StaticQueryContext context = this.config.newStaticQueryContext();
        IndependentContext ic = new IndependentContext(this.config);
        this.namespaceMap.put(EMPTY_STRING, EMPTY_STRING);
        if (namespaces != null) {
            for (NamespaceItem item : namespaces.getNamespaceItems()) {
                if (item.getPrefix() == null) {
                    if (item.getUri() == null) {
                        context.setDefaultElementNamespace(EMPTY_STRING);
                        ic.setDefaultElementNamespace(EMPTY_STRING);
                        continue;
                    }
                    context.setDefaultElementNamespace(item.getUri());
                    ic.setDefaultElementNamespace(item.getUri());
                    this.namespaceMap.put(EMPTY_STRING, item.getUri());
                    continue;
                }
                context.declareNamespace(item.getPrefix(), item.getUri());
                ic.declareNamespace(item.getPrefix(), item.getUri());
                this.namespaceMap.put(item.getPrefix(), item.getUri());
            }
        }
        this.namespaceMap.put(DEFAULT_PREFIX, this.namespaceMap.get(EMPTY_STRING));
        for (DerivedColumn derivedColumn : passing) {
            if (derivedColumn.getAlias() == null) continue;
            try {
                context.declareGlobalVariable(StructuredQName.fromClarkName((String)derivedColumn.getAlias()), SequenceType.ANY_SEQUENCE, null, true);
            }
            catch (XPathException e) {
                throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID30153, new Object[0]), e);
            }
        }
        this.processColumns(columns, ic);
        try {
            this.xQuery = context.compileQuery(xQueryString);
        }
        catch (XPathException e) {
            throw new QueryResolverException(e, Messages.gs(Messages.TEIID.TEIID30154, new Object[0]));
        }
    }

    private SaxonXQueryExpression() {
        DEFAULT_OUTPUT_PROPERTIES.setProperty("method", "xml");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        this.namespaceMap = new HashMap<String, String>();
        this.config = new Configuration();
    }

    public SaxonXQueryExpression clone() {
        SaxonXQueryExpression clone = new SaxonXQueryExpression();
        clone.xQuery = this.xQuery;
        clone.xQueryString = this.xQueryString;
        clone.config = this.config;
        clone.contextRoot = this.contextRoot;
        clone.namespaceMap = this.namespaceMap;
        clone.streamingPath = this.streamingPath;
        return clone;
    }

    public boolean usesContextItem() {
        return this.xQuery.usesContextItem();
    }

    public void useDocumentProjection(List<XMLColumn> columns) {
        try {
            this.streamingPath = StreamingUtils.getStreamingPath(this.xQueryString, this.namespaceMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.contextRoot = null;
        PathMap map = null;
        map = columns == null ? this.xQuery.getPathMap() : new PathMap(this.xQuery.getExpression());
        PathMap.PathMapRoot parentRoot = map.getContextRoot();
        if (parentRoot == null) {
            return;
        }
        HashSet<PathMap.PathMapNode> finalNodes = new HashSet<PathMap.PathMapNode>();
        this.getReturnableNodes((PathMap.PathMapNode)parentRoot, finalNodes);
        if (!finalNodes.isEmpty()) {
            if (columns != null && !columns.isEmpty()) {
                if (finalNodes.size() != 1) {
                    return;
                }
                if ((parentRoot = this.projectColumns(parentRoot, columns, finalNodes.iterator().next())) == null) {
                    return;
                }
            } else {
                for (PathMap.PathMapNode subNode : finalNodes) {
                    subNode.createArc(new AxisExpression(5, (NodeTest)AnyNodeTest.getInstance()));
                }
            }
        }
        if (parentRoot.hasUnknownDependencies()) {
            return;
        }
        this.contextRoot = parentRoot;
    }

    private PathMap.PathMapRoot projectColumns(PathMap.PathMapRoot parentRoot, List<XMLColumn> columns, PathMap.PathMapNode finalNode) {
        for (XMLColumn xmlColumn : columns) {
            if (xmlColumn.isOrdinal()) continue;
            Expression internalExpression = xmlColumn.getPathExpression().getInternalExpression();
            PathMap subMap = new PathMap(internalExpression);
            PathMap.PathMapRoot subContextRoot = null;
            PathMap.PathMapRoot[] pathMapRootArray = subMap.getPathMapRoots();
            int n = pathMapRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                PathMap.PathMapRoot root = pathMapRootArray[n2];
                if (root.getRootExpression() instanceof ContextItemExpression || root.getRootExpression() instanceof RootExpression) {
                    if (subContextRoot != null) {
                        return null;
                    }
                    subContextRoot = root;
                }
                ++n2;
            }
            if (subContextRoot == null) {
                if (!(internalExpression instanceof ContextItemExpression)) continue;
                this.addReturnedArcs(xmlColumn, finalNode);
                continue;
            }
            pathMapRootArray = subContextRoot.getArcs();
            n = pathMapRootArray.length;
            n2 = 0;
            while (n2 < n) {
                PathMap.PathMapRoot arc = pathMapRootArray[n2];
                if (this.streamingPath != null && !this.validateColumnForStreaming(xmlColumn, (PathMap.PathMapArc)arc)) {
                    this.streamingPath = null;
                }
                finalNode.createArc(arc.getStep(), arc.getTarget());
                ++n2;
            }
            HashSet<PathMap.PathMapNode> subFinalNodes = new HashSet<PathMap.PathMapNode>();
            this.getReturnableNodes((PathMap.PathMapNode)subContextRoot, subFinalNodes);
            for (PathMap.PathMapNode subNode : subFinalNodes) {
                this.addReturnedArcs(xmlColumn, subNode);
            }
        }
        PathMap newMap = new PathMap(DUMMY_EXPRESSION);
        PathMap.PathMapRoot newRoot = newMap.makeNewRoot(parentRoot.getRootExpression());
        if (parentRoot.isAtomized()) {
            newRoot.setAtomized();
        }
        if (parentRoot.isReturnable()) {
            newRoot.setReturnable(true);
        }
        if (parentRoot.hasUnknownDependencies()) {
            newRoot.setHasUnknownDependencies();
        }
        PathMap.PathMapArc[] pathMapArcArray = parentRoot.getArcs();
        int n = pathMapArcArray.length;
        int n3 = 0;
        while (n3 < n) {
            PathMap.PathMapArc arc = pathMapArcArray[n3];
            newRoot.createArc(arc.getStep(), arc.getTarget());
            ++n3;
        }
        return newMap.reduceToDownwardsAxes(newRoot);
    }

    private boolean validateColumnForStreaming(XMLColumn xmlColumn, PathMap.PathMapArc arc) {
        boolean ancestor = false;
        LinkedList<PathMap.PathMapArc> arcStack = new LinkedList<PathMap.PathMapArc>();
        arcStack.add(arc);
        while (!arcStack.isEmpty()) {
            PathMap.PathMapArc current = (PathMap.PathMapArc)arcStack.removeFirst();
            byte axis = current.getStep().getAxis();
            if (ancestor) {
                if (current.getTarget().isReturnable() && axis != 8 && axis != 2) {
                    return false;
                }
                if (!isValidAncestorAxis[axis]) {
                    return false;
                }
            } else if (!Axis.isSubtreeAxis[axis]) {
                if (axis == 9 || axis == 0 || axis == 1) {
                    if (current.getTarget().isReturnable()) {
                        return false;
                    }
                    ancestor = true;
                } else {
                    return false;
                }
            }
            PathMap.PathMapArc[] pathMapArcArray = current.getTarget().getArcs();
            int n = pathMapArcArray.length;
            int n2 = 0;
            while (n2 < n) {
                PathMap.PathMapArc pathMapArc = pathMapArcArray[n2];
                arcStack.add(pathMapArc);
                ++n2;
            }
        }
        return true;
    }

    private void addReturnedArcs(XMLColumn xmlColumn, PathMap.PathMapNode subNode) {
        if (xmlColumn.getSymbol().getType() == DataTypeManagerService.DefaultDataTypes.XML.getTypeClass()) {
            subNode.createArc(new AxisExpression(5, (NodeTest)AnyNodeTest.getInstance()));
        } else {
            subNode.createArc(new AxisExpression(3, (NodeTest)NodeKindTest.TEXT));
            subNode.setAtomized();
        }
    }

    private void getReturnableNodes(PathMap.PathMapNode node, HashSet<PathMap.PathMapNode> finalNodes) {
        if (node.isReturnable()) {
            finalNodes.add(node);
        }
        PathMap.PathMapArc[] pathMapArcArray = node.getArcs();
        int n = pathMapArcArray.length;
        int n2 = 0;
        while (n2 < n) {
            PathMap.PathMapArc arc = pathMapArcArray[n2];
            this.getReturnableNodes(arc.getTarget(), finalNodes);
            ++n2;
        }
    }

    private void processColumns(List<XMLColumn> columns, IndependentContext ic) throws QueryResolverException {
        if (columns == null) {
            return;
        }
        XPathEvaluator eval = new XPathEvaluator(this.config);
        eval.setStaticContext((XPathStaticContext)ic);
        for (XMLColumn xmlColumn : columns) {
            XPathExpression exp;
            if (xmlColumn.isOrdinal()) continue;
            String path = xmlColumn.getPath();
            if (path == null) {
                path = xmlColumn.getName();
            }
            if ((path = path.trim()).startsWith("/")) {
                path = path.startsWith("//") ? String.valueOf('.') + path : path.substring(1);
            }
            try {
                exp = eval.createExpression(path);
            }
            catch (XPathException xPathException) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30155, xmlColumn.getName(), xmlColumn.getPath()));
            }
            xmlColumn.setPathExpression(exp);
        }
    }

    public XMLType createXMLType(final SequenceIterator iter, boolean emptyOnEmpty) throws Exception {
        Item next;
        Item item = iter.next();
        if (item == null && !emptyOnEmpty) {
            return null;
        }
        XMLType.Type type = XMLType.Type.CONTENT;
        if (item instanceof NodeInfo) {
            NodeInfo info = (NodeInfo)item;
            type = SaxonXQueryExpression.getType(info);
        }
        if ((next = iter.next()) != null) {
            type = XMLType.Type.CONTENT;
        }
        SQLXMLImpl xml = XMLSystemFunctions.saveToBufferManager(new XMLTranslator(){

            @Override
            public void translate(Writer writer) throws TransformerException, IOException {
                QueryResult.serializeSequence((SequenceIterator)iter.getAnother(), (Configuration)SaxonXQueryExpression.this.config, (Writer)writer, (Properties)DEFAULT_OUTPUT_PROPERTIES);
            }
        });
        XMLType value = new XMLType(xml);
        value.setType(type);
        return value;
    }

    public static XMLType.Type getType(NodeInfo info) {
        switch (info.getNodeKind()) {
            case 9: {
                return XMLType.Type.DOCUMENT;
            }
            case 1: {
                return XMLType.Type.ELEMENT;
            }
            case 3: {
                return XMLType.Type.TEXT;
            }
            case 8: {
                return XMLType.Type.COMMENT;
            }
            case 7: {
                return XMLType.Type.PI;
            }
        }
        return XMLType.Type.CONTENT;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static void showArcs(StringBuilder sb, PathMap.PathMapNode node, int level) {
        PathMap.PathMapArc[] pathMapArcArray = node.getArcs();
        int n = pathMapArcArray.length;
        int n2 = 0;
        while (n2 < n) {
            PathMap.PathMapArc pathMapArc = pathMapArcArray[n2];
            char[] pad = new char[level * 2];
            Arrays.fill(pad, ' ');
            sb.append(new String(pad));
            sb.append(pathMapArc.getStep());
            sb.append('\n');
            node = pathMapArc.getTarget();
            SaxonXQueryExpression.showArcs(sb, node, level + 1);
            ++n2;
        }
    }

    public boolean isStreaming() {
        return this.streamingPath != null;
    }

    public static class Result {
        public SequenceIterator iter;
        public List<Source> sources = new LinkedList<Source>();

        private void closeSource(Source source) {
            if (!(source instanceof StreamSource)) {
                return;
            }
            StreamSource stream = (StreamSource)source;
            try {
                if (stream.getInputStream() != null) {
                    stream.getInputStream().close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (stream.getReader() != null) {
                    stream.getReader().close();
                }
            }
            catch (IOException iOException) {}
        }

        public void close() {
            for (Source source : this.sources) {
                this.closeSource(source);
                if (!(source instanceof StAXSource)) continue;
                StAXSource ss = (StAXSource)source;
                if (ss.getXMLEventReader() != null) {
                    try {
                        ss.getXMLEventReader().close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                    continue;
                }
                try {
                    ss.getXMLStreamReader().close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (this.iter != null) {
                this.iter.close();
            }
            this.sources.clear();
            this.iter = null;
        }
    }

    public static interface RowProcessor {
        public void processRow(NodeInfo var1);
    }
}

