/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SingleElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;

public class ElementSymbol
extends Symbol
implements SingleElementSymbol,
Expression,
IElementSymbol<GroupSymbol, LanguageVisitor> {
    private Class type;
    private Object metadataID;
    private GroupSymbol groupSymbol;
    private IElementSymbol.DisplayMode displayMode = IElementSymbol.DisplayMode.OUTPUT_NAME;
    private boolean isExternalReference;
    private boolean isAggregate;

    public ElementSymbol(TeiidParser p, int id) {
        super(p, id);
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    public void setMetadataID(Object metadataID) {
        this.metadataID = metadataID;
    }

    public GroupSymbol getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(GroupSymbol symbol) {
        this.groupSymbol = symbol;
    }

    @Override
    public String getName() {
        if (this.groupSymbol != null) {
            return String.valueOf(this.groupSymbol.getName()) + "." + this.getShortName();
        }
        return super.getName();
    }

    @Override
    public void setName(String name) {
        int index = name.lastIndexOf(46);
        if (index > 0) {
            if (this.groupSymbol != null) {
                throw new AssertionError((Object)"Attempt to set an invalid name");
            }
            GroupSymbol gs = (GroupSymbol)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
            gs.setName(new String(name.substring(0, index)));
            this.setGroupSymbol(gs);
            name = new String(name.substring(index + 1));
        } else {
            this.groupSymbol = null;
        }
        super.setShortName(name);
    }

    public void setDisplayMode(IElementSymbol.DisplayMode displayMode) {
        if (displayMode == null) {
            this.displayMode = IElementSymbol.DisplayMode.OUTPUT_NAME;
        }
        this.displayMode = displayMode;
    }

    public IElementSymbol.DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayFullyQualified(boolean displayFullyQualified) {
        this.displayMode = displayFullyQualified ? IElementSymbol.DisplayMode.FULLY_QUALIFIED : IElementSymbol.DisplayMode.SHORT_OUTPUT_NAME;
    }

    public boolean getDisplayFullyQualified() {
        return this.displayMode.equals((Object)IElementSymbol.DisplayMode.FULLY_QUALIFIED);
    }

    public void setIsExternalReference(boolean isExternalReference) {
        this.isExternalReference = isExternalReference;
    }

    public boolean isExternalReference() {
        return this.isExternalReference;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public void setAggregate(boolean isAggregate) {
        this.isAggregate = isAggregate;
    }

    @Override
    public int hashCode() {
        super.hashCode();
        if (this.groupSymbol != null) {
            int result = 1;
            result = 31 * result + this.groupSymbol.hashCode();
            result = this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0.get()) ? 31 * result + (this.getShortCanonicalName() == null ? 0 : this.getShortCanonicalName().hashCode()) : 31 * result + (this.getShortName() == null ? 0 : this.getShortName().hashCode());
            return result;
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementSymbol other = (ElementSymbol)obj;
        if (this.groupSymbol == null) {
            return super.equals(obj);
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return this.groupSymbol.equals(other.groupSymbol) && this.getShortName().equals(other.getShortName());
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ElementSymbol clone() {
        ElementSymbol clone = new ElementSymbol(this.parser, this.id);
        if (this.getGroupSymbol() != null) {
            clone.setGroupSymbol(this.getGroupSymbol().clone());
        }
        if (this.getType() != null) {
            clone.setType(this.getType());
        }
        if (this.getMetadataID() != null) {
            clone.setMetadataID(this.getMetadataID());
        }
        if (this.getDisplayMode() != null) {
            clone.setDisplayMode(this.getDisplayMode());
        }
        if (this.getShortCanonicalName() != null) {
            clone.setShortCanonicalName(this.getShortCanonicalName());
        }
        if (this.getShortName() != null) {
            clone.setShortName(this.getShortName());
        }
        if (this.getOutputName() != null) {
            clone.setOutputName(this.getOutputName());
        }
        clone.isExternalReference = this.isExternalReference;
        clone.isAggregate = this.isAggregate;
        return clone;
    }
}

