/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import org.teiid.designer.query.sql.proc.IBranchingStatement;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.proc.Statement;

public class BranchingStatement
extends Statement
implements IBranchingStatement<LanguageVisitor> {
    private String label;
    private BranchingMode mode = BranchingMode.BREAK;

    public BranchingStatement(TeiidParser p, int id) {
        super(p, id);
    }

    @Override
    public Statement.StatementType getType() {
        switch (this.mode) {
            case BREAK: {
                return Statement.StatementType.TYPE_BREAK;
            }
            case CONTINUE: {
                return Statement.StatementType.TYPE_CONTINUE;
            }
            case LEAVE: {
                return Statement.StatementType.TYPE_LEAVE;
            }
        }
        throw new AssertionError();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public BranchingMode getMode() {
        return this.mode;
    }

    public void setMode(BranchingMode mode) {
        this.mode = mode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BranchingStatement other = (BranchingStatement)obj;
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        return this.mode == other.mode;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BranchingStatement clone() {
        BranchingStatement clone = new BranchingStatement(this.parser, this.id);
        if (this.getLabel() != null) {
            clone.setLabel(this.getLabel());
        }
        if (this.getMode() != null) {
            clone.setMode(this.getMode());
        }
        return clone;
    }

    public static enum BranchingMode {
        BREAK,
        CONTINUE,
        LEAVE;

    }
}

