/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.query.sql.lang.IXMLTable;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.XMLColumn;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.xquery.saxon.SaxonXQueryExpression;

public class XMLTable
extends TableFunctionReference
implements IXMLTable<LanguageVisitor> {
    private List<XMLColumn> columns = new ArrayList<XMLColumn>();
    private String xquery;
    private List<DerivedColumn> passing = new ArrayList<DerivedColumn>();
    private boolean usingDefaultColumn;
    private XMLNamespaces namespaces;
    private SaxonXQueryExpression xqueryExpression;

    public XMLTable(TeiidParser p, int id) {
        super(p, id);
    }

    public List<DerivedColumn> getPassing() {
        return this.passing;
    }

    public void setPassing(List<DerivedColumn> passing) {
        this.passing = passing;
    }

    public String getXquery() {
        return this.xquery;
    }

    public void setXquery(String xquery) {
        this.xquery = xquery;
    }

    public boolean isUsingDefaultColumn() {
        return this.usingDefaultColumn;
    }

    public void setUsingDefaultColumn(boolean usingDefaultColumn) {
        this.usingDefaultColumn = usingDefaultColumn;
    }

    public List<XMLColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<XMLColumn> columns) {
        if (this.getTeiidVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_0.get()) && columns.isEmpty()) {
            this.usingDefaultColumn = true;
            XMLColumn xmlColumn = (XMLColumn)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.XML_COLUMN);
            xmlColumn.setName("OBJECT_VALUE");
            xmlColumn.setType(DataTypeManagerService.DefaultDataTypes.XML.getId());
            xmlColumn.setPath(".");
            columns.add(xmlColumn);
        }
        this.columns = columns;
    }

    public XMLNamespaces getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(XMLNamespaces namespaces) {
        this.namespaces = namespaces;
    }

    public void compileXqueryExpression() throws Exception {
        this.xqueryExpression = new SaxonXQueryExpression(this.xquery, this.namespaces, this.passing, this.columns);
    }

    public SaxonXQueryExpression getXQueryExpression() {
        return this.xqueryExpression;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.namespaces == null ? 0 : this.namespaces.hashCode());
        result = 31 * result + (this.passing == null ? 0 : this.passing.hashCode());
        result = 31 * result + (this.usingDefaultColumn ? 1231 : 1237);
        result = 31 * result + (this.xquery == null ? 0 : this.xquery.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLTable other = (XMLTable)obj;
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        if (this.namespaces == null ? other.namespaces != null : !this.namespaces.equals(other.namespaces)) {
            return false;
        }
        if (this.passing == null ? other.passing != null : !this.passing.equals(other.passing)) {
            return false;
        }
        if (this.usingDefaultColumn != other.usingDefaultColumn) {
            return false;
        }
        return !(this.xquery == null ? other.xquery != null : !this.xquery.equals(other.xquery));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public XMLTable clone() {
        XMLTable clone = new XMLTable(this.parser, this.id);
        if (this.getColumns() != null) {
            clone.setColumns(this.cloneList(this.getColumns()));
        }
        if (this.getPassing() != null) {
            clone.setPassing(this.cloneList(this.getPassing()));
        }
        if (this.getNamespaces() != null) {
            clone.setNamespaces(this.getNamespaces().clone());
        }
        if (this.getXquery() != null) {
            clone.setXquery(this.getXquery());
        }
        clone.setUsingDefaultColumn(this.isUsingDefaultColumn());
        if (this.getName() != null) {
            clone.setName(this.getName());
        }
        clone.setOptional(this.isOptional());
        clone.setMakeInd(this.isMakeInd());
        clone.setNoUnnest(this.isNoUnnest());
        clone.setMakeDep(this.isMakeDep());
        clone.setMakeNotDep(this.isMakeNotDep());
        clone.setPreserve(this.isPreserve());
        return clone;
    }
}

