/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.teiid.designer.query.sql.lang.IInsert;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.TargetedCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;

public class Insert
extends ProcedureContainer
implements TargetedCommand,
IInsert<ElementSymbol, Expression, GroupSymbol, QueryCommand, LanguageVisitor> {
    private GroupSymbol group;
    private List<ElementSymbol> variables = new LinkedList<ElementSymbol>();
    private List<Expression> values = new LinkedList<Expression>();
    private QueryCommand queryExpression;
    private Criteria constraint;
    private boolean merge;

    public Insert(TeiidParser p, int id) {
        super(p, id);
    }

    public int getType() {
        return 2;
    }

    @Override
    public GroupSymbol getGroup() {
        return this.group;
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public List<ElementSymbol> getVariables() {
        return this.variables;
    }

    public void addVariable(ElementSymbol var) {
        this.variables.add(var);
    }

    public void addVariables(Collection<ElementSymbol> vars) {
        this.variables.addAll(vars);
    }

    public void setVariables(Collection<ElementSymbol> vars) {
        this.variables.clear();
        this.variables.addAll(vars);
    }

    public List<Expression> getValues() {
        return this.values;
    }

    public void setValues(List<? extends Expression> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void addValue(Expression value) {
        this.values.add(value);
    }

    public QueryCommand getQueryExpression() {
        return this.queryExpression;
    }

    public void setQueryExpression(QueryCommand query) {
        Query expr;
        if (this.isTeiid8OrGreater() && query instanceof Query && (expr = (Query)query).isRowConstructor()) {
            this.values.clear();
            this.queryExpression = null;
            for (Expression ex : expr.getSelect().getSymbols()) {
                this.addValue(SymbolMap.getExpression(ex));
            }
            if (expr.getOption() != null && this.getOption() == null) {
                this.setOption(expr.getOption());
            }
            return;
        }
        this.queryExpression = query;
    }

    public Criteria getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Criteria constraint) {
        this.constraint = constraint;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public List<Expression> getProjectedSymbols() {
        return this.getUpdateCommandSymbol();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.constraint == null ? 0 : this.constraint.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.merge ? 1231 : 1237);
        result = 31 * result + (this.queryExpression == null ? 0 : this.queryExpression.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variables.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Insert other = (Insert)obj;
        if (this.constraint == null ? other.constraint != null : !this.constraint.equals(other.constraint)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.merge != other.merge) {
            return false;
        }
        if (this.queryExpression == null ? other.queryExpression != null : !this.queryExpression.equals(other.queryExpression)) {
            return false;
        }
        if (this.values == null ? other.values != null : !this.values.equals(other.values)) {
            return false;
        }
        return !(this.variables == null ? other.variables != null : !this.variables.equals(other.variables));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Insert clone() {
        Insert clone = new Insert(this.parser, this.id);
        if (this.getGroup() != null) {
            clone.setGroup(this.getGroup().clone());
        }
        if (this.getVariables() != null) {
            clone.setVariables(this.cloneList(this.getVariables()));
        }
        if (this.getValues() != null) {
            clone.setValues(this.cloneList(this.getValues()));
        }
        if (this.getQueryExpression() != null) {
            clone.setQueryExpression(this.getQueryExpression().clone());
        }
        if (this.getConstraint() != null) {
            clone.setConstraint(this.getConstraint().clone());
        }
        clone.setMerge(this.isMerge());
        if (this.getSourceHint() != null) {
            clone.setSourceHint(this.getSourceHint());
        }
        if (this.getOption() != null) {
            clone.setOption(this.getOption().clone());
        }
        this.copyMetadataState(clone);
        return clone;
    }
}

