/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.query.mapping.xml.Namespace;

public final class MappingNodeConstants {
    public static final int SEARCH_UP = 2;
    public static final int SEARCH_DOWN = 3;
    public static final int SEARCH_DOWN_BREADTH_FIRST = 4;
    static final List NO_CHILDREN = Collections.EMPTY_LIST;
    public static final String PATH_DELIM = ".";
    public static final Integer CARDINALITY_UNBOUNDED = new Integer(-1);
    public static final String CARDINALITY_UNBOUNDED_STRING = "unbounded";
    public static final String ATTRIBUTE = "attribute";
    public static final String ELEMENT = "element";
    public static final String COMMENT = "comment";
    public static final String SEQUENCE = "sequence";
    public static final String CHOICE = "choice";
    public static final String ALL = "all";
    public static final String CRITERIA = "criteria";
    public static final String SOURCE = "source";
    public static final Namespace NO_NAMESPACE = new Namespace("", "");
    public static final String DEFAULT_NAMESPACE_PREFIX = "";
    public static final String INSTANCES_NAMESPACE_PREFIX = "xsi";
    public static final String INSTANCES_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NAMESPACE_DECLARATION_ATTRIBUTE_NAMESPACE = "xmlns";
    public static final String NORMALIZE_TEXT_PRESERVE = "preserve";
    public static final String NORMALIZE_TEXT_REPLACE = "replace";
    public static final String NORMALIZE_TEXT_COLLAPSE = "collapse";
    public static final String NO_TYPE = "";

    private MappingNodeConstants() {
    }

    public static final Properties getProperty(String property) {
        if (property.equals("name")) {
            return Properties.NAME;
        }
        if (property.equals("namespace")) {
            return Properties.NAMESPACE_PREFIX;
        }
        if (property.equals("nodeType")) {
            return Properties.NODE_TYPE;
        }
        if (property.equals("minOccurs")) {
            return Properties.CARDINALITY_MIN_BOUND;
        }
        if (property.equals("maxOccurs")) {
            return Properties.CARDINALITY_MAX_BOUND;
        }
        if (property.equals(CRITERIA)) {
            return Properties.CRITERIA;
        }
        if (property.equals("default")) {
            return Properties.DEFAULT_VALUE;
        }
        if (property.equals("fixed")) {
            return Properties.FIXED_VALUE;
        }
        if (property.equals(SOURCE)) {
            return Properties.RESULT_SET_NAME;
        }
        if (property.equals("tempGroup")) {
            return Properties.TEMP_GROUP_NAMES;
        }
        if (property.equals("symbol")) {
            return Properties.ELEMENT_NAME;
        }
        if (property.equals(COMMENT)) {
            return Properties.COMMENT_TEXT;
        }
        if (property.equals("optional")) {
            return Properties.IS_OPTIONAL;
        }
        if (property.equals("isNillable")) {
            return Properties.IS_NILLABLE;
        }
        if (property.equals("isExcluded")) {
            return Properties.IS_EXCLUDED;
        }
        if (property.equals("isDefaultChoice")) {
            return Properties.IS_DEFAULT_CHOICE;
        }
        if (property.equals("exceptionOnDefault")) {
            return Properties.EXCEPTION_ON_DEFAULT;
        }
        if (property.equals("documentEncoding")) {
            return Properties.DOCUMENT_ENCODING;
        }
        if (property.equals("formattedDocument")) {
            return Properties.FORMATTED_DOCUMENT;
        }
        if (property.equals("isRecursive")) {
            return Properties.IS_RECURSIVE;
        }
        if (property.equals("recursionCriteria")) {
            return Properties.RECURSION_CRITERIA;
        }
        if (property.equals("recursionLimit")) {
            return Properties.RECURSION_LIMIT;
        }
        if (property.equals("recursionLimitException")) {
            return Properties.EXCEPTION_ON_RECURSION_LIMIT;
        }
        if (property.equals("recursionRootMappingClass")) {
            return Properties.RECURSION_ROOT_MAPPING_CLASS;
        }
        if (property.equals("textNormalization")) {
            return Properties.NORMALIZE_TEXT;
        }
        if (property.equals("builtInType")) {
            return Properties.BUILT_IN_TYPE;
        }
        if (property.equals("includeAlways")) {
            return Properties.ALWAYS_INCLUDE;
        }
        throw new IllegalArgumentException("Unknown property (" + property + ")");
    }

    public static final String getPropertyString(Integer property) {
        if (property.equals((Object)Properties.NAME)) {
            return "name";
        }
        if (property.equals((Object)Properties.NAMESPACE_PREFIX)) {
            return "namespace";
        }
        if (property.equals((Object)Properties.NODE_TYPE)) {
            return "nodeType";
        }
        if (property.equals((Object)Properties.CARDINALITY_MIN_BOUND)) {
            return "minOccurs";
        }
        if (property.equals((Object)Properties.CARDINALITY_MAX_BOUND)) {
            return "maxOccurs";
        }
        if (property.equals((Object)Properties.CRITERIA)) {
            return CRITERIA;
        }
        if (property.equals((Object)Properties.DEFAULT_VALUE)) {
            return "default";
        }
        if (property.equals((Object)Properties.FIXED_VALUE)) {
            return "fixed";
        }
        if (property.equals((Object)Properties.RESULT_SET_NAME)) {
            return SOURCE;
        }
        if (property.equals((Object)Properties.TEMP_GROUP_NAMES)) {
            return "tempGroup";
        }
        if (property.equals((Object)Properties.ELEMENT_NAME)) {
            return "symbol";
        }
        if (property.equals((Object)Properties.COMMENT_TEXT)) {
            return COMMENT;
        }
        if (property.equals((Object)Properties.IS_OPTIONAL)) {
            return "optional";
        }
        if (property.equals((Object)Properties.IS_NILLABLE)) {
            return "isNillable";
        }
        if (property.equals((Object)Properties.IS_EXCLUDED)) {
            return "isExcluded";
        }
        if (property.equals((Object)Properties.IS_DEFAULT_CHOICE)) {
            return "isDefaultChoice";
        }
        if (property.equals((Object)Properties.EXCEPTION_ON_DEFAULT)) {
            return "exceptionOnDefault";
        }
        if (property.equals((Object)Properties.DOCUMENT_ENCODING)) {
            return "documentEncoding";
        }
        if (property.equals((Object)Properties.FORMATTED_DOCUMENT)) {
            return "formattedDocument";
        }
        if (property.equals((Object)Properties.IS_RECURSIVE)) {
            return "isRecursive";
        }
        if (property.equals((Object)Properties.RECURSION_CRITERIA)) {
            return "recursionCriteria";
        }
        if (property.equals((Object)Properties.RECURSION_LIMIT)) {
            return "recursionLimit";
        }
        if (property.equals((Object)Properties.EXCEPTION_ON_RECURSION_LIMIT)) {
            return "recursionLimitException";
        }
        if (property.equals((Object)Properties.RECURSION_ROOT_MAPPING_CLASS)) {
            return "recursionRootMappingClass";
        }
        if (property.equals((Object)Properties.NORMALIZE_TEXT)) {
            return "textNormalization";
        }
        if (property.equals((Object)Properties.BUILT_IN_TYPE)) {
            return "builtInType";
        }
        if (property.equals((Object)Properties.ALWAYS_INCLUDE)) {
            return "includeAlways";
        }
        throw new IllegalArgumentException("Unknown property (" + property + ")");
    }

    public static final class Defaults {
        public static final Map<Properties, Object> DEFAULT_VALUES;
        public static final Integer DEFAULT_CARDINALITY_MINIMUM_BOUND;
        public static final Integer DEFAULT_CARDINALITY_MAXIMUM_BOUND;
        public static final String DEFAULT_NODE_TYPE = "element";
        public static final Boolean DEFAULT_IS_NILLABLE;
        public static final Collection DEFAULT_TEMP_GROUP_NAMES;
        public static final Boolean DEFAULT_IS_OPTIONAL;
        public static final String DEFAULT_NORMALIZE_TEXT = "preserve";
        public static final String DEFAULT_BUILT_IN_TYPE = "";
        public static final Boolean DEFAULT_IS_EXCLUDED;
        public static final Boolean DEFAULT_IS_INCLUDED;
        public static final Boolean DEFAULT_IS_DEFAULT_CHOICE;
        public static final Boolean DEFAULT_EXCEPTION_ON_DEFAULT;
        public static final Boolean DEFAULT_IS_RECURSIVE;
        public static final Boolean DEFAULT_IS_RECURSIVE_ROOT;
        public static final Integer DEFAULT_RECURSION_LIMIT;
        public static final Boolean DEFAULT_EXCEPTION_ON_RECURSION_LIMIT;
        public static final String DEFAULT_DOCUMENT_ENCODING = "UTF-8";
        public static final Boolean DEFAULT_FORMATTED_DOCUMENT;

        static {
            DEFAULT_CARDINALITY_MINIMUM_BOUND = new Integer(1);
            DEFAULT_CARDINALITY_MAXIMUM_BOUND = new Integer(1);
            DEFAULT_IS_NILLABLE = Boolean.FALSE;
            DEFAULT_TEMP_GROUP_NAMES = Collections.EMPTY_LIST;
            DEFAULT_IS_OPTIONAL = Boolean.FALSE;
            DEFAULT_IS_EXCLUDED = Boolean.FALSE;
            DEFAULT_IS_INCLUDED = Boolean.FALSE;
            DEFAULT_IS_DEFAULT_CHOICE = Boolean.FALSE;
            DEFAULT_EXCEPTION_ON_DEFAULT = Boolean.FALSE;
            DEFAULT_IS_RECURSIVE = Boolean.FALSE;
            DEFAULT_IS_RECURSIVE_ROOT = Boolean.FALSE;
            DEFAULT_RECURSION_LIMIT = new Integer(10);
            DEFAULT_EXCEPTION_ON_RECURSION_LIMIT = Boolean.FALSE;
            DEFAULT_FORMATTED_DOCUMENT = Boolean.FALSE;
            HashMap<Properties, Object> temp = new HashMap<Properties, Object>();
            temp.put(Properties.CARDINALITY_MIN_BOUND, DEFAULT_CARDINALITY_MINIMUM_BOUND);
            temp.put(Properties.CARDINALITY_MAX_BOUND, DEFAULT_CARDINALITY_MAXIMUM_BOUND);
            temp.put(Properties.NODE_TYPE, "element");
            temp.put(Properties.IS_NILLABLE, DEFAULT_IS_NILLABLE);
            temp.put(Properties.TEMP_GROUP_NAMES, DEFAULT_TEMP_GROUP_NAMES);
            temp.put(Properties.IS_OPTIONAL, DEFAULT_IS_OPTIONAL);
            temp.put(Properties.IS_EXCLUDED, DEFAULT_IS_EXCLUDED);
            temp.put(Properties.IS_INCLUDED, DEFAULT_IS_INCLUDED);
            temp.put(Properties.IS_DEFAULT_CHOICE, DEFAULT_IS_DEFAULT_CHOICE);
            temp.put(Properties.EXCEPTION_ON_DEFAULT, DEFAULT_EXCEPTION_ON_DEFAULT);
            temp.put(Properties.IS_RECURSIVE, DEFAULT_IS_RECURSIVE);
            temp.put(Properties.IS_RECURSIVE_ROOT, DEFAULT_IS_RECURSIVE_ROOT);
            temp.put(Properties.RECURSION_LIMIT, DEFAULT_RECURSION_LIMIT);
            temp.put(Properties.EXCEPTION_ON_RECURSION_LIMIT, DEFAULT_EXCEPTION_ON_RECURSION_LIMIT);
            temp.put(Properties.DOCUMENT_ENCODING, DEFAULT_DOCUMENT_ENCODING);
            temp.put(Properties.FORMATTED_DOCUMENT, DEFAULT_FORMATTED_DOCUMENT);
            temp.put(Properties.NORMALIZE_TEXT, "preserve");
            DEFAULT_VALUES = Collections.unmodifiableMap(temp);
        }

        private Defaults() {
        }
    }

    public static enum Properties {
        NAME,
        NAMESPACE_PREFIX,
        NAMESPACE_DECLARATIONS,
        NODE_TYPE,
        CARDINALITY_MIN_BOUND,
        CARDINALITY_MAX_BOUND,
        CRITERIA,
        DEFAULT_VALUE,
        FIXED_VALUE,
        IS_NILLABLE,
        IS_EXCLUDED,
        RESULT_SET_NAME,
        TEMP_GROUP_NAMES,
        ELEMENT_NAME,
        IS_INCLUDED,
        COMMENT_TEXT,
        IS_OPTIONAL,
        NORMALIZE_TEXT,
        BUILT_IN_TYPE,
        IS_DEFAULT_CHOICE,
        EXCEPTION_ON_DEFAULT,
        IS_RECURSIVE,
        RECURSION_CRITERIA,
        RECURSION_LIMIT,
        EXCEPTION_ON_RECURSION_LIMIT,
        RECURSION_ROOT_MAPPING_CLASS,
        IS_RECURSIVE_ROOT,
        DOCUMENT_ENCODING,
        FORMATTED_DOCUMENT,
        ALWAYS_INCLUDE,
        ALIAS_RESULT_SET_NAME,
        RESULT_SET_INFO;

    }

    public static final class Tags {
        public static final String MAPPING_ROOT_NAME = "xmlMapping";
        public static final String MAPPING_NODE_NAME = "mappingNode";
        public static final String NAME = "name";
        public static final String NAMESPACE_PREFIX = "namespace";
        public static final String NAMESPACE_DECLARATION = "namespaceDeclaration";
        public static final String NAMESPACE_DECLARATION_PREFIX = "prefix";
        public static final String NAMESPACE_DECLARATION_URI = "uri";
        public static final String NODE_TYPE = "nodeType";
        public static final String CARDINALITY_MIN_BOUND = "minOccurs";
        public static final String CARDINALITY_MAX_BOUND = "maxOccurs";
        public static final String CRITERIA = "criteria";
        public static final String DEFAULT_VALUE = "default";
        public static final String FIXED_VALUE = "fixed";
        public static final String RESULT_SET_NAME = "source";
        public static final String TEMP_GROUP_NAME = "tempGroup";
        public static final String ELEMENT_NAME = "symbol";
        public static final String COMMENT_TEXT = "comment";
        public static final String IS_OPTIONAL = "optional";
        public static final String IS_NILLABLE = "isNillable";
        public static final String IS_EXCLUDED = "isExcluded";
        public static final String IS_DEFAULT_CHOICE = "isDefaultChoice";
        public static final String EXCEPTION_ON_DEFAULT = "exceptionOnDefault";
        public static final String DOCUMENT_ENCODING = "documentEncoding";
        public static final String NORMALIZE_TEXT = "textNormalization";
        public static final String BUILT_IN_TYPE = "builtInType";
        public static final String FORMATTED_DOCUMENT = "formattedDocument";
        public static final String IS_RECURSIVE = "isRecursive";
        public static final String RECURSION_CRITERIA = "recursionCriteria";
        public static final String RECURSION_LIMIT = "recursionLimit";
        public static final String RECURSION_LIMIT_EXCEPTION = "recursionLimitException";
        public static final String RECURSION_ROOT_MAPPING_CLASS = "recursionRootMappingClass";
        public static final String ALWAYS_INCLUDE = "includeAlways";
        static final List<String> OUTPUTTER_PROPERTY_TAGS;

        static {
            List<String> temp = Arrays.asList(NAME, NODE_TYPE, NAMESPACE_PREFIX, DOCUMENT_ENCODING, FORMATTED_DOCUMENT, "criteria", DEFAULT_VALUE, FIXED_VALUE, CARDINALITY_MIN_BOUND, CARDINALITY_MAX_BOUND, "source", TEMP_GROUP_NAME, ELEMENT_NAME, "comment", IS_OPTIONAL, IS_NILLABLE, IS_EXCLUDED, IS_DEFAULT_CHOICE, EXCEPTION_ON_DEFAULT, IS_RECURSIVE, RECURSION_CRITERIA, RECURSION_LIMIT, RECURSION_LIMIT_EXCEPTION, RECURSION_ROOT_MAPPING_CLASS, NORMALIZE_TEXT, ALWAYS_INCLUDE, BUILT_IN_TYPE);
            OUTPUTTER_PROPERTY_TAGS = Collections.unmodifiableList(temp);
        }

        private Tags() {
        }
    }
}

