/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.metadata;

import java.util.Collection;
import java.util.List;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.query.function.metadata.InvalidFunctionItem;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.client.Messages;

public class FunctionMetadataValidator {
    public static final int MAX_LENGTH = 255;

    private FunctionMetadataValidator() {
    }

    public static final void validateFunctionMethods(ITeiidServerVersion teiidVersion, Collection<FunctionMethod> methods, ValidatorReport report) {
        if (methods != null) {
            for (FunctionMethod method : methods) {
                FunctionMetadataValidator.validateFunctionMethod(teiidVersion, method, report);
            }
        }
    }

    public static final void validateFunctionMethod(ITeiidServerVersion teiidVersion, FunctionMethod method, ValidatorReport report) {
        if (method == null) {
            FunctionMetadataValidator.updateReport(report, method, Messages.getString(Messages.ERR.ERR_015_001_0052, "FunctionMethod"));
            return;
        }
        try {
            FunctionMetadataValidator.validateName(teiidVersion, method.getName());
            FunctionMetadataValidator.validateDescription(method.getDescription());
            FunctionMetadataValidator.validateCategory(method.getCategory());
            FunctionMetadataValidator.validateInvocationMethod(method.getInvocationClass(), method.getInvocationMethod(), method.getPushdown());
            List<FunctionParameter> params = method.getInputParameters();
            if (params != null && !params.isEmpty()) {
                int i = 0;
                while (i < params.size()) {
                    FunctionMetadataValidator.validateFunctionParameter(teiidVersion, params.get(i));
                    ++i;
                }
            }
            FunctionMetadataValidator.validateFunctionParameter(teiidVersion, method.getOutputParameter());
        }
        catch (Exception e) {
            FunctionMetadataValidator.updateReport(report, method, e.getMessage());
        }
    }

    private static final void updateReport(ValidatorReport report, FunctionMethod method, String message) {
        report.addItem(new InvalidFunctionItem(method, message));
    }

    public static final void validateFunctionParameter(ITeiidServerVersion teiidVersion, FunctionParameter param) throws Exception {
        if (param == null) {
            throw new Exception(Messages.gs(Messages.TEIID.TEIID30427, new Object[0]));
        }
        FunctionMetadataValidator.validateName(teiidVersion, param.getName());
        FunctionMetadataValidator.validateType(teiidVersion, param.getType());
        FunctionMetadataValidator.validateDescription(param.getDescription());
    }

    public static final void validateName(ITeiidServerVersion teiidVersion, String name) throws Exception {
        FunctionMetadataValidator.validateIsNotNull(name, "Name");
        FunctionMetadataValidator.validateLength(name, 255, "Name");
        if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
            FunctionMetadataValidator.validateNameCharacters(name, "Name");
        }
    }

    public static final void validateType(ITeiidServerVersion teiidVersion, String type) throws Exception {
        FunctionMetadataValidator.validateIsNotNull(type, "Type");
        if (DataTypeManagerService.getInstance(teiidVersion).getDataTypeClass(type) == null) {
            throw new Exception(Messages.gs(Messages.TEIID.TEIID30428, type));
        }
    }

    public static final void validateDescription(String description) throws Exception {
        if (description != null) {
            FunctionMetadataValidator.validateLength(description, DataTypeManagerService.MAX_STRING_LENGTH, "Description");
        }
    }

    public static final void validateCategory(String category) throws Exception {
        FunctionMetadataValidator.validateIsNotNull(category, "Category");
        FunctionMetadataValidator.validateLength(category, 255, "Category");
    }

    public static final void validateInvocationMethod(String invocationClass, String invocationMethod, FunctionMethod.PushDown pushdown) throws Exception {
        if (pushdown == FunctionMethod.PushDown.CAN_PUSHDOWN || pushdown == FunctionMethod.PushDown.CANNOT_PUSHDOWN) {
            FunctionMetadataValidator.validateIsNotNull(invocationClass, "Invocation class");
            FunctionMetadataValidator.validateIsNotNull(invocationMethod, "Invocation method");
            FunctionMetadataValidator.validateJavaIdentifier(invocationClass, "Invocation class", true);
            FunctionMetadataValidator.validateJavaIdentifier(invocationMethod, "Invocation method", false);
        }
    }

    private static final void validateIsNotNull(Object object, String objName) throws Exception {
        if (object == null) {
            throw new Exception(Messages.gs(Messages.TEIID.TEIID30429, objName));
        }
    }

    private static final void validateLength(String string, int maxLength, String strName) throws Exception {
        if (string.length() > maxLength) {
            throw new Exception(Messages.gs(Messages.TEIID.TEIID30430, strName, new Integer(maxLength)));
        }
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private static final void validateNameCharacters(String name, String strName) throws Exception {
        if (name.indexOf(46) > 0) {
            throw new Exception(Messages.getString(Messages.ERR.ERR_015_001_0057, strName, Character.valueOf('.')));
        }
    }

    private static final void validateJavaIdentifier(String identifier, String strName, boolean allowMultiple) throws Exception {
        if (identifier.length() > 0) {
            char firstChar = identifier.charAt(0);
            if (!Character.isJavaIdentifierStart(firstChar)) {
                throw new Exception(Messages.gs(Messages.TEIID.TEIID30432, strName, new Character(firstChar)));
            }
            int i = 1;
            while (i < identifier.length()) {
                char ch = identifier.charAt(i);
                if (!(Character.isJavaIdentifierPart(ch) || allowMultiple && ch == '.')) {
                    throw new Exception(Messages.gs(Messages.TEIID.TEIID30431, strName, new Character(ch)));
                }
                ++i;
            }
            if (identifier.charAt(identifier.length() - 1) == '.') {
                throw new Exception(Messages.gs(Messages.TEIID.TEIID30434, strName));
            }
        }
    }
}

